/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import com.squareup.wire.Message;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import okio.ByteString;
import org.signal.core.util.ProtoUtil;
import org.signal.libsignal.protocol.logging.Log;
import org.whispersystems.signalservice.api.storage.SignalRecord;
import org.whispersystems.signalservice.api.storage.SignalStorageRecord;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.internal.storage.protos.GroupV1Record;

public final class SignalGroupV1Record
implements SignalRecord {
    private static final String TAG = SignalGroupV1Record.class.getSimpleName();
    private final StorageId id;
    private final GroupV1Record proto;
    private final byte[] groupId;
    private final boolean hasUnknownFields;

    public SignalGroupV1Record(StorageId id, GroupV1Record proto) {
        this.id = id;
        this.proto = proto;
        this.groupId = proto.id.toByteArray();
        this.hasUnknownFields = ProtoUtil.hasUnknownFields((Message)proto);
    }

    @Override
    public StorageId getId() {
        return this.id;
    }

    @Override
    public SignalStorageRecord asStorageRecord() {
        return SignalStorageRecord.forGroupV1(this);
    }

    @Override
    public String describeDiff(SignalRecord other) {
        if (other instanceof SignalGroupV1Record) {
            SignalGroupV1Record that = (SignalGroupV1Record)other;
            LinkedList<String> diff = new LinkedList<String>();
            if (!Arrays.equals(this.id.getRaw(), that.id.getRaw())) {
                diff.add("ID");
            }
            if (!Arrays.equals(this.groupId, that.groupId)) {
                diff.add("MasterKey");
            }
            if (!Objects.equals(this.isBlocked(), that.isBlocked())) {
                diff.add("Blocked");
            }
            if (!Objects.equals(this.isProfileSharingEnabled(), that.isProfileSharingEnabled())) {
                diff.add("ProfileSharing");
            }
            if (!Objects.equals(this.isArchived(), that.isArchived())) {
                diff.add("Archived");
            }
            if (!Objects.equals(this.isForcedUnread(), that.isForcedUnread())) {
                diff.add("ForcedUnread");
            }
            if (!Objects.equals(this.getMuteUntil(), that.getMuteUntil())) {
                diff.add("MuteUntil");
            }
            if (!Objects.equals(this.hasUnknownFields(), that.hasUnknownFields())) {
                diff.add("UnknownFields");
            }
            return ((Object)diff).toString();
        }
        return "Different class. " + this.getClass().getSimpleName() + " | " + other.getClass().getSimpleName();
    }

    public boolean hasUnknownFields() {
        return this.hasUnknownFields;
    }

    public byte[] serializeUnknownFields() {
        return this.hasUnknownFields ? this.proto.encode() : null;
    }

    public byte[] getGroupId() {
        return this.groupId;
    }

    public boolean isBlocked() {
        return this.proto.blocked;
    }

    public boolean isProfileSharingEnabled() {
        return this.proto.whitelisted;
    }

    public boolean isArchived() {
        return this.proto.archived;
    }

    public boolean isForcedUnread() {
        return this.proto.markedUnread;
    }

    public long getMuteUntil() {
        return this.proto.mutedUntilTimestamp;
    }

    public GroupV1Record toProto() {
        return this.proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalGroupV1Record that = (SignalGroupV1Record)o;
        return this.id.equals(that.id) && this.proto.equals((Object)that.proto);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.proto});
    }

    public static final class Builder {
        private StorageId id;
        private final GroupV1Record.Builder builder;

        public Builder(byte[] rawId, byte[] groupId2, byte[] serializedUnknowns) {
            this.id = StorageId.forGroupV1(rawId);
            this.builder = serializedUnknowns != null ? Builder.parseUnknowns(serializedUnknowns) : new GroupV1Record.Builder();
            this.builder.id(ByteString.of((byte[])groupId2));
        }

        public Builder setId(byte[] rawId) {
            this.id = StorageId.forGroupV1(rawId);
            return this;
        }

        public Builder setBlocked(boolean blocked) {
            this.builder.blocked(blocked);
            return this;
        }

        public Builder setProfileSharingEnabled(boolean profileSharingEnabled) {
            this.builder.whitelisted(profileSharingEnabled);
            return this;
        }

        public Builder setArchived(boolean archived) {
            this.builder.archived(archived);
            return this;
        }

        public Builder setForcedUnread(boolean forcedUnread) {
            this.builder.markedUnread(forcedUnread);
            return this;
        }

        public Builder setMuteUntil(long muteUntil) {
            this.builder.mutedUntilTimestamp(muteUntil);
            return this;
        }

        private static GroupV1Record.Builder parseUnknowns(byte[] serializedUnknowns) {
            try {
                return ((GroupV1Record)((Object)GroupV1Record.ADAPTER.decode(serializedUnknowns))).newBuilder();
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Failed to combine unknown fields!", (Throwable)e);
                return new GroupV1Record.Builder();
            }
        }

        public SignalGroupV1Record build() {
            return new SignalGroupV1Record(this.id, this.builder.build());
        }
    }
}

