/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import okio.ByteString;
import org.signal.core.util.ProtoUtil;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.internal.storage.protos.ManifestRecord;
import org.whispersystems.signalservice.internal.storage.protos.StorageManifest;

public class SignalStorageManifest {
    public static final SignalStorageManifest EMPTY = new SignalStorageManifest(0L, 1, Collections.emptyList());
    private final long version;
    private final int sourceDeviceId;
    private final List<StorageId> storageIds;
    private final Map<Integer, List<StorageId>> storageIdsByType;

    public SignalStorageManifest(long version, int sourceDeviceId, List<StorageId> storageIds) {
        this.version = version;
        this.sourceDeviceId = sourceDeviceId;
        this.storageIds = storageIds;
        this.storageIdsByType = new HashMap<Integer, List<StorageId>>();
        for (StorageId id : storageIds) {
            List<StorageId> list = this.storageIdsByType.get(id.getType());
            if (list == null) {
                list = new ArrayList<StorageId>();
            }
            list.add(id);
            this.storageIdsByType.put(id.getType(), list);
        }
    }

    public static SignalStorageManifest deserialize(byte[] serialized) {
        try {
            StorageManifest manifest = (StorageManifest)((Object)StorageManifest.ADAPTER.decode(serialized));
            ManifestRecord manifestRecord = (ManifestRecord)((Object)ManifestRecord.ADAPTER.decode(manifest.value_));
            ArrayList<StorageId> ids = new ArrayList<StorageId>(manifestRecord.identifiers.size());
            for (ManifestRecord.Identifier id : manifestRecord.identifiers) {
                ids.add(StorageId.forType(id.raw.toByteArray(), id.type.getValue()));
            }
            return new SignalStorageManifest(manifest.version, manifestRecord.sourceDevice, ids);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public long getVersion() {
        return this.version;
    }

    public int getSourceDeviceId() {
        return this.sourceDeviceId;
    }

    public String getVersionString() {
        return this.version + "." + this.sourceDeviceId;
    }

    public List<StorageId> getStorageIds() {
        return this.storageIds;
    }

    public Optional<StorageId> getAccountStorageId() {
        List<StorageId> list = this.storageIdsByType.get(ManifestRecord.Identifier.Type.ACCOUNT.getValue());
        if (list != null && list.size() > 0) {
            return Optional.of(list.get(0));
        }
        return Optional.empty();
    }

    public Map<Integer, List<StorageId>> getStorageIdsByType() {
        return this.storageIdsByType;
    }

    public byte[] serialize() {
        ArrayList<ManifestRecord.Identifier> ids = new ArrayList<ManifestRecord.Identifier>(this.storageIds.size());
        for (StorageId id : this.storageIds) {
            ManifestRecord.Identifier.Type type = ManifestRecord.Identifier.Type.Companion.fromValue(id.getType());
            if (type != null) {
                ids.add(new ManifestRecord.Identifier.Builder().type(type).raw(ByteString.of((byte[])id.getRaw())).build());
                continue;
            }
            ByteString unknownEnum = ProtoUtil.writeUnknownEnumValue((int)2, (int)id.getType());
            ids.add(new ManifestRecord.Identifier(ByteString.of((byte[])id.getRaw()), ManifestRecord.Identifier.Type.UNKNOWN, unknownEnum));
        }
        ManifestRecord manifestRecord = new ManifestRecord.Builder().identifiers(ids).sourceDevice(this.sourceDeviceId).build();
        return new StorageManifest.Builder().version(this.version).value_(manifestRecord.encodeByteString()).build().encode();
    }
}

