/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import java.util.Arrays;
import org.signal.core.util.Base64;
import org.signal.core.util.CryptoUtil;
import org.whispersystems.signalservice.api.storage.StorageItemKey;
import org.whispersystems.signalservice.api.storage.StorageManifestKey;
import org.whispersystems.util.StringUtil;

public final class StorageKey {
    private static final int LENGTH = 32;
    private final byte[] key;

    public StorageKey(byte[] key) {
        if (key.length != 32) {
            throw new AssertionError();
        }
        this.key = key;
    }

    public StorageManifestKey deriveManifestKey(long version) {
        return new StorageManifestKey(this.derive("Manifest_" + version));
    }

    public StorageItemKey deriveItemKey(byte[] key) {
        return new StorageItemKey(this.derive("Item_" + Base64.encodeWithPadding((byte[])key)));
    }

    private byte[] derive(String keyName) {
        return CryptoUtil.hmacSha256((byte[])this.key, (byte[])StringUtil.utf8(keyName));
    }

    public byte[] serialize() {
        return (byte[])this.key.clone();
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return Arrays.equals(((StorageKey)o).key, this.key);
    }

    public int hashCode() {
        return Arrays.hashCode(this.key);
    }
}

