/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.push;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.whispersystems.signalservice.api.svr.Svr3Credentials;
import org.whispersystems.signalservice.internal.push.AuthCredentials;
import org.whispersystems.signalservice.internal.push.ByteArrayDeserializerBase64;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B\u001b\u0012\u0014\b\u0001\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0004H\u0002J\f\u0010\u0011\u001a\u00020\u0004*\u00020\u0004H\u0002R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/whispersystems/signalservice/internal/push/BackupV3AuthCheckResponse;", "", "matches", "", "", "Lorg/whispersystems/signalservice/internal/push/BackupV3AuthCheckResponse$MatchData;", "(Ljava/util/Map;)V", "invalid", "", "getInvalid", "()Ljava/util/List;", "match", "Lorg/whispersystems/signalservice/api/svr/Svr3Credentials;", "getMatch", "()Lorg/whispersystems/signalservice/api/svr/Svr3Credentials;", "toAuthCredential", "Lorg/whispersystems/signalservice/internal/push/AuthCredentials;", "toBasic", "MatchData", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nBackupV3AuthCheckResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackupV3AuthCheckResponse.kt\norg/whispersystems/signalservice/internal/push/BackupV3AuthCheckResponse\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,75:1\n288#2,2:76\n1549#2:85\n1620#2,3:86\n494#3,7:78\n*S KotlinDebug\n*F\n+ 1 BackupV3AuthCheckResponse.kt\norg/whispersystems/signalservice/internal/push/BackupV3AuthCheckResponse\n*L\n37#1:76,2\n43#1:85\n43#1:86,3\n43#1:78,7\n*E\n"})
public final class BackupV3AuthCheckResponse {
    @NotNull
    private final Map<String, MatchData> matches;
    @Nullable
    private final Svr3Credentials match;
    @NotNull
    private final List<String> invalid;

    /*
     * WARNING - void declaration
     */
    public BackupV3AuthCheckResponse(@JsonProperty @NotNull Map<String, MatchData> matches) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$filterValues$iv;
        Svr3Credentials svr3Credentials;
        Object v0;
        Object it;
        BackupV3AuthCheckResponse backupV3AuthCheckResponse;
        block5: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter(matches, (String)"matches");
            this.matches = matches;
            Iterable iterable = this.matches.entrySet();
            backupV3AuthCheckResponse = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!((MatchData)it.getValue()).isMatch()) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        BackupV3AuthCheckResponse backupV3AuthCheckResponse2 = backupV3AuthCheckResponse;
        Map.Entry entry = v0;
        if (entry != null) {
            void it2;
            Map.Entry $i$f$firstOrNull = entry;
            backupV3AuthCheckResponse = backupV3AuthCheckResponse2;
            boolean bl = false;
            AuthCredentials credential = this.toAuthCredential((String)it2.getKey());
            String string = credential.username();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"username(...)");
            String string2 = credential.password();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"password(...)");
            svr3Credentials = new Svr3Credentials(string, string2, ((MatchData)it2.getValue()).getShareSet());
            backupV3AuthCheckResponse2 = backupV3AuthCheckResponse;
        } else {
            svr3Credentials = null;
        }
        backupV3AuthCheckResponse2.match = svr3Credentials;
        Map<String, MatchData> map = this.matches;
        backupV3AuthCheckResponse = this;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            it = (MatchData)entry$iv.getValue();
            boolean bl = false;
            if (!((MatchData)it).isInvalid()) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterValues$iv = ((Map)result$iv).keySet();
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toBasic((String)it3));
        }
        backupV3AuthCheckResponse.invalid = (List)destination$iv$iv;
    }

    @Nullable
    public final Svr3Credentials getMatch() {
        return this.match;
    }

    @NotNull
    public final List<String> getInvalid() {
        return this.invalid;
    }

    private final AuthCredentials toAuthCredential(String $this$toAuthCredential) {
        int firstColonIndex = StringsKt.indexOf$default((CharSequence)$this$toAuthCredential, (String)":", (int)0, (boolean)false, (int)6, null);
        if (firstColonIndex < 0) {
            throw new IOException("Invalid credential returned!");
        }
        String string = $this$toAuthCredential.substring(0, firstColonIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String username = string;
        String string2 = $this$toAuthCredential.substring(firstColonIndex + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String password = string2;
        AuthCredentials authCredentials = AuthCredentials.create(username, password);
        Intrinsics.checkNotNullExpressionValue((Object)authCredentials, (String)"create(...)");
        return authCredentials;
    }

    private final String toBasic(String $this$toBasic) {
        Charset charset = StandardCharsets.ISO_8859_1;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"ISO_8859_1");
        return "Basic " + ByteString.Companion.encodeString($this$toBasic, charset).base64();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/whispersystems/signalservice/internal/push/BackupV3AuthCheckResponse$MatchData;", "", "status", "", "shareSet", "", "(Ljava/lang/String;[B)V", "isInvalid", "", "()Z", "isMatch", "getShareSet", "()[B", "getStatus", "()Ljava/lang/String;", "signal-service-java"})
    public static final class MatchData {
        @NotNull
        private final String status;
        @NotNull
        private final byte[] shareSet;
        private final boolean isMatch;
        private final boolean isInvalid;

        public MatchData(@JsonProperty @NotNull String status, @JsonProperty @JsonDeserialize(using=ByteArrayDeserializerBase64.class) @NotNull byte[] shareSet) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)shareSet, (String)"shareSet");
            this.status = status;
            this.shareSet = shareSet;
            this.isMatch = Intrinsics.areEqual((Object)this.status, (Object)"match");
            this.isInvalid = Intrinsics.areEqual((Object)this.status, (Object)"invalid");
        }

        @NotNull
        public final String getStatus() {
            return this.status;
        }

        @NotNull
        public final byte[] getShareSet() {
            return this.shareSet;
        }

        public final boolean isMatch() {
            return this.isMatch;
        }

        public final boolean isInvalid() {
            return this.isInvalid;
        }
    }
}

