/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal;

import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.security.Provider;
import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.DefaultSettings;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.asamk.signal.App;
import org.asamk.signal.Shutdown;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.RateLimitErrorException;
import org.asamk.signal.commands.exceptions.UnexpectedErrorException;
import org.asamk.signal.commands.exceptions.UntrustedKeyErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.logging.LogConfigurator;
import org.asamk.signal.manager.ManagerLogger;
import org.asamk.signal.util.SecurityProvider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Main {
    public static void main(String[] args) {
        Security.setProperty("crypto.policy", "unlimited");
        Main.installSecurityProviderWorkaround();
        LoggingConfig loggingConfig = Main.parseLoggingConfig(args);
        Main.configureLogging(loggingConfig);
        ArgumentParser parser = App.buildArgumentParser();
        Namespace ns = parser.parseArgsOrFail(args);
        int status = 0;
        try {
            new App(ns).init();
        }
        catch (CommandException e) {
            System.err.println(e.getMessage());
            if (loggingConfig.verboseLevel > 0 && e.getCause() != null) {
                e.getCause().printStackTrace(System.err);
            }
            status = Main.getStatusForError(e);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            status = 2;
        }
        Shutdown.shutdownComplete();
        System.exit(status);
    }

    private static void installSecurityProviderWorkaround() {
        Security.insertProviderAt(new SecurityProvider(), 1);
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    private static LoggingConfig parseLoggingConfig(String[] args) {
        Namespace nsLog = Main.parseArgs(args);
        if (nsLog == null) {
            return new LoggingConfig(0, null, false);
        }
        Integer verboseLevel = nsLog.getInt("verbose");
        File logFile = (File)nsLog.get("log-file");
        Boolean scrubLog = nsLog.getBoolean("scrub-log");
        return new LoggingConfig(verboseLevel, logFile, scrubLog);
    }

    private static Namespace parseArgs(String[] args) {
        ArgumentParser parser = ArgumentParsers.newFor((String)"signal-cli", (DefaultSettings)DefaultSettings.VERSION_0_9_0_DEFAULT_SETTINGS).includeArgumentNamesAsKeysInResult(true).build().defaultHelp(false);
        parser.addArgument(new String[]{"-v", "--verbose"}).action((ArgumentAction)Arguments.count());
        parser.addArgument(new String[]{"--log-file"}).type(File.class);
        parser.addArgument(new String[]{"--scrub-log"}).action((ArgumentAction)Arguments.storeTrue());
        try {
            return parser.parseKnownArgs(args, null);
        }
        catch (ArgumentParserException e) {
            return null;
        }
    }

    private static void configureLogging(LoggingConfig loggingConfig) {
        LogConfigurator.setVerboseLevel(loggingConfig.verboseLevel);
        LogConfigurator.setLogFile(loggingConfig.logFile);
        LogConfigurator.setScrubSensitiveInformation(loggingConfig.scrubLog);
        if (loggingConfig.verboseLevel > 0) {
            Logger.getLogger("").setLevel(loggingConfig.verboseLevel > 2 ? Level.FINEST : Level.INFO);
            ManagerLogger.initLogger();
        }
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    private static int getStatusForError(CommandException e) {
        CommandException commandException = e;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UserErrorException.class, UnexpectedErrorException.class, IOErrorException.class, UntrustedKeyErrorException.class, RateLimitErrorException.class}, (Object)commandException, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                UserErrorException userErrorException = (UserErrorException)commandException;
                yield 1;
            }
            case 1 -> {
                UnexpectedErrorException unexpectedErrorException = (UnexpectedErrorException)commandException;
                yield 2;
            }
            case 2 -> {
                IOErrorException ioErrorException = (IOErrorException)commandException;
                yield 3;
            }
            case 3 -> {
                UntrustedKeyErrorException untrustedKeyErrorException = (UntrustedKeyErrorException)commandException;
                yield 4;
            }
            case 4 -> {
                RateLimitErrorException rateLimitErrorException = (RateLimitErrorException)commandException;
                yield 5;
            }
            case -1 -> 2;
        };
    }

    private record LoggingConfig(int verboseLevel, File logFile, boolean scrubLog) {
    }
}

