/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.File;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.InetSocketAddress;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.DbusConfig;
import org.asamk.signal.OutputType;
import org.asamk.signal.ReceiveMessageHandler;
import org.asamk.signal.Shutdown;
import org.asamk.signal.commands.LocalCommand;
import org.asamk.signal.commands.MultiLocalCommand;
import org.asamk.signal.commands.ReceiveMode;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.dbus.DbusHandler;
import org.asamk.signal.http.HttpServerHandler;
import org.asamk.signal.json.JsonReceiveMessageHandler;
import org.asamk.signal.jsonrpc.SocketHandler;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.MultiAccountManager;
import org.asamk.signal.manager.api.ReceiveConfig;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;
import org.asamk.signal.util.CommandUtil;
import org.asamk.signal.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaemonCommand
implements MultiLocalCommand,
LocalCommand {
    private static final Logger logger = LoggerFactory.getLogger(DaemonCommand.class);

    @Override
    public String getName() {
        return "daemon";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        File defaultSocketPath = new File(new File(IOUtils.getRuntimeDir(), "signal-cli"), "socket");
        subparser.help("Run in daemon mode and provide a JSON-RPC or an experimental dbus interface.");
        subparser.addArgument(new String[]{"--dbus"}).action((ArgumentAction)Arguments.storeTrue()).help("Expose a DBus interface on the user bus.");
        subparser.addArgument(new String[]{"--dbus-system", "--system"}).action((ArgumentAction)Arguments.storeTrue()).help("Expose a DBus interface on the system bus.");
        subparser.addArgument(new String[]{"--bus-name"}).setDefault((Object)DbusConfig.getBusname()).help("Specify the D-Bus bus name to connect to.");
        subparser.addArgument(new String[]{"--socket"}).nargs("?").type(File.class).setConst((Object)defaultSocketPath).help("Expose a JSON-RPC interface on a UNIX socket (default $XDG_RUNTIME_DIR/signal-cli/socket).");
        subparser.addArgument(new String[]{"--tcp"}).nargs("?").setConst((Object)"localhost:7583").help("Expose a JSON-RPC interface on a TCP socket (default localhost:7583).");
        subparser.addArgument(new String[]{"--http"}).nargs("?").setConst((Object)"localhost:8080").help("Expose a JSON-RPC interface as http endpoint (default localhost:8080).");
        subparser.addArgument(new String[]{"--no-receive-stdout"}).help("Don\u2019t print received messages to stdout.").action((ArgumentAction)Arguments.storeTrue());
        subparser.addArgument(new String[]{"--receive-mode"}).help("Specify when to start receiving messages.").type((ArgumentType)Arguments.enumStringType(ReceiveMode.class)).setDefault((Object)ReceiveMode.ON_START);
        subparser.addArgument(new String[]{"--ignore-attachments"}).help("Don\u2019t download attachments of received messages.").action((ArgumentAction)Arguments.storeTrue());
        subparser.addArgument(new String[]{"--ignore-stories"}).help("Don\u2019t receive story messages from the server.").action((ArgumentAction)Arguments.storeTrue());
        subparser.addArgument(new String[]{"--send-read-receipts"}).help("Send read receipts for all incoming data messages (in addition to the default delivery receipts)").action((ArgumentAction)Arguments.storeTrue());
    }

    @Override
    public List<OutputType> getSupportedOutputTypes() {
        return List.of(OutputType.PLAIN_TEXT, OutputType.JSON);
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        Shutdown.installHandler();
        logger.info("Starting daemon in single-account mode for " + m.getSelfNumber());
        boolean noReceiveStdOut = Boolean.TRUE.equals(ns.getBoolean("no-receive-stdout"));
        ReceiveMode receiveMode = (ReceiveMode)((Object)ns.get("receive-mode"));
        ReceiveConfig receiveConfig = CommandUtil.getReceiveConfig(ns);
        m.setReceiveConfig(receiveConfig);
        this.addDefaultReceiveHandler(m, noReceiveStdOut ? null : outputWriter, receiveMode != ReceiveMode.ON_START);
        try (SingleAccountDaemonHandler daemonHandler = new SingleAccountDaemonHandler(m, receiveMode);){
            DaemonCommand.setup(ns, daemonHandler);
            m.addClosedListener(Shutdown::triggerShutdown);
            try {
                Shutdown.waitForShutdown();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCommand(Namespace ns, MultiAccountManager c, OutputWriter outputWriter) throws CommandException {
        Shutdown.installHandler();
        logger.info("Starting daemon in multi-account mode");
        boolean noReceiveStdOut = Boolean.TRUE.equals(ns.getBoolean("no-receive-stdout"));
        ReceiveMode receiveMode = (ReceiveMode)((Object)ns.get("receive-mode"));
        ReceiveConfig receiveConfig = CommandUtil.getReceiveConfig(ns);
        c.getManagers().forEach(m -> {
            m.setReceiveConfig(receiveConfig);
            this.addDefaultReceiveHandler((Manager)m, noReceiveStdOut ? null : outputWriter, receiveMode != ReceiveMode.ON_START);
        });
        c.addOnManagerAddedHandler(m -> {
            m.setReceiveConfig(receiveConfig);
            this.addDefaultReceiveHandler((Manager)m, noReceiveStdOut ? null : outputWriter, receiveMode != ReceiveMode.ON_START);
        });
        try (MultiAccountDaemonHandler daemonHandler = new MultiAccountDaemonHandler(c, receiveMode);){
            DaemonCommand.setup(ns, daemonHandler);
            DaemonCommand daemonCommand = this;
            synchronized (daemonCommand) {
                try {
                    Shutdown.waitForShutdown();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private static void setup(Namespace ns, DaemonHandler daemonHandler) throws CommandException {
        boolean isDbusSession;
        boolean isDbusSystem;
        String httpAddress;
        String tcpAddress;
        ServerSocketChannel inheritedChannel;
        try {
            Channel channel = System.inheritedChannel();
            if (channel instanceof ServerSocketChannel) {
                ServerSocketChannel serverChannel;
                inheritedChannel = serverChannel = (ServerSocketChannel)channel;
                logger.info("Using inherited socket: " + String.valueOf(serverChannel.getLocalAddress()));
                daemonHandler.runSocket(serverChannel);
            } else {
                inheritedChannel = null;
            }
        }
        catch (IOException e) {
            throw new IOErrorException("Failed to use inherited socket", e);
        }
        File socketFile = (File)ns.get("socket");
        if (socketFile != null) {
            UnixDomainSocketAddress address = UnixDomainSocketAddress.of(socketFile.toPath());
            ServerSocketChannel serverChannel = IOUtils.bindSocket(address);
            daemonHandler.runSocket(serverChannel);
        }
        if ((tcpAddress = ns.getString("tcp")) != null) {
            InetSocketAddress address = IOUtils.parseInetSocketAddress(tcpAddress);
            ServerSocketChannel serverChannel = IOUtils.bindSocket(address);
            daemonHandler.runSocket(serverChannel);
        }
        if ((httpAddress = ns.getString("http")) != null) {
            InetSocketAddress address = IOUtils.parseInetSocketAddress(httpAddress);
            daemonHandler.runHttp(address);
        }
        if (isDbusSystem = Boolean.TRUE.equals(ns.getBoolean("dbus-system"))) {
            String busName = ns.getString("bus-name");
            daemonHandler.runDbus(true, busName);
        }
        if (isDbusSession = Boolean.TRUE.equals(ns.getBoolean("dbus"))) {
            String busName = ns.getString("bus-name");
            daemonHandler.runDbus(false, busName);
        }
        if (!isDbusSystem && !isDbusSession && socketFile == null && tcpAddress == null && httpAddress == null && inheritedChannel == null) {
            logger.warn("Running daemon command without explicit mode is deprecated. Use 'daemon --dbus' to use the dbus interface.");
            daemonHandler.runDbus(false, DbusConfig.getBusname());
        }
    }

    private void addDefaultReceiveHandler(Manager m, OutputWriter outputWriter, boolean isWeakListener) {
        OutputWriter outputWriter2 = outputWriter;
        int n = 0;
        Manager.ReceiveMessageHandler handler = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlainTextWriter.class, JsonWriter.class}, (Object)outputWriter2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PlainTextWriter writer = (PlainTextWriter)outputWriter2;
                yield new ReceiveMessageHandler(m, writer);
            }
            case 1 -> {
                JsonWriter writer = (JsonWriter)outputWriter2;
                yield new JsonReceiveMessageHandler(m, writer);
            }
            case -1 -> Manager.ReceiveMessageHandler.EMPTY;
        };
        m.addReceiveHandler(handler, isWeakListener);
    }

    private static final class SingleAccountDaemonHandler
    extends DaemonHandler {
        private final Manager m;

        public SingleAccountDaemonHandler(Manager m, ReceiveMode receiveMode) {
            super(receiveMode);
            this.m = m;
        }

        @Override
        public void runSocket(ServerSocketChannel serverChannel) {
            this.runSocket(new SocketHandler(serverChannel, this.m, this.receiveMode == ReceiveMode.MANUAL));
        }

        @Override
        public void runDbus(boolean isDbusSystem, String busname) throws CommandException {
            this.runDbus(new DbusHandler(isDbusSystem, busname, this.m, this.receiveMode != ReceiveMode.ON_START));
        }

        @Override
        public void runHttp(InetSocketAddress address) throws CommandException {
            this.runHttp(new HttpServerHandler(address, this.m));
        }
    }

    private static abstract class DaemonHandler
    implements AutoCloseable {
        protected final ReceiveMode receiveMode;
        protected final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();

        protected DaemonHandler(ReceiveMode receiveMode) {
            this.receiveMode = receiveMode;
        }

        public abstract void runSocket(ServerSocketChannel var1) throws CommandException;

        public abstract void runDbus(boolean var1, String var2) throws CommandException;

        public abstract void runHttp(InetSocketAddress var1) throws CommandException;

        protected final void runSocket(SocketHandler socketHandler) {
            socketHandler.init();
            this.closeables.add(socketHandler);
        }

        protected final void runDbus(DbusHandler dbusHandler) throws CommandException {
            dbusHandler.init();
            this.closeables.add(dbusHandler);
        }

        protected final void runHttp(HttpServerHandler handler) throws CommandException {
            try {
                handler.init();
            }
            catch (IOException ex) {
                throw new IOErrorException("Failed to initialize HTTP Server", ex);
            }
            this.closeables.add(handler);
        }

        @Override
        public void close() {
            for (AutoCloseable closeable : new ArrayList<AutoCloseable>(this.closeables)) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    logger.warn("Failed to close daemon handler", (Throwable)e);
                }
            }
            this.closeables.clear();
        }
    }

    private static final class MultiAccountDaemonHandler
    extends DaemonHandler {
        private final MultiAccountManager c;

        public MultiAccountDaemonHandler(MultiAccountManager c, ReceiveMode receiveMode) {
            super(receiveMode);
            this.c = c;
        }

        @Override
        public void runSocket(ServerSocketChannel serverChannel) {
            this.runSocket(new SocketHandler(serverChannel, this.c, this.receiveMode == ReceiveMode.MANUAL));
        }

        @Override
        public void runDbus(boolean isDbusSystem, String busname) throws CommandException {
            this.runDbus(new DbusHandler(isDbusSystem, busname, this.c, this.receiveMode != ReceiveMode.ON_START));
        }

        @Override
        public void runHttp(InetSocketAddress address) throws CommandException {
            this.runHttp(new HttpServerHandler(address, this.c));
        }
    }
}

