/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.lang.runtime.SwitchBootstraps;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.json.JsonContact;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.Contact;
import org.asamk.signal.manager.api.PhoneNumberSharingMode;
import org.asamk.signal.manager.api.Profile;
import org.asamk.signal.manager.api.Recipient;
import org.asamk.signal.manager.api.RecipientAddress;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;
import org.asamk.signal.util.CommandUtil;

public class ListContactsCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "listContacts";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Show a list of known contacts with names and profiles.");
        subparser.addArgument(new String[]{"recipient"}).help("Specify one ore more phone numbers to show.").nargs("*");
        subparser.addArgument(new String[]{"-a", "--all-recipients"}).action((ArgumentAction)Arguments.storeTrue()).help("Include all known recipients, not only contacts.");
        subparser.addArgument(new String[]{"--blocked"}).type(Boolean.class).help("Specify if only blocked or unblocked contacts should be shown (default: all contacts)");
        subparser.addArgument(new String[]{"--name"}).help("Find contacts with the given contact or profile name.");
        subparser.addArgument(new String[]{"--detailed"}).action((ArgumentAction)Arguments.storeTrue()).help("List the contacts with more details. If output=json, then this is always set");
        subparser.addArgument(new String[]{"--internal"}).action((ArgumentAction)Arguments.storeTrue()).help("Include internal information that's normally not user visible");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        boolean allRecipients = Boolean.TRUE.equals(ns.getBoolean("all-recipients"));
        Boolean blocked = ns.getBoolean("blocked");
        List recipientStrings = ns.getList("recipient");
        Set<RecipientIdentifier.Single> recipientIdentifiers = CommandUtil.getSingleRecipientIdentifiers(recipientStrings, m.getSelfNumber());
        String name = ns.getString("name");
        List recipients = m.getRecipients(!allRecipients, Optional.ofNullable(blocked), recipientIdentifiers, Optional.ofNullable(name));
        boolean detailed = Boolean.TRUE.equals(ns.getBoolean("detailed"));
        boolean internal = Boolean.TRUE.equals(ns.getBoolean("internal"));
        OutputWriter outputWriter2 = outputWriter;
        Objects.requireNonNull(outputWriter2);
        OutputWriter outputWriter3 = outputWriter2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlainTextWriter.class, JsonWriter.class}, (Object)outputWriter3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                PlainTextWriter writer = (PlainTextWriter)outputWriter3;
                for (Recipient r2 : recipients) {
                    Contact contact = r2.getContact() == null ? Contact.newBuilder().build() : r2.getContact();
                    Profile profile = r2.getProfile() == null ? Profile.newBuilder().build() : r2.getProfile();
                    writer.println("Number: {} ACI: {} Name: {} Profile name: {} Username: {} Color: {} Blocked: {} Message expiration: {}", r2.getAddress().number().orElse(""), r2.getAddress().aci().orElse(""), contact.getName(), profile.getDisplayName(), r2.getAddress().username().orElse(""), Optional.ofNullable(contact.color()).orElse(""), contact.isBlocked(), contact.messageExpirationTime() == 0 ? "disabled" : contact.messageExpirationTime() + "s");
                    if (detailed) {
                        writer.indentedWriter().println("PNI: {} Given name: {} Family name: {}, Nick name: {} Nick given name: {} Nick family name {} Note: {} Archived: {} Hidden: {} Profile sharing: {} About: {} About Emoji: {} Unregistered: {}", r2.getAddress().pni().orElse(""), Optional.ofNullable(r2.getContact().givenName()).orElse(""), Optional.ofNullable(r2.getContact().familyName()).orElse(""), Optional.ofNullable(r2.getContact().nickName()).orElse(""), Optional.ofNullable(r2.getContact().nickNameGivenName()).orElse(""), Optional.ofNullable(r2.getContact().nickNameFamilyName()).orElse(""), Optional.ofNullable(r2.getContact().note()).orElse(""), r2.getContact().isArchived(), r2.getContact().isHidden(), r2.getContact().isProfileSharingEnabled(), Optional.ofNullable(r2.getProfile().getAbout()).orElse(""), Optional.ofNullable(r2.getProfile().getAboutEmoji()).orElse(""), r2.getContact().unregisteredTimestamp() != null);
                    }
                    if (!internal) continue;
                    writer.indentedWriter().println("Capabilities: {} Unidentified access mode: {} Shares number: {} Discoverable by number: {}", r2.getProfile().getCapabilities().stream().map(Enum::name).toList(), Optional.ofNullable(r2.getProfile().getUnidentifiedAccessMode() == Profile.UnidentifiedAccessMode.UNKNOWN ? null : r2.getProfile().getUnidentifiedAccessMode().name()).orElse(""), r2.getProfile().getPhoneNumberSharingMode() == null ? "" : String.valueOf(r2.getProfile().getPhoneNumberSharingMode() == PhoneNumberSharingMode.EVERYBODY), r2.getDiscoverable() == null ? "" : String.valueOf(r2.getDiscoverable()));
                }
                break;
            }
            case 1: {
                JsonWriter writer = (JsonWriter)outputWriter3;
                List<JsonContact> jsonContacts = recipients.stream().map(r -> {
                    Contact contact;
                    RecipientAddress address = r.getAddress();
                    Contact contact2 = contact = r.getContact() == null ? Contact.newBuilder().build() : r.getContact();
                    JsonContact.JsonInternal jsonInternal = !internal ? null : new JsonContact.JsonInternal(r.getProfile().getCapabilities().stream().map(Enum::name).toList(), r.getProfile().getUnidentifiedAccessMode() == Profile.UnidentifiedAccessMode.UNKNOWN ? null : r.getProfile().getUnidentifiedAccessMode().name(), r.getProfile().getPhoneNumberSharingMode() == null ? null : Boolean.valueOf(r.getProfile().getPhoneNumberSharingMode() == PhoneNumberSharingMode.EVERYBODY), r.getDiscoverable());
                    return new JsonContact(address.number().orElse(null), address.uuid().map(UUID::toString).orElse(null), address.username().orElse(null), contact.getName(), contact.givenName(), contact.familyName(), contact.nickName(), contact.nickNameGivenName(), contact.nickNameFamilyName(), contact.note(), contact.color(), contact.isBlocked(), contact.isHidden(), contact.messageExpirationTime(), r.getContact().isProfileSharingEnabled(), r.getContact().unregisteredTimestamp() != null, r.getProfile() == null ? null : new JsonContact.JsonProfile(r.getProfile().getLastUpdateTimestamp(), r.getProfile().getGivenName(), r.getProfile().getFamilyName(), r.getProfile().getAbout(), r.getProfile().getAboutEmoji(), r.getProfile().getAvatarUrlPath() != null, r.getProfile().getMobileCoinAddress() == null ? null : Base64.getEncoder().encodeToString(r.getProfile().getMobileCoinAddress())), jsonInternal);
                }).toList();
                writer.write(jsonContacts);
            }
        }
    }
}

