/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.Group;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.GroupInviteLinkUrl;
import org.asamk.signal.manager.api.RecipientAddress;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;
import org.asamk.signal.util.CommandUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListGroupsCommand
implements JsonRpcLocalCommand {
    private static final Logger logger = LoggerFactory.getLogger(ListGroupsCommand.class);

    @Override
    public String getName() {
        return "listGroups";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("List group information including names, ids, active status, blocked status and members");
        subparser.addArgument(new String[]{"-d", "--detailed"}).action((ArgumentAction)Arguments.storeTrue()).help("List the members and group invite links of each group. If output=json, then this is always set");
        subparser.addArgument(new String[]{"-g", "--group-id"}).help("Specify one or more group IDs to show.").nargs("*");
    }

    private static Set<String> resolveMembers(Set<RecipientAddress> addresses) {
        return addresses.stream().map(RecipientAddress::getLegacyIdentifier).collect(Collectors.toSet());
    }

    private static Set<JsonGroupMember> resolveJsonMembers(Set<RecipientAddress> addresses) {
        return addresses.stream().map(address -> new JsonGroupMember(address.number().orElse(null), address.uuid().map(UUID::toString).orElse(null))).collect(Collectors.toSet());
    }

    private static void printGroupPlainText(PlainTextWriter writer, Group group, boolean detailed) {
        if (detailed) {
            GroupInviteLinkUrl groupInviteLink = group.groupInviteLinkUrl();
            writer.println("Id: {} Name: {} Description: {} Active: {} Blocked: {} Members: {} Pending members: {} Requesting members: {} Admins: {} Banned: {} Message expiration: {} Link: {}", group.groupId().toBase64(), group.title(), group.description(), group.isMember(), group.isBlocked(), ListGroupsCommand.resolveMembers(group.members()), ListGroupsCommand.resolveMembers(group.pendingMembers()), ListGroupsCommand.resolveMembers(group.requestingMembers()), ListGroupsCommand.resolveMembers(group.adminMembers()), ListGroupsCommand.resolveMembers(group.bannedMembers()), group.messageExpirationTimer() == 0 ? "disabled" : group.messageExpirationTimer() + "s", groupInviteLink == null ? Character.valueOf('-') : groupInviteLink.getUrl());
        } else {
            writer.println("Id: {} Name: {}  Active: {} Blocked: {}", group.groupId().toBase64(), group.title(), group.isMember(), group.isBlocked());
        }
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        List<Group> groups = m.getGroups();
        List groupIdStrings = ns.getList("group-id");
        Set<GroupId> groupIds = CommandUtil.getGroupIds(groupIdStrings);
        if (!groupIds.isEmpty()) {
            groups = groups.stream().filter(g -> groupIds.contains(g.groupId())).toList();
        }
        OutputWriter outputWriter2 = outputWriter;
        Objects.requireNonNull(outputWriter2);
        OutputWriter outputWriter3 = outputWriter2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonWriter.class, PlainTextWriter.class}, (Object)outputWriter3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                JsonWriter jsonWriter = (JsonWriter)outputWriter3;
                List<JsonGroup> jsonGroups = groups.stream().map(group -> {
                    GroupInviteLinkUrl groupInviteLink = group.groupInviteLinkUrl();
                    return new JsonGroup(group.groupId().toBase64(), group.title(), group.description(), group.isMember(), group.isBlocked(), group.messageExpirationTimer(), ListGroupsCommand.resolveJsonMembers(group.members()), ListGroupsCommand.resolveJsonMembers(group.pendingMembers()), ListGroupsCommand.resolveJsonMembers(group.requestingMembers()), ListGroupsCommand.resolveJsonMembers(group.adminMembers()), ListGroupsCommand.resolveJsonMembers(group.bannedMembers()), group.permissionAddMember().name(), group.permissionEditDetails().name(), group.permissionSendMessage().name(), groupInviteLink == null ? null : groupInviteLink.getUrl());
                }).toList();
                jsonWriter.write(jsonGroups);
                break;
            }
            case 1: {
                PlainTextWriter writer = (PlainTextWriter)outputWriter3;
                boolean detailed = Boolean.TRUE.equals(ns.getBoolean("detailed"));
                for (Group group2 : groups) {
                    ListGroupsCommand.printGroupPlainText(writer, group2, detailed);
                }
            }
        }
    }

    private record JsonGroup(String id, String name, String description, boolean isMember, boolean isBlocked, int messageExpirationTime, Set<JsonGroupMember> members, Set<JsonGroupMember> pendingMembers, Set<JsonGroupMember> requestingMembers, Set<JsonGroupMember> admins, Set<JsonGroupMember> banned, String permissionAddMember, String permissionEditDetails, String permissionSendMessage, String groupInviteLink) {
    }

    private record JsonGroupMember(String number, String uuid) {
    }
}

