/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.asamk.signal.manager.api.GroupIdV2;
import org.asamk.signal.manager.api.GroupNotFoundException;
import org.asamk.signal.manager.api.NotAGroupMemberException;
import org.asamk.signal.manager.api.PhoneNumberSharingMode;
import org.asamk.signal.manager.api.Profile;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.internal.SignalDependencies;
import org.asamk.signal.manager.jobs.SyncStorageJob;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.groups.GroupInfoV2;
import org.asamk.signal.manager.storage.profiles.ProfileStore;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.util.IOUtils;
import org.asamk.signal.manager.util.KeyUtils;
import org.asamk.signal.manager.util.PaymentUtils;
import org.asamk.signal.manager.util.ProfileUtils;
import org.asamk.signal.manager.util.Utils;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.zkgroup.profiles.ExpiringProfileKeyCredential;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.crypto.SealedSenderAccess;
import org.whispersystems.signalservice.api.profiles.AvatarUploadParams;
import org.whispersystems.signalservice.api.profiles.ProfileAndCredential;
import org.whispersystems.signalservice.api.profiles.SignalServiceProfile;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.push.exceptions.NotFoundException;
import org.whispersystems.signalservice.api.push.exceptions.PushNetworkException;
import org.whispersystems.signalservice.api.services.ProfileService;
import org.whispersystems.signalservice.api.util.ExpiringProfileCredentialUtil;
import org.whispersystems.signalservice.api.util.StreamDetails;
import org.whispersystems.signalservice.internal.ServiceResponse;
import org.whispersystems.signalservice.internal.push.PaymentAddress;

public final class ProfileHelper {
    private static final Logger logger = LoggerFactory.getLogger(ProfileHelper.class);
    private final SignalAccount account;
    private final SignalDependencies dependencies;
    private final Context context;

    public ProfileHelper(Context context) {
        this.account = context.getAccount();
        this.dependencies = context.getDependencies();
        this.context = context;
    }

    public void rotateProfileKey() throws IOException {
        this.getSelfProfile();
        ProfileKey profileKey = KeyUtils.createProfileKey();
        this.account.setProfileKey(profileKey);
        this.context.getAccountHelper().updateAccountAttributes();
        this.setProfile(true, true, null, null, null, null, null, null);
        this.account.getRecipientStore().rotateSelfStorageId();
        this.context.getJobExecutor().enqueueJob(new SyncStorageJob());
        Collection<RecipientId> recipientIds = this.account.getRecipientStore().getRecipientIdsWithEnabledProfileSharing();
        for (RecipientId recipientId : recipientIds) {
            this.context.getSendHelper().sendProfileKey(recipientId);
        }
        RecipientId selfRecipientId = this.account.getSelfRecipientId();
        List<GroupIdV2> activeGroupIds = this.account.getGroupStore().getGroups().stream().filter(g -> g instanceof GroupInfoV2 && g.isMember(selfRecipientId) && g.isProfileSharingEnabled()).map(g -> (GroupInfoV2)g).map(GroupInfoV2::getGroupId).toList();
        for (GroupIdV2 groupId : activeGroupIds) {
            try {
                this.context.getGroupHelper().updateGroupProfileKey(groupId);
            }
            catch (IOException | GroupNotFoundException | NotAGroupMemberException e) {
                logger.warn("Failed to update group profile key: {}", (Object)e.getMessage());
            }
        }
    }

    public Profile getRecipientProfile(RecipientId recipientId) {
        return this.getRecipientProfile(recipientId, false);
    }

    public List<Profile> getRecipientProfiles(Collection<RecipientId> recipientIds) {
        return this.getRecipientProfiles(recipientIds, false);
    }

    public void refreshRecipientProfile(RecipientId recipientId) {
        this.getRecipientProfile(recipientId, true);
    }

    public void refreshRecipientProfiles(Collection<RecipientId> recipientIds) {
        this.getRecipientProfiles(recipientIds, true);
    }

    public List<ExpiringProfileKeyCredential> getExpiringProfileKeyCredential(List<RecipientId> recipientIds) {
        Flowable profileFetches = Flowable.fromIterable(recipientIds).filter(recipientId -> !ExpiringProfileCredentialUtil.isValid((ExpiringProfileKeyCredential)this.account.getProfileStore().getExpiringProfileKeyCredential((RecipientId)recipientId))).map(recipientId -> this.retrieveProfile((RecipientId)recipientId, SignalServiceProfile.RequestType.PROFILE_AND_CREDENTIAL).onErrorComplete());
        Maybe.merge((Publisher)profileFetches, (int)10).blockingSubscribe();
        return recipientIds.stream().map(r -> this.account.getProfileStore().getExpiringProfileKeyCredential((RecipientId)r)).toList();
    }

    public ExpiringProfileKeyCredential getExpiringProfileKeyCredential(RecipientId recipientId) {
        ExpiringProfileKeyCredential profileKeyCredential = this.account.getProfileStore().getExpiringProfileKeyCredential(recipientId);
        if (ExpiringProfileCredentialUtil.isValid((ExpiringProfileKeyCredential)profileKeyCredential)) {
            return profileKeyCredential;
        }
        try {
            this.blockingGetProfile(this.retrieveProfile(recipientId, SignalServiceProfile.RequestType.PROFILE_AND_CREDENTIAL));
        }
        catch (IOException e) {
            logger.warn("Failed to retrieve profile key credential, ignoring: {}", (Object)e.getMessage());
            return null;
        }
        return this.account.getProfileStore().getExpiringProfileKeyCredential(recipientId);
    }

    public void setProfile(String givenName, String familyName, String about, String aboutEmoji, Optional<String> avatar, byte[] mobileCoinAddress) throws IOException {
        this.setProfile(true, false, givenName, familyName, about, aboutEmoji, avatar, mobileCoinAddress);
    }

    public void setProfile(boolean uploadProfile, boolean forceUploadAvatar, String givenName, String familyName, String about, String aboutEmoji, Optional<String> avatar, byte[] mobileCoinAddress) throws IOException {
        StreamDetails streamDetails;
        Profile.Builder builder;
        Profile profile = this.getSelfProfile();
        Profile.Builder builder2 = builder = profile == null ? Profile.newBuilder() : Profile.newBuilder(profile);
        if (givenName != null) {
            builder.withGivenName(givenName);
        }
        if (familyName != null) {
            builder.withFamilyName(familyName);
        }
        if (about != null) {
            builder.withAbout(about);
        }
        if (aboutEmoji != null) {
            builder.withAboutEmoji(aboutEmoji);
        }
        if (mobileCoinAddress != null) {
            builder.withMobileCoinAddress(mobileCoinAddress);
        }
        Profile newProfile = builder.build();
        if (uploadProfile) {
            try (StreamDetails streamDetails2 = streamDetails = avatar != null && avatar.isPresent() ? Utils.createStreamDetails(avatar.get()).first() : (forceUploadAvatar && avatar == null ? this.context.getAvatarStore().retrieveProfileAvatar(this.account.getSelfRecipientAddress()) : null);){
                AvatarUploadParams avatarUploadParams = streamDetails != null ? AvatarUploadParams.forAvatar((StreamDetails)streamDetails) : (avatar == null ? AvatarUploadParams.unchanged((boolean)true) : AvatarUploadParams.unchanged((boolean)false));
                Optional<PaymentAddress> paymentsAddress = Optional.ofNullable(newProfile.getMobileCoinAddress()).map(address -> PaymentUtils.signPaymentsAddress(address, this.account.getAciIdentityKeyPair().getPrivateKey()));
                logger.debug("Uploading new profile");
                Optional avatarPath = this.dependencies.getAccountManager().setVersionedProfile(this.account.getAci(), this.account.getProfileKey(), newProfile.getInternalServiceName(), newProfile.getAbout() == null ? "" : newProfile.getAbout(), newProfile.getAboutEmoji() == null ? "" : newProfile.getAboutEmoji(), paymentsAddress, avatarUploadParams, List.of(), this.account.getConfigurationStore().getPhoneNumberSharingMode() == PhoneNumberSharingMode.EVERYBODY);
                if (!avatarUploadParams.keepTheSame) {
                    builder.withAvatarUrlPath(avatarPath.orElse(null));
                }
                newProfile = builder.build();
            }
        }
        if (avatar != null) {
            if (avatar.isPresent()) {
                streamDetails = Utils.createStreamDetails(avatar.get()).first();
                try {
                    this.context.getAvatarStore().storeProfileAvatar(this.account.getSelfRecipientAddress(), outputStream -> IOUtils.copyStream(streamDetails.getStream(), outputStream));
                }
                finally {
                    if (streamDetails != null) {
                        streamDetails.close();
                    }
                }
            } else {
                this.context.getAvatarStore().deleteProfileAvatar(this.account.getSelfRecipientAddress());
            }
        }
        this.account.getProfileStore().storeProfile(this.account.getSelfRecipientId(), newProfile);
    }

    public Profile getSelfProfile() {
        return this.getRecipientProfile(this.account.getSelfRecipientId());
    }

    private List<Profile> getRecipientProfiles(Collection<RecipientId> recipientIds, boolean force) {
        ProfileStore profileStore = this.account.getProfileStore();
        Flowable profileFetches = Flowable.fromIterable(recipientIds).filter(recipientId -> force || this.isProfileRefreshRequired(profileStore.getProfile((RecipientId)recipientId))).map(recipientId -> this.retrieveProfile((RecipientId)recipientId, SignalServiceProfile.RequestType.PROFILE).onErrorComplete());
        Maybe.merge((Publisher)profileFetches, (int)10).blockingSubscribe();
        return recipientIds.stream().map(profileStore::getProfile).toList();
    }

    private Profile getRecipientProfile(RecipientId recipientId, boolean force) {
        Profile profile = this.account.getProfileStore().getProfile(recipientId);
        if (!force && !this.isProfileRefreshRequired(profile)) {
            return profile;
        }
        try {
            this.blockingGetProfile(this.retrieveProfile(recipientId, SignalServiceProfile.RequestType.PROFILE));
        }
        catch (IOException e) {
            logger.warn("Failed to retrieve profile, ignoring: {}", (Object)e.getMessage());
        }
        return this.account.getProfileStore().getProfile(recipientId);
    }

    private boolean isProfileRefreshRequired(Profile profile) {
        if (profile == null) {
            return true;
        }
        long now = System.currentTimeMillis();
        return now - profile.getLastUpdateTimestamp() >= 21600000L;
    }

    private Profile decryptProfileAndDownloadAvatar(RecipientId recipientId, ProfileKey profileKey, SignalServiceProfile encryptedProfile) {
        String avatarPath = encryptedProfile.getAvatar();
        this.downloadProfileAvatar(recipientId, avatarPath, profileKey);
        return ProfileUtils.decryptProfile(profileKey, encryptedProfile);
    }

    public void downloadProfileAvatar(RecipientId recipientId, String avatarPath, ProfileKey profileKey) {
        Profile profile = this.account.getProfileStore().getProfile(recipientId);
        if (profile == null || !Objects.equals(avatarPath, profile.getAvatarUrlPath())) {
            logger.trace("Downloading profile avatar for {}", (Object)recipientId);
            this.downloadProfileAvatar(this.account.getRecipientAddressResolver().resolveRecipientAddress(recipientId), avatarPath, profileKey);
            Profile.Builder builder = profile == null ? Profile.newBuilder() : Profile.newBuilder(profile);
            this.account.getProfileStore().storeProfile(recipientId, builder.withAvatarUrlPath(avatarPath).build());
        }
    }

    private ProfileAndCredential blockingGetProfile(Single<ProfileAndCredential> profile) throws IOException {
        try {
            return (ProfileAndCredential)profile.blockingGet();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof PushNetworkException) {
                throw (PushNetworkException)e.getCause();
            }
            if (e.getCause() instanceof NotFoundException) {
                throw (NotFoundException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    private Single<ProfileAndCredential> retrieveProfile(RecipientId recipientId, SignalServiceProfile.RequestType requestType) {
        SealedSenderAccess unidentifiedAccess = this.getUnidentifiedAccess(recipientId);
        Optional<ProfileKey> profileKey = Optional.ofNullable(this.account.getProfileStore().getProfileKey(recipientId));
        logger.trace("Retrieving profile for {} {}", (Object)recipientId, (Object)(profileKey.isPresent() ? "with profile key" : "without profile key"));
        SignalServiceAddress address = this.context.getRecipientHelper().resolveSignalServiceAddress(recipientId);
        return this.retrieveProfile(address, profileKey, unidentifiedAccess, requestType).doOnSuccess(p -> {
            logger.trace("Got new profile for {}", (Object)recipientId);
            SignalServiceProfile encryptedProfile = p.getProfile();
            if (requestType == SignalServiceProfile.RequestType.PROFILE_AND_CREDENTIAL || !ExpiringProfileCredentialUtil.isValid((ExpiringProfileKeyCredential)this.account.getProfileStore().getExpiringProfileKeyCredential(recipientId))) {
                logger.trace("Storing profile credential");
                ExpiringProfileKeyCredential profileKeyCredential = p.getExpiringProfileKeyCredential().orElse(null);
                this.account.getProfileStore().storeExpiringProfileKeyCredential(recipientId, profileKeyCredential);
            }
            Profile profile = this.account.getProfileStore().getProfile(recipientId);
            if (recipientId.equals(this.account.getSelfRecipientId())) {
                boolean isUnrestricted = encryptedProfile.isUnrestrictedUnidentifiedAccess();
                if (this.account.isUnrestrictedUnidentifiedAccess() != isUnrestricted) {
                    this.account.setUnrestrictedUnidentifiedAccess(isUnrestricted);
                }
            }
            Profile newProfile = null;
            if (profileKey.isPresent()) {
                logger.trace("Decrypting profile");
                newProfile = this.decryptProfileAndDownloadAvatar(recipientId, (ProfileKey)profileKey.get(), encryptedProfile);
            }
            if (newProfile == null) {
                newProfile = (profile == null ? Profile.newBuilder() : Profile.newBuilder(profile)).withLastUpdateTimestamp(System.currentTimeMillis()).withUnidentifiedAccessMode(ProfileUtils.getUnidentifiedAccessMode(encryptedProfile, null)).withCapabilities(ProfileUtils.getCapabilities(encryptedProfile)).build();
            }
            try {
                logger.trace("Storing identity");
                IdentityKey identityKey = new IdentityKey(Base64.getDecoder().decode(encryptedProfile.getIdentityKey()));
                this.account.getIdentityKeyStore().saveIdentity(p.getProfile().getServiceId(), identityKey);
            }
            catch (InvalidKeyException ignored) {
                logger.warn("Got invalid identity key in profile for {}", (Object)this.context.getRecipientHelper().resolveSignalServiceAddress(recipientId).getIdentifier());
            }
            logger.trace("Storing profile");
            this.account.getProfileStore().storeProfile(recipientId, newProfile);
            this.account.getRecipientStore().markRegistered(recipientId, true);
            logger.trace("Done handling retrieved profile");
        }).doOnError(e -> {
            logger.warn("Failed to retrieve profile, ignoring: {}", (Object)e.getMessage());
            Profile profile = this.account.getProfileStore().getProfile(recipientId);
            Profile newProfile = (profile == null ? Profile.newBuilder() : Profile.newBuilder(profile)).withLastUpdateTimestamp(System.currentTimeMillis()).withUnidentifiedAccessMode(Profile.UnidentifiedAccessMode.UNKNOWN).withCapabilities(Set.of()).build();
            if (e instanceof NotFoundException) {
                logger.debug("Marking recipient {} as unregistered after 404 profile fetch.", (Object)recipientId);
                this.account.getRecipientStore().markRegistered(recipientId, false);
            }
            this.account.getProfileStore().storeProfile(recipientId, newProfile);
        });
    }

    private Single<ProfileAndCredential> retrieveProfile(SignalServiceAddress address, Optional<ProfileKey> profileKey, @Nullable SealedSenderAccess unidentifiedAccess, SignalServiceProfile.RequestType requestType) {
        ProfileService profileService = this.dependencies.getProfileService();
        Locale locale = Utils.getDefaultLocale(Locale.US);
        return profileService.getProfile(address, profileKey, unidentifiedAccess, requestType, locale).map(pair -> {
            ProfileService.ProfileResponseProcessor processor = new ProfileService.ProfileResponseProcessor(pair);
            if (processor.hasResult()) {
                return (ProfileAndCredential)processor.getResult();
            }
            if (processor.notFound()) {
                throw new NotFoundException("Profile not found");
            }
            throw (Throwable)pair.getExecutionError().or(() -> ((ServiceResponse)pair).getApplicationError()).orElseThrow(() -> new IOException("Unknown error while retrieving profile"));
        });
    }

    private void downloadProfileAvatar(RecipientAddress address, String avatarPath, ProfileKey profileKey) {
        if (avatarPath == null) {
            try {
                this.context.getAvatarStore().deleteProfileAvatar(address);
            }
            catch (IOException e) {
                logger.warn("Failed to delete local profile avatar, ignoring: {}", (Object)e.getMessage());
            }
            return;
        }
        try {
            this.context.getAvatarStore().storeProfileAvatar(address, outputStream -> this.retrieveProfileAvatar(avatarPath, profileKey, outputStream));
        }
        catch (Throwable e) {
            logger.warn("Failed to download profile avatar, ignoring: {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveProfileAvatar(String avatarPath, ProfileKey profileKey, OutputStream outputStream) throws IOException {
        File tmpFile = IOUtils.createTempFile();
        try (InputStream input = this.dependencies.getMessageReceiver().retrieveProfileAvatar(avatarPath, tmpFile, profileKey, 0xA00000L);){
            IOUtils.copyStream(input, outputStream, 0xA00000);
        }
        finally {
            try {
                Files.delete(tmpFile.toPath());
            }
            catch (IOException e) {
                logger.warn("Failed to delete received profile avatar temp file \u201c{}\u201d, ignoring: {}", (Object)tmpFile, (Object)e.getMessage());
            }
        }
    }

    @Nullable
    private SealedSenderAccess getUnidentifiedAccess(RecipientId recipientId) {
        return this.context.getUnidentifiedAccessHelper().getSealedSenderAccessFor(recipientId, true);
    }
}

