<?php

namespace Dagger\Codegen;

use Nette\PhpGenerator\ClassType;
use Nette\PhpGenerator\EnumType;
use Nette\PhpGenerator\PhpFile;
use Nette\PhpGenerator\PsrPrinter;

class CodeWriter
{
    public const NAMESPACE = 'Dagger';

    public function __construct(private readonly string $targetDirectory)
    {
    }

    public function write(EnumType|ClassType $classType): void
    {
        $phpFile = new PhpFile();
        $phpFile->setStrictTypes(true);
        $phpFile->addNamespace(self::NAMESPACE)->add($classType);
        $phpFile->addComment('This class has been generated by dagger-php-sdk. DO NOT EDIT.');

        $filePath = implode(DIRECTORY_SEPARATOR, [
           $this->targetDirectory,
           $classType->getName().'.php',
        ]);

        $printer = new PsrPrinter();

        file_put_contents($filePath, $printer->printFile($phpFile));
    }
}
