/*
 * Decompiled with CFR 0.152.
 */
package gmgen.gui;

import java.awt.Window;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;

public class IconUtilitities {
    public static final String RESOURCE_URL = "/pcgen/gui/resource/";
    public static final String RESOURCE_APP_ICON = "PCGenApp.png";

    public static ImageIcon getImageIcon(String location) {
        URL iconURL;
        if (!location.startsWith(RESOURCE_URL)) {
            location = RESOURCE_URL + location;
        }
        if ((iconURL = IconUtilitities.class.getResource(location)) == null) {
            return null;
        }
        return new ImageIcon(iconURL);
    }

    public static ImageIcon getImageIcon(String location, String description) {
        URL iconURL;
        if (!location.startsWith(RESOURCE_URL)) {
            location = RESOURCE_URL + location;
        }
        if ((iconURL = IconUtilitities.class.getResource(location)) == null) {
            return null;
        }
        return new ImageIcon(iconURL, description);
    }

    public static boolean maybeSetIcon(AbstractButton button, String iconName) {
        if (iconName == null) {
            return false;
        }
        ImageIcon iconImage = IconUtilitities.getImageIcon(iconName);
        if (iconImage == null) {
            return false;
        }
        button.setIcon(iconImage);
        return true;
    }

    public static boolean maybeSetIcon(AbstractButton button, String iconName, String description) {
        if (iconName == null) {
            return false;
        }
        ImageIcon iconImage = IconUtilitities.getImageIcon(iconName, description);
        if (iconImage == null) {
            return false;
        }
        button.setIcon(iconImage);
        return true;
    }

    public static boolean maybeSetIcon(Window frame, String iconName) {
        if (iconName == null) {
            return false;
        }
        ImageIcon iconImage = IconUtilitities.getImageIcon(iconName);
        if (iconImage == null) {
            return false;
        }
        frame.setIconImage(iconImage.getImage());
        return true;
    }
}

