/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.ReferenceUtilities;

public class CDOMCompoundOrReference<T extends PrereqObject>
extends CDOMGroupRef<T> {
    private final ArrayList<CDOMReference<T>> references = new ArrayList();

    public CDOMCompoundOrReference(Class<T> objClass, String refName) {
        super(objClass, refName);
    }

    public void addReference(CDOMReference<T> ref) {
        if (!this.getReferenceClass().equals(ref.getReferenceClass())) {
            throw new IllegalArgumentException("Cannot add reference of " + ref.getReferenceClass() + " to CDOMCompoundOrReference of " + this.getReferenceClass());
        }
        this.references.add(ref);
    }

    @Override
    public boolean contains(T item) {
        for (CDOMReference<T> ref : this.references) {
            if (!ref.contains(item)) continue;
            return true;
        }
        return false;
    }

    public void trimToSize() {
        this.references.trimToSize();
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return ReferenceUtilities.joinLstFormat(this.references, ",");
    }

    @Override
    public void addResolution(T item) {
        throw new IllegalStateException("CompoundReference cannot be given a resolution");
    }

    @Override
    public int getObjectCount() {
        int count = 0;
        for (CDOMReference<T> ref : this.references) {
            count += ref.getObjectCount();
        }
        return count;
    }

    @Override
    public Collection<T> getContainedObjects() {
        HashSet<T> set = new HashSet<T>();
        for (CDOMReference<T> ref : this.references) {
            set.addAll(ref.getContainedObjects());
        }
        return set;
    }

    @Override
    public GroupingState getGroupingState() {
        GroupingState state = GroupingState.EMPTY;
        for (CDOMReference<T> ref : this.references) {
            state = state.add(ref.getGroupingState());
        }
        return state.compound(GroupingState.ALLOWS_UNION);
    }

    @Override
    public String getChoice() {
        return null;
    }
}

