/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.character;

import java.util.ArrayList;
import java.util.List;
import pcgen.core.Ability;
import pcgen.core.Globals;
import pcgen.core.character.CharacterSpell;

public final class SpellInfo
implements Comparable<SpellInfo> {
    public static final int TIMES_AT_WILL = -1;
    private CharacterSpell owner;
    private List<Ability> featList;
    private String book = Globals.getDefaultSpellBook();
    private final int origLevel;
    private final int actualLevel;
    private int times;
    private String timeUnit;
    private int actualPPCost = -1;
    private int numPages = 0;
    private String fixedDC = null;

    SpellInfo(CharacterSpell owner, int originalLevel, int actualLevel, int times, String book) {
        this.owner = owner;
        this.actualLevel = actualLevel;
        this.origLevel = originalLevel;
        this.times = times;
        if (book != null) {
            this.book = book;
        }
    }

    public int getActualLevel() {
        return this.actualLevel;
    }

    public int getOriginalLevel() {
        return this.origLevel;
    }

    public void setActualPPCost(int argActualPPCost) {
        this.actualPPCost = argActualPPCost;
    }

    public int getActualPPCost() {
        return this.actualPPCost;
    }

    public String getBook() {
        return this.book;
    }

    public List<Ability> getFeatList() {
        return this.featList;
    }

    public CharacterSpell getOwner() {
        return this.owner;
    }

    public void setTimes(int times) {
        this.times = times;
    }

    public int getTimes() {
        return this.times;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }

    public final int getNumPages() {
        return this.numPages;
    }

    public final void setNumPages(int numPages) {
        this.numPages = numPages;
    }

    public void addFeatsToList(List<Ability> aList) {
        if (this.featList == null) {
            this.featList = new ArrayList<Ability>(aList.size());
        }
        this.featList.addAll(aList);
    }

    public String toString() {
        if (this.featList == null || this.featList.isEmpty()) {
            return "";
        }
        StringBuilder aBuf = new StringBuilder(" [" + this.featList.get(0).toString());
        for (int i = 1; i < this.featList.size(); ++i) {
            aBuf.append(", ").append(this.featList.get(i).toString());
        }
        aBuf.append("] ");
        return aBuf.toString();
    }

    public String getFixedDC() {
        return this.fixedDC;
    }

    public void setFixedDC(String fixedDC) {
        this.fixedDC = fixedDC;
    }

    @Override
    public int compareTo(SpellInfo other) {
        int compare = this.book.compareTo(other.book);
        if (compare == 0) {
            if (this.origLevel < other.origLevel) {
                compare = -1;
            } else if (this.origLevel > other.origLevel) {
                compare = 1;
            }
        }
        if (compare == 0) {
            if (this.actualLevel < other.actualLevel) {
                compare = -1;
            } else if (this.actualLevel > other.actualLevel) {
                compare = 1;
            }
        }
        if (compare == 0) {
            if (this.times < other.times) {
                compare = -1;
            } else if (this.times > other.times) {
                compare = 1;
            }
        }
        if (compare == 0) {
            if (this.timeUnit == null) {
                if (other.timeUnit != null) {
                    compare = -1;
                }
            } else {
                compare = other.timeUnit == null ? 1 : this.timeUnit.compareTo(other.timeUnit);
            }
        }
        if (compare == 0) {
            if (this.actualPPCost < other.actualPPCost) {
                compare = -1;
            } else if (this.actualPPCost > other.actualPPCost) {
                compare = 1;
            }
        }
        if (compare == 0) {
            if (this.numPages < other.numPages) {
                compare = -1;
            } else if (this.numPages > other.numPages) {
                compare = 1;
            }
        }
        if (compare == 0) {
            if (this.fixedDC == null) {
                if (other.fixedDC != null) {
                    compare = -1;
                }
            } else {
                compare = other.fixedDC == null ? 1 : this.fixedDC.compareTo(other.fixedDC);
            }
        }
        if (compare == 0) {
            if (this.featList == null) {
                if (other.featList != null) {
                    compare = -1;
                }
            } else if (other.featList == null) {
                compare = 1;
            } else {
                int otherILsize;
                int thisILsize = this.featList.size();
                if (thisILsize < (otherILsize = other.featList.size())) {
                    compare = -1;
                } else if (thisILsize > otherILsize) {
                    compare = 1;
                } else {
                    for (int i = 0; i < thisILsize && (compare = this.featList.get(i).compareTo(other.featList.get(i))) == 0; ++i) {
                    }
                }
            }
        }
        return compare;
    }
}

