/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.EquipmentLocation;
import pcgen.cdom.enumeration.FactKey;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.WeaponProf;
import pcgen.core.analysis.BonusCalc;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.analysis.SizeUtilities;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.display.UnarmedDamageDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.enumeration.AttackType;

public class WeaponToken
extends Token {
    public static final String TOKENNAME = "WEAPON";
    public static final int WPTYPEBONUS_PC = 0;
    public static final int WPTYPEBONUS_EQ = 1;
    public static final int WPTYPEBONUS_FEAT = 2;
    public static final int WPTYPEBONUS_TEMPLATE = 3;
    public static final int DAMAGEMODE_NORMAL = 0;
    public static final int DAMAGEMODE_BASIC = 1;
    public static final int DAMAGEMODE_OFFHAND = 2;
    public static final int DAMAGEMODE_TWOHANDS = 3;
    public static final int DAMAGEMODE_DOUBLE = 4;
    public static final int HITMODE_TOTALHIT = 0;
    public static final int HITMODE_BASEHIT = 1;
    public static final int HITMODE_TWPHITH = 2;
    public static final int HITMODE_TWPHITL = 3;
    public static final int HITMODE_TWOHIT = 4;
    public static final int HITMODE_TWFOHH = 4;
    public static final int HITMODE_TWFOHL = 5;
    public static final int HITMODE_OHHIT = 6;
    public static final int HITMODE_THHIT = 7;

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".", false);
        aTok.nextToken();
        int merge = 0;
        int weapon = 0;
        String token = aTok.nextToken();
        if (token.equals("MERGENONE")) {
            merge = 1;
            token = aTok.nextToken();
        } else if (token.equals("MERGELOC")) {
            merge = 2;
            token = aTok.nextToken();
        } else if (token.equals("MERGEALL")) {
            merge = 0;
            token = aTok.nextToken();
        }
        List<Equipment> weaponList = pc.getExpandedWeapons(merge);
        if (token.equals("ALL")) {
            token = aTok.nextToken();
        } else if (token.equals("EQUIPPED")) {
            Iterator<Equipment> it = weaponList.iterator();
            while (it.hasNext()) {
                if (it.next().isEquipped()) continue;
                it.remove();
            }
            token = aTok.nextToken();
        } else if (token.equals("NOT_EQUIPPED")) {
            Iterator<Equipment> it = weaponList.iterator();
            while (it.hasNext()) {
                if (!it.next().isEquipped()) continue;
                it.remove();
            }
            token = aTok.nextToken();
        } else if (token.equals("CARRIED")) {
            Iterator<Equipment> it = weaponList.iterator();
            while (it.hasNext()) {
                if (it.next().numberCarried().intValue() != 0) continue;
                it.remove();
            }
            token = aTok.nextToken();
        } else if (token.equals("NOT_CARRIED")) {
            Iterator<Equipment> it = weaponList.iterator();
            while (it.hasNext()) {
                if (it.next().numberCarried().intValue() <= 0) continue;
                it.remove();
            }
            token = aTok.nextToken();
        }
        weapon = WeaponToken.getIntToken(token, 0);
        if (weapon < weaponList.size()) {
            Equipment eq = weaponList.get(weapon);
            if (weapon == weaponList.size() - 1 && eh != null && eh.getExistsOnly()) {
                eh.setNoMoreItems(true);
            }
            return this.getWeaponToken(pc, eq, aTok, tokenSource);
        }
        if (eh != null && eh.getExistsOnly()) {
            eh.setNoMoreItems(true);
            if (eh.getCheckBefore()) {
                eh.setCanWrite(false);
            }
        }
        return "";
    }

    public String getWeaponToken(PlayerCharacter pc, Equipment eq, StringTokenizer aTok, String tokenSource) {
        String token = "";
        if (aTok.hasMoreTokens()) {
            token = aTok.nextToken();
        }
        int range = -1;
        int content = -1;
        int ammo = -1;
        if (token.equals("RANGELIST")) {
            range = WeaponToken.getIntToken(aTok, -1);
            token = aTok.hasMoreTokens() ? aTok.nextToken() : "RANGELIST";
        }
        if (token.equals("CONTENTS")) {
            if (aTok.hasMoreTokens()) {
                content = WeaponToken.getIntToken(aTok, -1);
                token = aTok.hasMoreTokens() ? aTok.nextToken() : "CONTENTS";
            } else {
                token = "CONTENTSCOUNT";
            }
        }
        if (token.equals("AMMUNITION")) {
            if (aTok.hasMoreTokens()) {
                ammo = WeaponToken.getIntToken(aTok, -1);
                token = aTok.hasMoreTokens() ? aTok.nextToken() : "AMMUNITION";
            } else {
                token = "AMMUNITIONCOUNT";
            }
        }
        if (token.equals("NAME")) {
            boolean star = true;
            if (aTok.hasMoreTokens() && "NOSTAR".equals(aTok.nextToken())) {
                star = false;
            }
            return WeaponToken.getNameToken(eq, pc, star);
        }
        if (token.equals("OUTPUTNAME")) {
            return WeaponToken.getOutputNameToken(eq, pc);
        }
        if (token.equals("LONGNAME")) {
            return WeaponToken.getLongNameToken(eq);
        }
        if (token.equals("ATTACKS")) {
            return WeaponToken.getAttacksToken(pc, eq) + "";
        }
        if (token.equals("AMMUNITIONCOUNT")) {
            return WeaponToken.getAmmunitionCountToken(pc, eq) + "";
        }
        if (token.equals("AMMUNITION")) {
            return WeaponToken.getAmmunitionToken(pc, eq, ammo);
        }
        if (token.equals("CONTENTSCOUNT")) {
            return WeaponToken.getContentsCountToken(eq) + "";
        }
        if (token.equals("CONTENTS")) {
            return WeaponToken.getContentsToken(eq, content);
        }
        if (token.equals("NUMATTACKS")) {
            return WeaponToken.getNumAttacksToken(pc, eq) + "";
        }
        if (token.equals("HEFT")) {
            return WeaponToken.getHeft(pc, eq);
        }
        if (token.equals("ISTYPE")) {
            if (aTok.hasMoreTokens()) {
                return WeaponToken.getIsTypeToken(eq, aTok.nextToken());
            }
            return "";
        }
        if (token.equals("CRIT")) {
            return WeaponToken.getCritToken(pc, eq);
        }
        if (token.equals("MULT")) {
            return WeaponToken.getMultToken(pc, eq);
        }
        if (token.equals("RANGELIST")) {
            return WeaponToken.getRangeListToken(eq, range, pc);
        }
        if (token.equals("RANGE")) {
            boolean units = true;
            if (aTok.hasMoreTokens() && "NOUNITS".equals(aTok.nextToken())) {
                units = false;
            }
            return WeaponToken.getRangeToken(eq, pc, units);
        }
        if (token.equals("SIZEMOD")) {
            return Delta.toString(WeaponToken.getSizeModToken(pc));
        }
        if (token.equals("TYPE")) {
            return WeaponToken.getTypeToken(eq);
        }
        if (token.equals("HIT") || token.equals("TOTALHIT")) {
            int attack = WeaponToken.getIntToken(aTok, -1);
            return WeaponToken.getTotalHitToken(pc, eq, range, content, ammo, attack);
        }
        if (token.equals("BASEHIT")) {
            int attack = WeaponToken.getIntToken(aTok, -1);
            return WeaponToken.getBaseHitToken(pc, eq, range, content, ammo, attack);
        }
        if (token.equals("TWPHITH")) {
            int attack = WeaponToken.getIntToken(aTok, -1);
            return WeaponToken.getTwpHitHToken(pc, eq, range, content, ammo, attack);
        }
        if (token.equals("TWPHITL")) {
            int attack = WeaponToken.getIntToken(aTok, -1);
            return WeaponToken.getTwpHitLToken(pc, eq, range, content, ammo, attack);
        }
        if (token.equals("TWOHIT")) {
            int attack = WeaponToken.getIntToken(aTok, -1);
            return WeaponToken.getTwoHitToken(pc, eq, range, content, ammo, attack);
        }
        if (token.equals("OHHIT")) {
            int attack = WeaponToken.getIntToken(aTok, -1);
            return WeaponToken.getOHHitToken(pc, eq, range, content, ammo, attack);
        }
        if (token.equals("THHIT")) {
            int attack = WeaponToken.getIntToken(aTok, -1);
            return WeaponToken.getTHHitToken(pc, eq, range, content, ammo, attack);
        }
        if (token.equals("CATEGORY")) {
            return WeaponToken.getCategoryToken(eq);
        }
        if (token.equals("HAND")) {
            return WeaponToken.getHandToken(eq);
        }
        if (token.equals("MAGICDAMAGE")) {
            return Delta.toString(WeaponToken.getMagicDamageToken(pc, eq));
        }
        if (token.equals("MAGICHIT")) {
            return Delta.toString(WeaponToken.getMagicHitToken(pc, eq));
        }
        if (token.equals("MISC")) {
            return Delta.toString(WeaponToken.getMiscToken(pc, eq));
        }
        if (token.equals("FEATDAMAGE")) {
            return Delta.toString(WeaponToken.getFeatDamageToken(pc, eq));
        }
        if (token.equals("FEATHIT")) {
            return Delta.toString(WeaponToken.getFeatHitToken(pc, eq));
        }
        if (token.equals("TEMPLATEDAMAGE")) {
            return Delta.toString(WeaponToken.getTemplateDamageToken(pc, eq));
        }
        if (token.equals("TEMPLATEHIT")) {
            return Delta.toString(WeaponToken.getTemplateHitToken(pc, eq));
        }
        if (token.equals("DAMAGE")) {
            return WeaponToken.getDamageToken(pc, eq, range, content, ammo, false, false);
        }
        if (token.equals("BASEDAMAGE")) {
            return WeaponToken.getDamageToken(pc, eq, range, content, ammo, false, true);
        }
        if (token.equals("BASICDAMAGE")) {
            return WeaponToken.getBasicDamageToken(pc, eq, range, content, ammo, false);
        }
        if (token.equals("THDAMAGE")) {
            return WeaponToken.getTHDamageToken(pc, eq, range, content, ammo, false);
        }
        if (token.equals("OHDAMAGE")) {
            return WeaponToken.getOHDamageToken(pc, eq, range, content, ammo, false);
        }
        if (token.equals("DAMAGEBONUS") || token.equals("BONUSDAMAGE")) {
            return WeaponToken.getDamageToken(pc, eq, range, content, ammo, true, false);
        }
        if (token.equals("BASEDAMAGEBONUS")) {
            return WeaponToken.getDamageToken(pc, eq, range, content, ammo, true, true);
        }
        if (token.equals("THDAMAGEBONUS")) {
            return WeaponToken.getTHDamageToken(pc, eq, range, content, ammo, true);
        }
        if (token.equals("OHDAMAGEBONUS")) {
            return WeaponToken.getOHDamageToken(pc, eq, range, content, ammo, true);
        }
        if (token.equals("SIZE")) {
            return WeaponToken.getSizeToken(eq);
        }
        if (token.equals("SPROP")) {
            return WeaponToken.getSpropToken(pc, eq, content, ammo);
        }
        if (token.equals("REACH")) {
            return WeaponToken.getReachToken(pc, eq) + "";
        }
        if (token.equals("REACHUNIT")) {
            return Globals.getGameModeUnitSet().getDistanceUnit();
        }
        if (token.equals("WT")) {
            return WeaponToken.getWTToken(pc, eq);
        }
        if (token.equals("RATEOFFIRE")) {
            FactKey fk = FactKey.valueOf("RateOfFire");
            String str = (String)eq.getResolved(fk);
            return str == null ? "" : str;
        }
        if (token.equals("ISLIGHT")) {
            return WeaponToken.getIsLightToken(pc, eq);
        }
        if (token.equals("QUALITY")) {
            Map<String, String> qualityMap = eq.getMapFor(MapKey.QUALITY);
            if (qualityMap != null) {
                if (aTok.hasMoreTokens()) {
                    block69: {
                        String next = aTok.nextToken();
                        try {
                            int idx = Integer.parseInt(next);
                            for (String value : qualityMap.values()) {
                                if (--idx != 0) continue;
                                return value;
                            }
                        }
                        catch (NumberFormatException e) {
                            String value = qualityMap.get(next);
                            if (value == null) break block69;
                            return value;
                        }
                    }
                    return "";
                }
                TreeSet<String> qualities = new TreeSet<String>();
                for (Map.Entry<String, String> me : qualityMap.entrySet()) {
                    qualities.add(me.getKey() + ": " + me.getValue());
                }
                return StringUtil.join(qualities, (String)", ");
            }
            return "";
        }
        if (token.equals("CHARGES")) {
            String retString = "";
            int charges = eq.getRemainingCharges();
            if (charges >= 0) {
                retString = charges + "";
            }
            return retString;
        }
        Logging.errorPrint("Invalid WEAPON token: " + tokenSource, new Throwable());
        return "";
    }

    public static String getIsLightToken(PlayerCharacter pc, Equipment eq) {
        return eq.isWeaponLightForPC(pc) ? "TRUE" : "FALSE";
    }

    public static String getNameToken(Equipment eq, PlayerCharacter pc, boolean star) {
        StringBuilder sb = new StringBuilder();
        if (eq.isEquipped() && star) {
            sb.append("*");
        }
        sb.append(OutputNameFormatting.parseOutputName(eq, pc));
        sb.append(eq.getAppliedName());
        return sb.toString();
    }

    public static String getOutputNameToken(Equipment eq, PlayerCharacter pc) {
        StringBuilder sb = new StringBuilder();
        if (eq.isEquipped()) {
            sb.append("*");
        }
        sb.append(OutputNameFormatting.parseOutputName(eq, pc));
        sb.append(eq.getAppliedName());
        return sb.toString();
    }

    public static String getLongNameToken(Equipment eq) {
        StringBuilder sb = new StringBuilder();
        if (eq.isEquipped()) {
            sb.append("*");
        }
        sb.append(eq.longName());
        sb.append(eq.getAppliedName());
        return sb.toString();
    }

    public static int getAttacksToken(PlayerCharacter pc, Equipment eq) {
        return (int)eq.bonusTo(pc, TOKENNAME, "ATTACKS", true);
    }

    public static int getAmmunitionCountToken(PlayerCharacter pc, Equipment eq) {
        int ammoCount = 0;
        String containerCapacity = eq.getContainerCapacityString().toUpperCase();
        block0: for (Equipment equip : pc.getEquipmentListInOutputOrder()) {
            for (String type : equip.typeList()) {
                if (containerCapacity.indexOf(type) < 0) continue;
                ++ammoCount;
                continue block0;
            }
        }
        return ammoCount;
    }

    public static String getAmmunitionToken(PlayerCharacter pc, Equipment eq, int ammo) {
        Equipment ammoUser = WeaponToken.getAmmoUser(pc, eq, ammo);
        if (ammoUser != null) {
            return ammoUser.getName();
        }
        return "";
    }

    public static int getContentsCountToken(Equipment eq) {
        return eq.getContainedEquipmentCount();
    }

    public static String getContentsToken(Equipment eq, int content) {
        if (content > -1 && content < eq.getContainedEquipmentCount()) {
            return eq.getContainedEquipment(content).getName();
        }
        return "";
    }

    public static String getHeft(PlayerCharacter pc, Equipment eq) {
        String retString = "";
        retString = pc.getDisplay().sizeInt() > eq.sizeInt() ? "LIGHT" : (pc.getDisplay().sizeInt() == eq.sizeInt() ? "MEDIUM" : "HEAVY");
        return retString;
    }

    public static String getIsTypeToken(Equipment eq, String type) {
        return WeaponToken.isTypeToken(eq, type) ? "TRUE" : "FALSE";
    }

    public static boolean isTypeToken(Equipment eq, String type) {
        return eq.isType(type);
    }

    public static String getMultToken(PlayerCharacter pc, Equipment eq) {
        String profName = WeaponToken.getProfName(eq);
        StringBuilder sb = new StringBuilder();
        boolean isDouble = eq.isDouble() && eq.getLocation() == EquipmentLocation.EQUIPPED_TWO_HANDS;
        int mult = (int)pc.getTotalBonusTo("WEAPONPROF=" + profName, "CRITMULTADD") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "CRITMULTADD", 0);
        int critMult = eq.getCritMultiplier();
        if (critMult <= 0) {
            sb.append(mult);
        } else {
            sb.append(critMult + mult);
        }
        int altCrit = eq.getAltCritMultiplier();
        if (isDouble && altCrit > 0) {
            sb.append("/").append(altCrit + mult);
        }
        return sb.toString();
    }

    private static String getProfName(Equipment eq) {
        CDOMSingleRef<WeaponProf> ref = eq.get(ObjectKey.WEAPON_PROF);
        String profName = ref == null ? "" : ref.resolvesTo().getKeyName();
        return profName;
    }

    public static String getRangeListToken(Equipment eq, int range, PlayerCharacter aPC) {
        List<String> rangeList = WeaponToken.getRangeList(eq, true, aPC);
        if (range < rangeList.size()) {
            return Globals.getGameModeUnitSet().displayDistanceInUnitSet(Integer.parseInt(rangeList.get(range))) + Globals.getGameModeUnitSet().getDistanceUnit();
        }
        return "";
    }

    public static String getRangeToken(Equipment eq, PlayerCharacter pc, boolean units) {
        StringBuilder sb = new StringBuilder();
        sb.append(Globals.getGameModeUnitSet().displayDistanceInUnitSet(eq.getRange(pc).intValue()));
        if (units) {
            sb.append(Globals.getGameModeUnitSet().getDistanceUnit());
        }
        return sb.toString();
    }

    public static int getSizeModToken(PlayerCharacter pc) {
        return (int)pc.getSizeAdjustmentBonusTo("TOHIT", "TOHIT");
    }

    public static String getCategoryToken(Equipment eq) {
        StringBuilder sb = new StringBuilder();
        sb.append(WeaponToken.weaponCategories(eq));
        sb.append("-");
        if (eq.isNatural()) {
            sb.append("Natural");
        }
        if (WeaponToken.appendSeperator(eq)) {
            sb.append(",");
        }
        if (eq.isType("Both")) {
            if (eq.isMelee()) {
                sb.append("Both (Melee)");
            } else if (eq.isRanged()) {
                sb.append("Both (Ranged)");
            }
        } else if (eq.isMelee()) {
            sb.append("Melee");
        } else if (eq.isRanged()) {
            sb.append("Ranged");
        }
        if (WeaponToken.isNonStandard(eq)) {
            sb.append("Non-Standard");
        }
        return sb.toString();
    }

    public static String getTypeToken(Equipment eq) {
        String types = WeaponToken.weaponTypes(eq, true);
        if (eq.isDouble()) {
            types = types + '/' + WeaponToken.weaponTypes(eq, false);
        }
        return types;
    }

    public static String getHandToken(Equipment eq) {
        String location = eq.getLocation().getString();
        return location.replaceAll(".*\\(", "").replaceAll("\\(.*", "").replaceAll("\\).*", "");
    }

    public static int getMagicDamageToken(PlayerCharacter pc, Equipment eq) {
        String profName = WeaponToken.getProfName(eq);
        int magicdamage = eq.getBonusToDamage(pc, true) + (int)BonusCalc.charBonusTo(eq, "WEAPONPROF=" + profName, "DAMAGE", pc) + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "DAMAGE", 1);
        return magicdamage;
    }

    public static int getMagicHitToken(PlayerCharacter pc, Equipment eq) {
        String profName = WeaponToken.getProfName(eq);
        int magichit = eq.getBonusToHit(pc, true) + (int)BonusCalc.charBonusTo(eq, "WEAPONPROF=" + profName, "TOHIT", pc) + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "TOHIT", 1);
        return magichit;
    }

    public static int getMiscToken(PlayerCharacter pc, Equipment eq) {
        String profName = WeaponToken.getProfName(eq);
        int miscBonus = (int)pc.getTotalBonusTo("WEAPONPROF=" + profName, "TOHIT") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "TOHIT", 0) - (int)pc.getDisplay().getStatBonusTo("TOHIT", "TYPE.MELEE") - (int)pc.getSizeAdjustmentBonusTo("TOHIT", "TOHIT");
        return miscBonus;
    }

    public static int getFeatDamageToken(PlayerCharacter pc, Equipment eq) {
        String profName = WeaponToken.getProfName(eq);
        int featBonus = (int)pc.getFeatBonusTo(TOKENNAME, "DAMAGE") - (int)pc.getFeatBonusTo(TOKENNAME, "DAMAGE-SHORTRANGE") + (int)pc.getFeatBonusTo("WEAPONPROF=" + profName, "DAMAGE") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "DAMAGE", 2);
        return featBonus;
    }

    public static int getFeatHitToken(PlayerCharacter pc, Equipment eq) {
        String profName = WeaponToken.getProfName(eq);
        int featBonus = (int)pc.getFeatBonusTo(TOKENNAME, "TOHIT") + (int)pc.getFeatBonusTo("WEAPONPROF=" + profName, "TOHIT") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "TOHIT", 2);
        return featBonus;
    }

    public static int getTemplateDamageToken(PlayerCharacter pc, Equipment eq) {
        String profName = WeaponToken.getProfName(eq);
        int templateBonus = (int)pc.getTemplateBonusTo(TOKENNAME, "DAMAGE") + (int)pc.getTemplateBonusTo("WEAPONPROF=" + profName, "DAMAGE") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "DAMAGE", 3);
        return templateBonus;
    }

    public static int getTemplateHitToken(PlayerCharacter pc, Equipment eq) {
        String profName = WeaponToken.getProfName(eq);
        int templateBonus = (int)pc.getTemplateBonusTo(TOKENNAME, "TOHIT") + (int)pc.getTemplateBonusTo("WEAPONPROF=" + profName, "TOHIT") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "TOHIT", 3);
        return templateBonus;
    }

    public static String getSizeToken(Equipment eq) {
        return eq.getSize();
    }

    public static String getSpropToken(PlayerCharacter pc, Equipment eq) {
        return WeaponToken.getSpropToken(pc, eq, -1, -1);
    }

    public static String getSpropToken(PlayerCharacter pc, Equipment eq, int content, int ammo) {
        String sprop = eq.getSpecialProperties(pc);
        if (content > -1) {
            sprop = "";
            if (content < eq.getContainedEquipmentCount() && !"".equals(eq.getContainedEquipment(content).getSpecialProperties(pc))) {
                sprop = eq.getContainedEquipment(content).getSpecialProperties(pc);
            }
        }
        int ammoCount = 0;
        Equipment anEquip = null;
        if (ammo > -1) {
            String containerCapacity = eq.getContainerCapacityString();
            for (Equipment equip : pc.getEquipmentListInOutputOrder()) {
                sprop = "";
                for (String type : equip.typeList()) {
                    if (containerCapacity.indexOf(type) < 0) continue;
                    ++ammoCount;
                    anEquip = equip;
                    break;
                }
                if (ammoCount != ammo + 1) continue;
                break;
            }
        }
        if (anEquip != null && ammoCount > 0 && !"".equals(anEquip.getSpecialProperties(pc))) {
            sprop = anEquip.getSpecialProperties(pc);
        }
        if (sprop.startsWith(", ")) {
            sprop = sprop.substring(2);
        }
        return sprop;
    }

    public static String getReachToken(PlayerCharacter pc, Equipment eq) {
        int dist = eq.getVariableValue(SettingsHandler.getGame().getWeaponReachFormula(), "", pc).intValue();
        String profName = WeaponToken.getProfName(eq);
        int iAdd = (int)pc.getTotalBonusTo("WEAPONPROF=" + profName, "REACH") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "REACH", 0);
        return Globals.getGameModeUnitSet().displayDistanceInUnitSet(dist + iAdd);
    }

    public static String getWTToken(PlayerCharacter pc, Equipment eq) {
        return Globals.getGameModeUnitSet().displayWeightInUnitSet(eq.getWeight(pc).doubleValue());
    }

    public static int getNumAttacksToken(PlayerCharacter pc, Equipment eq) {
        String melee = WeaponToken.getMeleeAttackString(pc);
        String unarmed = WeaponToken.getUnarmedAttackString(pc);
        String ranged = WeaponToken.getRangedAttackString(pc);
        String weaponString = melee;
        if (eq.isRanged()) {
            weaponString = ranged;
        }
        if (eq.isMonk()) {
            if (unarmed.length() > melee.length()) {
                weaponString = unarmed;
            } else if (unarmed.length() == melee.length() && !melee.equals(unarmed)) {
                StringTokenizer mTok = new StringTokenizer(melee, "+/", false);
                StringTokenizer uTok = new StringTokenizer(unarmed, "+/", false);
                String msString = mTok.nextToken();
                String usString = uTok.nextToken();
                if (Integer.parseInt(usString) >= Integer.parseInt(msString)) {
                    weaponString = unarmed;
                }
            }
        }
        StringTokenizer bTok = new StringTokenizer(weaponString, "/");
        int extra_attacks = (int)eq.bonusTo(pc, TOKENNAME, "ATTACKS", true);
        return bTok.countTokens() + extra_attacks;
    }

    public static String getCritToken(PlayerCharacter pc, Equipment eq) {
        StringBuilder sb = new StringBuilder();
        boolean isDouble = eq.isDouble() && eq.getLocation() == EquipmentLocation.EQUIPPED_TWO_HANDS;
        int rawCritRange = eq.getRawCritRange(true);
        if (rawCritRange == 0) {
            return "none";
        }
        String profName = WeaponToken.getProfName(eq);
        int dbl = (int)pc.getTotalBonusTo("WEAPONPROF=" + profName, "CRITRANGEDOUBLE") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "CRITRANGEDOUBLE", 0);
        int iAdd = (int)pc.getTotalBonusTo("WEAPONPROF=" + profName, "CRITRANGEADD") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "CRITRANGEADD", 0);
        int eqDbl = dbl + (int)eq.bonusTo(pc, "EQMWEAPON", "CRITRANGEDOUBLE", true);
        int critrange = eq.getRawCritRange(true) * (eqDbl + 1);
        critrange = 21 - (critrange + iAdd + (int)eq.bonusTo(pc, "EQMWEAPON", "CRITRANGEADD", true));
        sb.append(critrange + "");
        if (critrange < 20) {
            sb.append("-20");
        }
        if (isDouble && pc.getCritRange(eq, false) > 0) {
            eqDbl = dbl + (int)eq.bonusTo(pc, "EQMWEAPON", "CRITRANGEDOUBLE", false);
            int altCritRange = eq.getRawCritRange(false) * (eqDbl + 1);
            if ((altCritRange = 21 - (altCritRange + iAdd + (int)eq.bonusTo(pc, "EQMWEAPON", "CRITRANGEADD", false))) != critrange) {
                sb.append("/" + altCritRange);
                if (altCritRange < 20) {
                    sb.append("-20");
                }
            }
        }
        return sb.toString();
    }

    public static String getDamageToken(PlayerCharacter pc, Equipment eq, boolean bonusOnly, boolean base) {
        return WeaponToken.getDamageToken(pc, eq, -1, -1, -1, bonusOnly, base);
    }

    public static String getDamageToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, boolean bonusOnly, boolean base) {
        boolean isDouble = eq.isDouble() && eq.getLocation() == EquipmentLocation.EQUIPPED_TWO_HANDS;
        boolean isDoubleSplit = eq.isType("Head1") || eq.isType("Head2");
        int damageMode = 0;
        int hands = 1;
        if (eq.isNatural() && eq.getLocation() == EquipmentLocation.EQUIPPED_SECONDARY) {
            damageMode = 2;
            hands = 0;
        } else if (eq.isUnarmed()) {
            damageMode = 1;
        } else if (isDouble && !isDoubleSplit) {
            damageMode = 4;
            hands = 1;
        } else if (isDoubleSplit && eq.isWeaponTwoHanded(pc)) {
            damageMode = 3;
            hands = 2;
        } else if (pc.getDisplay().isSecondaryWeapon(eq)) {
            damageMode = 2;
            hands = 0;
        } else if (pc.getDisplay().isPrimaryWeapon(eq)) {
            if (eq.getLocation() == EquipmentLocation.EQUIPPED_BOTH) {
                damageMode = 3;
                hands = 2;
            } else {
                damageMode = 1;
            }
        } else if (eq.isWeaponTwoHanded(pc)) {
            damageMode = 3;
            hands = 2;
        } else {
            damageMode = 1;
        }
        return WeaponToken.getDamage(pc, eq, range, content, ammo, bonusOnly, hands, damageMode, base);
    }

    public static String getBasicDamageToken(PlayerCharacter pc, Equipment eq, boolean bonusOnly) {
        return WeaponToken.getBasicDamageToken(pc, eq, -1, -1, -1, bonusOnly);
    }

    public static String getBasicDamageToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, boolean bonusOnly) {
        int damageMode = 1;
        int hands = 1;
        return WeaponToken.getDamage(pc, eq, range, content, ammo, bonusOnly, hands, damageMode, false);
    }

    public static String getTHDamageToken(PlayerCharacter pc, Equipment eq, boolean bonusOnly) {
        return WeaponToken.getTHDamageToken(pc, eq, -1, -1, -1, bonusOnly);
    }

    public static String getTHDamageToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, boolean bonusOnly) {
        int damageMode = 3;
        int hands = 2;
        return WeaponToken.getDamage(pc, eq, range, content, ammo, bonusOnly, hands, damageMode, false);
    }

    public static String getOHDamageToken(PlayerCharacter pc, Equipment eq, boolean bonusOnly) {
        return WeaponToken.getOHDamageToken(pc, eq, -1, -1, -1, bonusOnly);
    }

    public static String getOHDamageToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, boolean bonusOnly) {
        int damageMode = 2;
        int hands = 0;
        return WeaponToken.getDamage(pc, eq, range, content, ammo, bonusOnly, hands, damageMode, false);
    }

    public static String getTotalHitToken(PlayerCharacter pc, Equipment eq) {
        return WeaponToken.getTotalHitToken(pc, eq, -1, -1, -1, -1);
    }

    public static String getTotalHitToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, int attackNum) {
        Equipment sEq;
        CharacterDisplay display = pc.getDisplay();
        boolean isDouble = eq.isDouble() && eq.getLocation() == EquipmentLocation.EQUIPPED_TWO_HANDS;
        boolean isDoubleSplit = eq.isType("Head1") || eq.isType("Head2");
        int hitMode = 0;
        hitMode = eq.isUnarmed() ? 1 : (isDouble && !isDoubleSplit ? 4 : (!isDouble && isDoubleSplit ? 7 : (display.isPrimaryWeapon(eq) && display.hasSecondaryWeapons() ? ((sEq = display.getSecondaryWeapons().iterator().next()) == null ? 3 : (sEq.isWeaponLightForPC(pc) ? 3 : 2)) : (display.isSecondaryWeapon(eq) && display.hasPrimaryWeapons() ? (eq.isWeaponLightForPC(pc) ? 5 : 4) : (display.isSecondaryWeapon(eq) && !display.hasPrimaryWeapons() ? 6 : (display.isPrimaryWeapon(eq) && !display.hasSecondaryWeapons() ? (eq.getLocation() == EquipmentLocation.EQUIPPED_BOTH ? 7 : 1) : (eq.isWeaponTwoHanded(pc) ? 7 : 1)))))));
        return WeaponToken.getToHit(pc, eq, range, content, ammo, hitMode, attackNum);
    }

    public static String getBaseHitToken(PlayerCharacter pc, Equipment eq) {
        return WeaponToken.getBaseHitToken(pc, eq, -1, -1, -1, -1);
    }

    public static String getBaseHitToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, int attackNum) {
        int hitMode = 1;
        return WeaponToken.getToHit(pc, eq, range, content, ammo, hitMode, attackNum);
    }

    public static String getTwpHitHToken(PlayerCharacter pc, Equipment eq) {
        return WeaponToken.getTwpHitHToken(pc, eq, -1, -1, -1, -1);
    }

    public static String getTwpHitHToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, int attackNum) {
        int hitMode = 2;
        return WeaponToken.getToHit(pc, eq, range, content, ammo, hitMode, attackNum);
    }

    public static String getTwpHitLToken(PlayerCharacter pc, Equipment eq) {
        return WeaponToken.getTwpHitLToken(pc, eq, -1, -1, -1, -1);
    }

    public static String getTwpHitLToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, int attackNum) {
        int hitMode = 3;
        return WeaponToken.getToHit(pc, eq, range, content, ammo, hitMode, attackNum);
    }

    public static String getTwoHitToken(PlayerCharacter pc, Equipment eq) {
        return WeaponToken.getTwoHitToken(pc, eq, -1, -1, -1, -1);
    }

    public static String getTwoHitToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, int attackNum) {
        int hitMode = 4;
        return WeaponToken.getToHit(pc, eq, range, content, ammo, hitMode, attackNum);
    }

    public static String getOHHitToken(PlayerCharacter pc, Equipment eq) {
        return WeaponToken.getOHHitToken(pc, eq, -1, -1, -1, -1);
    }

    public static String getOHHitToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, int attackNum) {
        int hitMode = 6;
        return WeaponToken.getToHit(pc, eq, range, content, ammo, hitMode, attackNum);
    }

    public static String getTHHitToken(PlayerCharacter pc, Equipment eq) {
        return WeaponToken.getTHHitToken(pc, eq, -1, -1, -1, -1);
    }

    public static String getTHHitToken(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, int attackNum) {
        int hitMode = 7;
        return WeaponToken.getToHit(pc, eq, range, content, ammo, hitMode, attackNum);
    }

    private static String getToHit(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, int hitMode, int attackNum) {
        Equipment ammoUser;
        WeaponProf prof;
        String profKey;
        boolean isDoubleSplit;
        boolean isDouble = eq.isDouble() && eq.getLocation() == EquipmentLocation.EQUIPPED_TWO_HANDS;
        boolean bl = isDoubleSplit = eq.isType("Head1") || eq.isType("Head2");
        if (eq.isMelee() && eq.isWeaponTwoHanded(pc) && (!isDouble && !isDoubleSplit && hitMode != 7 || isDoubleSplit && (hitMode == 1 || hitMode == 6 || hitMode == 2))) {
            return SettingsHandler.getInvalidToHitText();
        }
        if (eq.isMelee() && eq.isWeaponOutsizedForPC(pc) && !eq.isNatural()) {
            return SettingsHandler.getInvalidToHitText();
        }
        int weaponBaseBonus = (int)eq.bonusTo(pc, TOKENNAME, "WEAPONBAB", true);
        CDOMSingleRef<WeaponProf> ref = eq.get(ObjectKey.WEAPON_PROF);
        if (ref == null) {
            profKey = "";
            prof = null;
        } else {
            prof = ref.resolvesTo();
            profKey = prof.getKeyName();
        }
        weaponBaseBonus += (int)pc.getTotalBonusTo("WEAPONPROF=" + profKey, "WEAPONBAB");
        String melee = WeaponToken.getMeleeAttackString(pc, 0, weaponBaseBonus += WeaponToken.getWeaponProfTypeBonuses(pc, eq, "WEAPONBAB", 0));
        String ranged = WeaponToken.getRangedAttackString(pc, 0, weaponBaseBonus);
        String unarmed = WeaponToken.getUnarmedAttackString(pc, 0, weaponBaseBonus);
        if (eq.isMonk()) {
            if (unarmed.length() > melee.length()) {
                melee = unarmed;
            } else if (unarmed.length() == melee.length() && !melee.equals(unarmed)) {
                StringTokenizer mTok = new StringTokenizer(melee, "+/", false);
                StringTokenizer m1Tok = new StringTokenizer(melee, "+/", false);
                String msString = mTok.nextToken();
                String m1sString = m1Tok.nextToken();
                if (Integer.parseInt(m1sString) >= Integer.parseInt(msString)) {
                    melee = unarmed;
                }
            }
        }
        int baseBonus = 0;
        int secondaryBonus = 0;
        int primaryBonus = 0;
        if (eq.isNatural()) {
            if (eq.getLocation() == EquipmentLocation.EQUIPPED_PRIMARY) {
                baseBonus = 0;
            } else if (eq.getLocation() == EquipmentLocation.EQUIPPED_SECONDARY) {
                baseBonus = -5;
                baseBonus = (int)((double)baseBonus + pc.getTotalBonusTo("COMBAT", "TOHIT-SECONDARY"));
            }
        } else {
            baseBonus = hitMode == 0 && eq.isRanged() || hitMode == 1 || hitMode == 7 ? 0 : (hitMode == 2 || hitMode == 3 ? -6 : (hitMode == 6 ? -4 : -10));
            if (hitMode == 3 || hitMode == 5) {
                baseBonus += pc.getOffHandLightBonus();
            }
            if (hitMode == 4 && (isDouble || isDoubleSplit || eq.isWeaponLightForPC(pc))) {
                baseBonus += pc.getOffHandLightBonus();
            }
            if (hitMode == 4 || hitMode == 6 || hitMode == 5 || hitMode == 4) {
                secondaryBonus = (int)pc.getTotalBonusTo("COMBAT", "TOHIT-SECONDARY");
                if (eq.isRanged()) {
                    secondaryBonus -= (int)pc.getBonusDueToType("COMBAT", "TOHIT-SECONDARY", "NOTRANGED");
                }
                if (hitMode == 6) {
                    secondaryBonus -= (int)pc.getTotalBonusTo("COMBAT", "TOHIT-PRIMARY");
                }
            }
            if (hitMode == 2 || hitMode == 3) {
                primaryBonus = (int)pc.getTotalBonusTo("COMBAT", "TOHIT-PRIMARY");
                if (eq.isRanged()) {
                    primaryBonus -= (int)pc.getBonusDueToType("COMBAT", "TOHIT-PRIMARY", "NOTRANGED");
                }
            }
        }
        if (eq.getLocation() == EquipmentLocation.EQUIPPED_PRIMARY || eq.getLocation() == EquipmentLocation.EQUIPPED_SECONDARY || eq.getLocation() == EquipmentLocation.EQUIPPED_TWO_HANDS) {
            // empty if block
        }
        if (hitMode == 2 || hitMode == 3) {
            baseBonus += primaryBonus;
        }
        if (hitMode == 4 || hitMode == 6 || hitMode == 5 || hitMode == 4) {
            baseBonus += secondaryBonus;
        }
        for (String type : eq.typeList()) {
            if (type.equalsIgnoreCase("Finesseable") || range > -1 && type.equalsIgnoreCase("MELEE") || range == -1 && eq.isMelee() && (type.equalsIgnoreCase("THROWN") || type.equalsIgnoreCase("RANGED"))) continue;
            baseBonus += (int)pc.getTotalBonusTo("TOHIT", "TYPE." + type);
            baseBonus += (int)pc.getTotalBonusTo("COMBAT", "TOHIT." + type);
        }
        if (range == -1 && eq.isMelee() && eq.isFinessable(pc)) {
            baseBonus += (int)pc.getTotalBonusTo("COMBAT", "TOHIT.Finesseable");
        }
        if (ref != null && eq.isRanged()) {
            baseBonus -= (int)pc.getBonusDueToType("WEAPONPROF=" + profKey, "TOHIT", "NOTRANGED");
            baseBonus -= WeaponToken.getWeaponProfTypeBonuses(pc, eq, "TOHIT.NOTRANGED", 0);
        }
        CharacterDisplay display = pc.getDisplay();
        if (!(eq.isNatural() || ref != null && display.hasWeaponProf(prof))) {
            baseBonus += display.getNonProficiencyPenalty();
        }
        baseBonus += (int)pc.getTotalBonusTo("WEAPONPROF=" + profKey, "TOHIT");
        baseBonus += WeaponToken.getWeaponProfTypeBonuses(pc, eq, "TOHIT", 0);
        if (range > -1) {
            int rangeSize = WeaponToken.getRangeList(eq, true, pc).size();
            int shortRange = SettingsHandler.getGame().getShortRangeDistance();
            if (range < rangeSize) {
                int thisRange = Integer.parseInt(WeaponToken.getRangeList(eq, true, pc).get(range));
                if (thisRange <= shortRange) {
                    baseBonus += (int)pc.getTotalBonusTo("COMBAT", "TOHIT-SHORTRANGE");
                    baseBonus += (int)pc.getTotalBonusTo("TOHIT", "SHORTRANGE");
                    baseBonus += (int)pc.getTotalBonusTo("WEAPONPROF=" + profKey, "TOHIT-SHORTRANGE");
                    baseBonus += WeaponToken.getWeaponProfTypeBonuses(pc, eq, "TOHIT-SHORTRANGE", 0);
                    baseBonus += (int)eq.bonusTo(pc, TOKENNAME, "TOHIT-SHORTRANGE", true);
                }
                int defaultRange = Integer.parseInt(eq.getRange(pc).toString());
                int rangePenalty = SettingsHandler.getGame().getRangePenalty();
                rangePenalty = (int)((double)rangePenalty + pc.getTotalBonusTo("COMBAT", "RANGEPENALTY"));
                baseBonus += rangePenalty * (int)Math.max(Math.ceil((float)thisRange / (float)defaultRange) - 1.0, 0.0);
            }
        }
        Equipment containedEq = null;
        if (content > -1 && content < eq.getContainedEquipmentCount()) {
            containedEq = eq.getContainedEquipment(content);
            baseBonus += containedEq.getBonusToHit(pc, true);
        }
        if ((ammoUser = WeaponToken.getAmmoUser(pc, eq, ammo)) != null) {
            baseBonus += ammoUser.getBonusToHit(pc, true);
        }
        baseBonus += (int)pc.getTotalBonusTo("TOHIT", "TOHIT");
        baseBonus += (int)pc.getTotalBonusTo("COMBAT", "TOHIT");
        baseBonus += pc.modFromArmorOnWeaponRolls();
        baseBonus += eq.getBonusToHit(pc, true);
        if (!Globals.checkRule("AMMOSTACKSWITHWEAPON")) {
            baseBonus += WeaponToken.calcAmmoEqCorrection("WEAPON.TOHIT.ENHANCEMENT", eq, containedEq, ammoUser);
        }
        int extra_attacks = (int)eq.bonusTo(pc, TOKENNAME, "ATTACKS", true);
        extra_attacks += (int)pc.getTotalBonusTo("COMBAT", "ATTACKS");
        String babProgression = null;
        if (eq.isMelee() && range == -1) {
            babProgression = melee;
        } else if (eq.isRanged()) {
            babProgression = ranged;
        } else {
            return "???";
        }
        StringTokenizer bTok = new StringTokenizer(babProgression, "/+");
        String attack = Delta.toString(Integer.parseInt(bTok.nextToken()));
        StringBuilder newAttack = new StringBuilder();
        for (int i = extra_attacks; i > 0; --i) {
            newAttack.append(attack).append("/");
        }
        boolean progress = eq.getSafe(ObjectKey.ATTACKS_PROGRESS);
        int bonusProgress = (int)eq.bonusTo(pc, TOKENNAME, "ATTACKSPROGRESS", true);
        if (bonusProgress != 0) {
            boolean bl2 = progress = bonusProgress > 0;
        }
        if (progress) {
            newAttack.append(babProgression);
        } else {
            newAttack.append(attack);
        }
        StringTokenizer aTok = new StringTokenizer(newAttack.toString(), "/+");
        String singleAttack = "";
        boolean buildNewAttackSequence = false;
        for (int selectAttack = attackNum; aTok.hasMoreTokens() && selectAttack >= 0; --selectAttack) {
            singleAttack = aTok.nextToken();
            buildNewAttackSequence = true;
        }
        if (buildNewAttackSequence) {
            aTok = new StringTokenizer(singleAttack, "/+");
        }
        int secondariesToadd = 1 + (int)pc.getTotalBonusTo("COMBAT", "ATTACKS-SECONDARY");
        secondariesToadd += (int)pc.getTotalBonusTo("COMBAT", "SECONDARYATTACKS");
        if (!display.hasPrimaryWeapons() && hitMode == 0) {
            secondariesToadd = 100;
        }
        boolean doDouble = isDouble && eq.getLocation() == EquipmentLocation.EQUIPPED_TWO_HANDS && attackNum < 0;
        boolean considerEarlyExit = !isDouble && (hitMode == 4 || display.isSecondaryWeapon(eq));
        int toHit = 0;
        int secondariesAdded = 0;
        StringBuilder primaryAttack = new StringBuilder(20);
        StringBuilder secondaryAttack = new StringBuilder(20);
        StringBuilder totalAttack = new StringBuilder();
        while (aTok.hasMoreTokens()) {
            if (primaryAttack.length() > 0) {
                primaryAttack.append('/');
            }
            toHit = Integer.parseInt(aTok.nextToken()) + baseBonus;
            primaryAttack.append(Delta.toString(toHit));
            if (doDouble && secondariesAdded < secondariesToadd) {
                if (secondaryAttack.length() > 0) {
                    secondaryAttack.append('/');
                }
                secondaryAttack.append(Delta.toString(toHit));
            }
            if (++secondariesAdded <= 100 && (!considerEarlyExit || secondariesAdded < secondariesToadd)) continue;
        }
        totalAttack.append(primaryAttack.toString());
        if (secondaryAttack.length() != 0 && (hitMode == 0 || hitMode == 4)) {
            totalAttack.append(";" + secondaryAttack);
        }
        return totalAttack.toString();
    }

    private static int calcAmmoEqCorrection(String aKey, Equipment weapon, Equipment contents, Equipment ammo) {
        float bonusVal;
        float maxEnhancement = 0.0f;
        if (weapon == null) {
            return 0;
        }
        String bonus = weapon.getBonusMap().get(aKey);
        if (bonus != null) {
            maxEnhancement = Float.parseFloat(bonus);
        }
        float totalEnhancement = maxEnhancement;
        if (contents != null && (bonus = contents.getBonusMap().get(aKey)) != null) {
            bonusVal = Float.parseFloat(bonus);
            totalEnhancement += bonusVal;
            if (bonusVal > maxEnhancement) {
                maxEnhancement = bonusVal;
            }
        }
        if (ammo != null && (bonus = ammo.getBonusMap().get(aKey)) != null) {
            bonusVal = Float.parseFloat(bonus);
            totalEnhancement += bonusVal;
            if (bonusVal > maxEnhancement) {
                maxEnhancement = bonusVal;
            }
        }
        return (int)(maxEnhancement - totalEnhancement);
    }

    private static String getDamage(PlayerCharacter pc, Equipment eq, int range, int content, int ammo, boolean bonusOnly, int hands, int damageMode, boolean base) {
        boolean isDoubleSplit;
        boolean isDouble = eq.isDouble() && eq.getLocation() == EquipmentLocation.EQUIPPED_TWO_HANDS;
        boolean bl = isDoubleSplit = eq.isType("Head1") || eq.isType("Head2");
        if (eq.isMelee() && eq.isWeaponTwoHanded(pc) && !isDouble && !isDoubleSplit && damageMode != 0 && damageMode != 3 && damageMode != 4) {
            return SettingsHandler.getInvalidDmgText();
        }
        if (eq.isMelee() && eq.isWeaponOutsizedForPC(pc) && !eq.isNatural()) {
            return SettingsHandler.getInvalidDmgText();
        }
        if (eq.isWeaponLightForPC(pc) && hands == 2) {
            hands = 1;
        }
        String profName = WeaponToken.getProfName(eq);
        String damString = WeaponToken.getEqDamage(pc, eq);
        int meleeDamageStatBonus = (int)pc.getDisplay().getStatBonusTo("COMBAT", "DAMAGE.MELEE");
        meleeDamageStatBonus += (int)pc.getDisplay().getStatBonusTo("DAMAGE", "TYPE.MELEE");
        double meleeDamageMult = pc.getTotalBonusTo("COMBAT", "DAMAGEMULT:" + hands);
        meleeDamageMult += pc.getTotalBonusTo("WEAPONPROF=" + profName, "DAMAGEMULT:" + hands);
        meleeDamageMult += BonusCalc.charBonusTo(eq, TOKENNAME, "DAMAGEMULT:" + hands, pc);
        int bonus = 0;
        int weaponProfBonus = 0;
        int eqbonus = 0;
        int totalBonus = 0;
        damString = WeaponToken.getMonkUnarmed(pc, eq, damString);
        if (!base) {
            int index;
            for (index = 0; index < damString.length(); ++index) {
                if (damString.charAt(index) != '+' && damString.charAt(index) != '-') continue;
                totalBonus = Delta.decode(damString.substring(index));
                break;
            }
            eqbonus = WeaponToken.getEqBonus(pc, eq, content, ammo);
            bonus = WeaponToken.getGeneralBonus(pc, eq, range, meleeDamageStatBonus, meleeDamageMult);
            weaponProfBonus = WeaponToken.getWeaponProfBonus(pc, eq, range);
            totalBonus += bonus + weaponProfBonus + eqbonus;
            damString = damString.substring(0, index);
        }
        StringBuilder sb = new StringBuilder();
        if (!"0d0".equalsIgnoreCase(damString)) {
            if (!bonusOnly) {
                sb.append(damString);
            }
            if (totalBonus != 0 || bonusOnly) {
                sb.append(Delta.toString(totalBonus));
            }
        } else {
            sb.append("0");
        }
        if (damageMode == 4 && eq.getLocation() == EquipmentLocation.EQUIPPED_TWO_HANDS) {
            hands = 0;
            meleeDamageMult = pc.getTotalBonusTo("COMBAT", "DAMAGEMULT:" + hands);
            meleeDamageMult += pc.getTotalBonusTo("WEAPONPROF=" + profName, "DAMAGEMULT:" + hands);
            meleeDamageMult += BonusCalc.charBonusTo(eq, TOKENNAME, "DAMAGEMULT:" + hands, pc);
            totalBonus -= eqbonus;
            eqbonus = eq.getBonusToDamage(pc, false);
            if (eq.getAltDamage(pc).length() > 0) {
                totalBonus = 0;
                damString = eq.getAltDamage(pc);
                if (damString.lastIndexOf(45) >= 0) {
                    totalBonus = Integer.parseInt(damString.substring(damString.lastIndexOf(45)));
                    damString = damString.substring(0, damString.lastIndexOf(45));
                } else if (damString.lastIndexOf(43) >= 0) {
                    totalBonus = Integer.parseInt(damString.substring(damString.lastIndexOf(43) + 1));
                    damString = damString.substring(0, damString.lastIndexOf(43));
                }
            } else {
                weaponProfBonus = 0;
                bonus = 0;
            }
            if (meleeDamageStatBonus > 0) {
                bonus -= meleeDamageStatBonus;
                bonus = (int)((double)bonus + meleeDamageMult * (double)meleeDamageStatBonus);
            }
            totalBonus += bonus + weaponProfBonus + eqbonus;
            sb.append("/");
            if (!"0d0".equalsIgnoreCase(damString)) {
                if (bonusOnly) {
                    sb.append(damString);
                }
                if (totalBonus != 0 || bonusOnly) {
                    sb.append(Delta.toString(totalBonus));
                }
            } else {
                sb.append("0");
            }
        }
        return sb.toString();
    }

    private static int getGeneralBonus(PlayerCharacter pc, Equipment eq, int range, int meleeDamageStatBonus, double meleeDamageMult) {
        int rangeSize;
        int bonus = 0;
        for (String type : eq.typeList()) {
            if (range > -1 && type.equalsIgnoreCase("MELEE") || range == -1 && (type.equalsIgnoreCase("THROWN") || type.equalsIgnoreCase("RANGED"))) continue;
            bonus += (int)pc.getTotalBonusTo("COMBAT", "DAMAGE." + type);
            bonus += (int)pc.getTotalBonusTo("DAMAGE", "TYPE." + type);
        }
        if (eq.isFinessable(pc) && !eq.isType("Finesseable")) {
            bonus += (int)pc.getTotalBonusTo("COMBAT", "DAMAGE.Finesseable");
        }
        if (eq.isMelee() && meleeDamageStatBonus > 0) {
            bonus -= meleeDamageStatBonus;
            bonus = (int)((double)bonus + meleeDamageMult * (double)meleeDamageStatBonus);
        } else if (eq.isThrown()) {
            // empty if block
        }
        if (range > -1 && range < (rangeSize = WeaponToken.getRangeList(eq, true, pc).size()) && Integer.parseInt(WeaponToken.getRangeList(eq, true, pc).get(range)) <= SettingsHandler.getGame().getShortRangeDistance()) {
            bonus += (int)eq.bonusTo(pc, TOKENNAME, "DAMAGE-SHORTRANGE", true);
            bonus += (int)pc.getTotalBonusTo("DAMAGE", "SHORTRANGE");
            bonus += (int)pc.getTotalBonusTo("COMBAT", "DAMAGE-SHORTRANGE");
        }
        return bonus;
    }

    private static int getWeaponProfBonus(PlayerCharacter pc, Equipment eq, int range) {
        int rangeSize;
        String profKey = WeaponToken.getProfName(eq);
        int weaponProfBonus = (int)pc.getTotalBonusTo("WEAPONPROF=" + profKey, "DAMAGE") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "DAMAGE", 0);
        if (eq.isRanged()) {
            weaponProfBonus -= (int)pc.getBonusDueToType("WEAPONPROF=" + profKey.toUpperCase(), "DAMAGE", "NOTRANGED") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "DAMAGE.NOTRANGED", 0);
        }
        if (range > -1 && range < (rangeSize = WeaponToken.getRangeList(eq, true, pc).size()) && Integer.parseInt(WeaponToken.getRangeList(eq, true, pc).get(range)) <= SettingsHandler.getGame().getShortRangeDistance()) {
            weaponProfBonus += (int)pc.getTotalBonusTo("WEAPONPROF=" + profKey, "DAMAGE-SHORTRANGE") + WeaponToken.getWeaponProfTypeBonuses(pc, eq, "DAMAGE-SHORTRANGE", 0);
        }
        return weaponProfBonus;
    }

    private static int getEqBonus(PlayerCharacter pc, Equipment eq, int content, int ammo) {
        Equipment ammoUser;
        int eqbonus = eq.getBonusToDamage(pc, true);
        Equipment containedEq = null;
        if (content > -1 && content < eq.getContainedEquipmentCount()) {
            containedEq = eq.getContainedEquipment(content);
            eqbonus += containedEq.getBonusToDamage(pc, true);
        }
        if ((ammoUser = WeaponToken.getAmmoUser(pc, eq, ammo)) != null) {
            eqbonus += ammoUser.getBonusToDamage(pc, true);
        }
        if (!Globals.checkRule("AMMOSTACKSWITHWEAPON")) {
            eqbonus += WeaponToken.calcAmmoEqCorrection("WEAPON.DAMAGE.ENHANCEMENT", eq, containedEq, ammoUser);
        }
        return eqbonus;
    }

    private static String getMonkUnarmed(PlayerCharacter pc, Equipment eq, String damString) {
        if (eq.isMonk() && eq.isUnarmed()) {
            SizeAdjustment defAdj;
            int iMod;
            int eqSize = pc.getDisplay().getRace().getSafe(FormulaKey.SIZE).resolve(pc, "").intValue();
            boolean applySize = eqSize == (iMod = pc.getDisplay().sizeInt());
            String uDamString = UnarmedDamageDisplay.getUnarmedDamageString(pc, false, applySize);
            StringTokenizer bTok = new StringTokenizer(damString, " d+-", false);
            bTok.nextToken();
            String b1String = bTok.nextToken();
            StringTokenizer cTok = new StringTokenizer(uDamString, " d+-", false);
            cTok.nextToken();
            String c1String = cTok.nextToken();
            if (Integer.parseInt(b1String) < Integer.parseInt(c1String)) {
                damString = uDamString;
            }
            iMod += (int)pc.getTotalBonusTo("WEAPONPROF=Unarmed Strike", "DAMAGESIZE");
            iMod += (int)pc.getTotalBonusTo("COMBAT", "DAMAGESIZE");
            if (!applySize && (defAdj = SizeUtilities.getDefaultSizeAdjustment()) != null) {
                eqSize = defAdj.get(IntegerKey.SIZEORDER);
            }
            damString = Globals.adjustDamage(damString, eqSize, iMod);
        }
        return damString;
    }

    private static String getEqDamage(PlayerCharacter pc, Equipment eq) {
        String retString = eq.getDamage(pc);
        if (pc == null) {
            return retString;
        }
        String profKey = WeaponToken.getProfName(eq);
        if (eq.isNatural()) {
            int eqSize = pc.getDisplay().racialSizeInt();
            int iMod = pc.getDisplay().sizeInt();
            iMod += (int)pc.getTotalBonusTo("WEAPONPROF=" + profKey, "DAMAGESIZE");
            retString = Globals.adjustDamage(retString, eqSize, iMod += (int)pc.getTotalBonusTo("COMBAT", "DAMAGESIZE"));
        } else {
            int eqSize;
            int iMod = eqSize = eq.sizeInt();
            iMod += (int)pc.getTotalBonusTo("WEAPONPROF=" + profKey, "DAMAGESIZE");
            retString = Globals.adjustDamage(retString, eqSize, iMod += (int)pc.getTotalBonusTo("COMBAT", "DAMAGESIZE"));
        }
        return retString;
    }

    private static Equipment getAmmoUser(PlayerCharacter pc, Equipment eq, int ammo) {
        int ammoCount = 0;
        if (ammo < 0) {
            return null;
        }
        String containerCapacity = eq.getContainerCapacityString();
        for (Equipment equip : pc.getEquipmentListInOutputOrder()) {
            for (String type : equip.typeList()) {
                if (containerCapacity.indexOf(type) < 0) continue;
                ++ammoCount;
                break;
            }
            if (ammoCount != ammo + 1) continue;
            return equip;
        }
        return null;
    }

    private static int getWeaponProfTypeBonuses(PlayerCharacter pc, Equipment eq, String bonusType, int index) {
        int bonus = 0;
        boolean hasBoth = eq.isRanged() && eq.isMelee();
        CDOMSingleRef<WeaponProf> ref = eq.get(ObjectKey.WEAPON_PROF);
        if (ref == null) {
            return 0;
        }
        WeaponProf wp = ref.resolvesTo();
        StringTokenizer aTok = new StringTokenizer(wp.getType(), ".");
        block6: while (aTok.hasMoreTokens()) {
            String tString = aTok.nextToken();
            if (hasBoth && "RANGED".equalsIgnoreCase(tString)) continue;
            switch (index) {
                case 0: {
                    bonus += (int)pc.getTotalBonusTo("WEAPONPROF=TYPE." + tString, bonusType);
                    continue block6;
                }
                case 1: {
                    bonus += (int)BonusCalc.charBonusTo(eq, "WEAPONPROF=TYPE." + tString, bonusType, pc);
                    continue block6;
                }
                case 2: {
                    bonus += (int)pc.getFeatBonusTo("WEAPONPROF=TYPE." + tString, bonusType);
                    continue block6;
                }
                case 3: {
                    bonus += (int)pc.getTemplateBonusTo("WEAPONPROF=TYPE." + tString, bonusType);
                    continue block6;
                }
            }
            Logging.errorPrint("In getWeaponProfTypeBonuses there is an unhandled case in a switch (the value is " + index + ".");
        }
        return bonus;
    }

    private static String weaponCategories(Equipment eq) {
        StringBuilder wc = new StringBuilder(10);
        StringTokenizer aTok = new StringTokenizer(SettingsHandler.getGame().getWeaponCategories(), "|", false);
        while (aTok.hasMoreTokens()) {
            String type = aTok.nextToken();
            if (!eq.isType(type, true)) continue;
            if (wc.length() != 0) {
                wc.append('/');
            }
            wc.append(type);
        }
        if (wc.length() == 0) {
            wc.append("Non-Standard");
        }
        return wc.toString();
    }

    private static String weaponTypes(Equipment eq, boolean primary) {
        StringBuilder wt = new StringBuilder(10);
        StringTokenizer aTok = new StringTokenizer(SettingsHandler.getGame().getWeaponTypes(), "|", false);
        while (aTok.countTokens() >= 2) {
            String type = aTok.nextToken();
            String abbrev = aTok.nextToken();
            if (!eq.isType(type, primary)) continue;
            wt.append(abbrev);
        }
        return wt.toString();
    }

    private static String getRangedAttackString(PlayerCharacter pc) {
        return pc.getAttackString(AttackType.RANGED, 0, 0);
    }

    private static String getRangedAttackString(PlayerCharacter pc, int bonus, int BABBonus) {
        return pc.getAttackString(AttackType.RANGED, bonus, BABBonus);
    }

    private static String getMeleeAttackString(PlayerCharacter pc) {
        return pc.getAttackString(AttackType.MELEE, 0, 0);
    }

    private static String getMeleeAttackString(PlayerCharacter pc, int bonus, int BABBonus) {
        return pc.getAttackString(AttackType.MELEE, bonus, BABBonus);
    }

    private static String getUnarmedAttackString(PlayerCharacter pc) {
        return pc.getAttackString(AttackType.UNARMED, 0, 0);
    }

    private static String getUnarmedAttackString(PlayerCharacter pc, int bonus, int BABBonus) {
        return pc.getAttackString(AttackType.UNARMED, bonus, BABBonus);
    }

    private static boolean appendSeperator(Equipment eq) {
        return eq.isType("Natural") && (eq.isType("Both") || eq.isType("Melee") || eq.isType("Ranged"));
    }

    private static boolean isNonStandard(Equipment eq) {
        return !eq.isType("Natural") && !eq.isType("Both") && !eq.isType("Melee") && !eq.isType("Ranged");
    }

    public static List<String> getRangeList(Equipment eq, boolean addShortRange, PlayerCharacter aPC) {
        int baseRange;
        ArrayList<String> aList = new ArrayList<String>();
        int aRange = baseRange = eq.getRange(aPC).intValue();
        int maxIncrements = 0;
        if (eq.isRanged()) {
            maxIncrements = eq.isThrown() ? 5 : 10;
        }
        for (int numIncrements = 0; numIncrements < maxIncrements; ++numIncrements) {
            if (aRange == SettingsHandler.getGame().getShortRangeDistance()) {
                addShortRange = false;
            }
            if (aRange > SettingsHandler.getGame().getShortRangeDistance() && addShortRange) {
                aList.add(Integer.toString(SettingsHandler.getGame().getShortRangeDistance()));
                addShortRange = false;
            }
            aList.add(Integer.toString(aRange));
            aRange += baseRange;
        }
        return aList;
    }
}

