/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Delta;

public class HitDiceToken
extends Token {
    public static final String TOKENNAME = "HITDICE";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        String retString = "";
        if (TOKENNAME.equals(tokenSource) || "HITDICE.LONG".equals(tokenSource)) {
            retString = HitDiceToken.getHitDiceToken(pc);
        } else if ("HITDICE.MEDIUM".equals(tokenSource)) {
            retString = HitDiceToken.getMediumToken(pc);
        } else if ("HITDICE.SHORT".equals(tokenSource)) {
            retString = HitDiceToken.getShortToken(pc.getDisplay());
        }
        return retString;
    }

    public static String getHitDiceToken(PlayerCharacter pc) {
        StringBuilder ret = new StringBuilder();
        String del = "";
        CharacterDisplay display = pc.getDisplay();
        for (PCClass pcClass : display.getClassSet()) {
            LinkedHashMap<Integer, Integer> hdMap = new LinkedHashMap<Integer, Integer>();
            for (int i = 0; i < display.getLevel(pcClass); ++i) {
                int hitDie = display.getLevelHitDie(pcClass, i + 1).getDie();
                if (hitDie == 0) continue;
                Integer num = (Integer)((HashMap)hdMap).get(hitDie);
                if (num == null) {
                    hdMap.put(hitDie, 1);
                    continue;
                }
                hdMap.put(hitDie, num + 1);
            }
            Set keys = ((HashMap)hdMap).keySet();
            Iterator i$ = keys.iterator();
            while (i$.hasNext()) {
                int key = (Integer)i$.next();
                Integer value = (Integer)((HashMap)hdMap).get(key);
                ret.append(del);
                ret.append("(");
                ret.append(value).append("d").append(key);
                ret.append(")");
                del = "+";
            }
        }
        int temp = (int)display.getStatBonusTo("HP", "BONUS") * display.getTotalLevels();
        if ((temp += (int)pc.getTotalBonusTo("HP", "CURRENTMAX")) != 0) {
            ret.append(Delta.toString(temp));
        }
        return ret.toString();
    }

    public static String getMediumToken(PlayerCharacter pc) {
        StringBuilder ret = new StringBuilder();
        String del = "";
        Integer total = 0;
        LinkedHashMap<Integer, Integer> hdMap = new LinkedHashMap<Integer, Integer>();
        CharacterDisplay display = pc.getDisplay();
        for (PCClass pcClass : display.getClassSet()) {
            for (int i = 0; i < display.getLevel(pcClass); ++i) {
                int hitDie = display.getLevelHitDie(pcClass, i + 1).getDie();
                if (hitDie == 0) continue;
                Integer num = (Integer)((HashMap)hdMap).get(hitDie);
                if (num == null) {
                    hdMap.put(hitDie, 1);
                    continue;
                }
                hdMap.put(hitDie, num + 1);
            }
        }
        Set keys = ((HashMap)hdMap).keySet();
        if (keys.size() > 1) {
            ret.append(HitDiceToken.getShortToken(display));
            ret.append(" HD; ");
        }
        Iterator i$ = keys.iterator();
        while (i$.hasNext()) {
            int key = (Integer)i$.next();
            Integer value = (Integer)((HashMap)hdMap).get(key);
            ret.append(del);
            ret.append(value).append("d").append(key);
            total = total + value;
            del = "+";
        }
        int temp = (int)display.getStatBonusTo("HP", "BONUS") * display.getTotalLevels();
        if ((temp += (int)pc.getTotalBonusTo("HP", "CURRENTMAX")) != 0) {
            ret.append(Delta.toString(temp));
        }
        return ret.toString();
    }

    public static String getShortToken(CharacterDisplay display) {
        int dice = 0;
        for (PCClass pcClass : display.getClassSet()) {
            LinkedHashMap<Integer, Integer> hdMap = new LinkedHashMap<Integer, Integer>();
            for (int i = 0; i < display.getLevel(pcClass); ++i) {
                int hitDie = display.getLevelHitDie(pcClass, i + 1).getDie();
                Integer num = (Integer)((HashMap)hdMap).get(hitDie);
                if (num == null) {
                    hdMap.put(hitDie, 1);
                    continue;
                }
                hdMap.put(hitDie, num + 1);
            }
            Set keys = ((HashMap)hdMap).keySet();
            Iterator i$ = keys.iterator();
            while (i$.hasNext()) {
                int hdSize = (Integer)i$.next();
                dice += ((Integer)((HashMap)hdMap).get(hdSize)).intValue();
            }
        }
        return String.valueOf(dice);
    }
}

