/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.spell;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.spell.Spell;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class SubschoolToken
extends AbstractTokenWithSeparator<Spell>
implements CDOMPrimaryToken<Spell> {
    public String getTokenName() {
        return "SUBSCHOOL";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, Spell spell, String value) {
        StringTokenizer aTok = new StringTokenizer(value, "|");
        boolean first = true;
        while (aTok.hasMoreTokens()) {
            String tokString = aTok.nextToken();
            if (".CLEAR".equals(tokString)) {
                if (!first) {
                    return new ParseResult.Fail("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item: " + value, context);
                }
                context.getObjectContext().removeList((CDOMObject)spell, ListKey.SPELL_SUBSCHOOL);
            } else {
                context.getObjectContext().addToList((CDOMObject)spell, ListKey.SPELL_SUBSCHOOL, (Object)tokString);
            }
            first = false;
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Spell spell) {
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)spell, ListKey.SPELL_SUBSCHOOL);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (changes.includesGlobalClear()) {
            sb.append(".CLEAR");
        }
        if (changes.hasAddedItems()) {
            if (sb.length() != 0) {
                sb.append("|");
            }
            sb.append((CharSequence)StringUtil.joinToStringBuilder((Collection)changes.getAdded(), (String)"|"));
        }
        return new String[]{sb.toString()};
    }

    public Class<Spell> getTokenClass() {
        return Spell.class;
    }
}

