/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.MapKey;
import pcgen.core.PCClass;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.MapChanges;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.enumeration.AttackType;

public class AttackcycleToken
extends AbstractTokenWithSeparator<PCClass>
implements CDOMPrimaryToken<PCClass> {
    public String getTokenName() {
        return "ATTACKCYCLE";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClass pcc, String value) {
        StringTokenizer aTok = new StringTokenizer(value, "|");
        if (aTok.countTokens() % 2 != 0) {
            return new ParseResult.Fail(this.getTokenName() + " must have an even number of arguments.", context);
        }
        while (aTok.hasMoreTokens()) {
            AttackType at = AttackType.getInstance((String)aTok.nextToken());
            if (AttackType.GRAPPLE.equals((Object)at)) {
                return new ParseResult.Fail("Error: Cannot Set Attack Cycle for GRAPPLE Attack Type", context);
            }
            String cycle = aTok.nextToken();
            try {
                Integer i = Integer.parseInt(cycle);
                if (i <= 0) {
                    return new ParseResult.Fail("Invalid " + this.getTokenName() + ": " + value + " Cycle " + cycle + " must be a positive integer.", context);
                }
                context.getObjectContext().put((CDOMObject)pcc, MapKey.ATTACK_CYCLE, (Object)at, (Object)i);
                if (!at.equals((Object)AttackType.MELEE)) continue;
                context.getObjectContext().put((CDOMObject)pcc, MapKey.ATTACK_CYCLE, (Object)AttackType.GRAPPLE, (Object)i);
            }
            catch (NumberFormatException e) {
                return new ParseResult.Fail("Invalid " + this.getTokenName() + ": " + value + " Cycle " + cycle + " must be a (positive) integer.", context);
            }
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PCClass pcc) {
        MapChanges changes = context.getObjectContext().getMapChanges((CDOMObject)pcc, MapKey.ATTACK_CYCLE);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        Integer grappleValue = null;
        Integer meleeValue = null;
        Map added = changes.getAdded();
        for (Map.Entry me : added.entrySet()) {
            AttackType attackType = (AttackType)me.getKey();
            Integer value = (Integer)me.getValue();
            if (value == null) continue;
            if (value <= 0) {
                context.addWriteMessage("Invalid " + this.getTokenName() + ": " + value + " Cycle " + attackType + " must be a positive integer.");
                return null;
            }
            if (attackType.equals((Object)AttackType.GRAPPLE)) {
                grappleValue = value;
                continue;
            }
            if (attackType.equals((Object)AttackType.MELEE)) {
                meleeValue = value;
            }
            set.add(attackType.getIdentifier() + "|" + value);
        }
        if (grappleValue != null && !grappleValue.equals(meleeValue)) {
            context.addWriteMessage("Grapple Attack Cycle (" + grappleValue + ") MUST be equal to " + "Melee Attack Cycle (" + meleeValue + ") because it is not stored");
            return null;
        }
        if (set.isEmpty()) {
            return null;
        }
        return new String[]{StringUtil.join(set, (String)"|")};
    }

    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

