/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.dom.Property;
import com.steadystate.css.parser.CSSOMParser;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSStyleDeclarationImpl
implements CSSStyleDeclaration,
Serializable {
    private final CSSRule _parentRule;
    private final ArrayList _properties = new ArrayList(4);
    private final Map _propertiesMap = new HashMap(6);

    public CSSStyleDeclarationImpl(CSSRule parentRule) {
        this._parentRule = parentRule;
    }

    public String getCssText() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        ArrayList props = this._properties;
        int size = props.size();
        for (int i = 0; i < size; ++i) {
            Property p = (Property)props.get(i);
            if (p != null) {
                sb.append(p.toString());
            }
            if (i >= size - 1) continue;
            sb.append("; ");
        }
        sb.append("}");
        return sb.toString();
    }

    public void setCssText(String cssText) throws DOMException {
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            this._properties.clear();
            this._propertiesMap.clear();
            parser.parseStyleDeclaration(this, is);
        }
        catch (Exception e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public String getPropertyValue(String propertyName) {
        Property p = this.getPropertyDeclaration(propertyName);
        return p != null ? p.getValue().getCssText() : "";
    }

    public CSSValue getPropertyCSSValue(String propertyName) {
        Property p = this.getPropertyDeclaration(propertyName);
        return p != null ? p.getValue() : null;
    }

    public String removeProperty(String propertyName) throws DOMException {
        Map propsMap = this._propertiesMap;
        Property prop = (Property)propsMap.remove(propertyName.toLowerCase());
        if (prop != null) {
            this._properties.remove(prop);
            CSSValue value = prop.getValue();
            return value == null ? "" : value.getCssText();
        }
        return "";
    }

    public String getPropertyPriority(String propertyName) {
        Property p = this.getPropertyDeclaration(propertyName);
        if (p != null) {
            return p.isImportant() ? "important" : "";
        }
        return "";
    }

    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        try {
            boolean important;
            InputSource is = new InputSource(new StringReader(value));
            CSSOMParser parser = new CSSOMParser();
            CSSValue expr = parser.parsePropertyValue(is);
            Property p = this.getPropertyDeclaration(propertyName);
            boolean bl = important = priority != null ? priority.equalsIgnoreCase("important") : false;
            if (p == null) {
                p = new Property(propertyName, expr, important);
                this.addProperty(p);
            } else {
                p.setValue(expr);
                p.setImportant(important);
            }
        }
        catch (Exception e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public int getLength() {
        return this._properties.size();
    }

    public String item(int index) {
        Property p = (Property)this._properties.get(index);
        return p != null ? p.getName() : "";
    }

    public CSSRule getParentRule() {
        return this._parentRule;
    }

    public void addProperty(Property p) {
        this._propertiesMap.put(p.getName().toLowerCase(), p);
        this._properties.add(p);
    }

    private Property getPropertyDeclaration(String name) {
        return (Property)this._propertiesMap.get(name.toLowerCase());
    }

    public String toString() {
        return this.getCssText();
    }
}

