/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8;

import com.eclipsesource.v8.JavaCallback;
import com.eclipsesource.v8.JavaVoidCallback;
import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8ResultUndefined;
import com.eclipsesource.v8.V8Value;

public class V8Array
extends V8Object {
    protected V8Array() {
    }

    public V8Array(V8 v8) {
        super(v8);
        v8.checkThread();
    }

    protected V8Array(V8 v8, Object data) {
        super(v8, data);
    }

    @Override
    protected V8Value createTwin() {
        return new V8Array(this.v8);
    }

    @Override
    public V8Array twin() {
        return (V8Array)super.twin();
    }

    @Override
    protected void initialize(long runtimePtr, Object data) {
        long handle = this.v8.initNewV8Array(runtimePtr);
        this.released = false;
        this.addObjectReference(handle);
    }

    public int length() {
        this.v8.checkThread();
        this.checkReleased();
        return this.v8.arrayGetSize(this.v8.getV8RuntimePtr(), this.getHandle());
    }

    public int getType(int index) {
        this.v8.checkThread();
        this.checkReleased();
        return this.v8.getType(this.v8.getV8RuntimePtr(), this.getHandle(), index);
    }

    public int getType() {
        this.v8.checkThread();
        this.checkReleased();
        return this.v8.getArrayType(this.v8.getV8RuntimePtr(), this.getHandle());
    }

    public int getType(int index, int length) {
        this.v8.checkThread();
        this.checkReleased();
        return this.v8.getType(this.v8.getV8RuntimePtr(), this.getHandle(), index, length);
    }

    public int getInteger(int index) {
        this.v8.checkThread();
        this.checkReleased();
        return this.v8.arrayGetInteger(this.v8.getV8RuntimePtr(), this.getHandle(), index);
    }

    public boolean getBoolean(int index) {
        this.v8.checkThread();
        this.checkReleased();
        return this.v8.arrayGetBoolean(this.v8.getV8RuntimePtr(), this.getHandle(), index);
    }

    public byte getByte(int index) {
        this.v8.checkThread();
        this.checkReleased();
        return this.v8.arrayGetByte(this.v8.getV8RuntimePtr(), this.getHandle(), index);
    }

    public double getDouble(int index) {
        this.v8.checkThread();
        this.checkReleased();
        return this.v8.arrayGetDouble(this.v8.getV8RuntimePtr(), this.getHandle(), index);
    }

    public String getString(int index) {
        this.v8.checkThread();
        this.checkReleased();
        return this.v8.arrayGetString(this.v8.getV8RuntimePtr(), this.getHandle(), index);
    }

    public int[] getIntegers(int index, int length) {
        this.v8.checkThread();
        this.checkReleased();
        return this.v8.arrayGetIntegers(this.v8.getV8RuntimePtr(), this.getHandle(), index, length);
    }

    public int getIntegers(int index, int length, int[] resultArray) {
        this.v8.checkThread();
        this.checkReleased();
        if (length > resultArray.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.v8.arrayGetIntegers(this.v8.getV8RuntimePtr(), this.getHandle(), index, length, resultArray);
    }

    public double[] getDoubles(int index, int length) {
        this.v8.checkThread();
        this.checkReleased();
        return this.v8.arrayGetDoubles(this.v8.getV8RuntimePtr(), this.getHandle(), index, length);
    }

    public int getDoubles(int index, int length, double[] resultArray) {
        this.v8.checkThread();
        this.checkReleased();
        if (length > resultArray.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.v8.arrayGetDoubles(this.v8.getV8RuntimePtr(), this.getHandle(), index, length, resultArray);
    }

    public boolean[] getBooleans(int index, int length) {
        this.v8.checkThread();
        this.checkReleased();
        return this.v8.arrayGetBooleans(this.v8.getV8RuntimePtr(), this.getHandle(), index, length);
    }

    public byte[] getBytes(int index, int length) {
        this.v8.checkThread();
        this.checkReleased();
        return this.v8.arrayGetBytes(this.v8.getV8RuntimePtr(), this.getHandle(), index, length);
    }

    public int getBooleans(int index, int length, boolean[] resultArray) {
        this.v8.checkThread();
        this.checkReleased();
        if (length > resultArray.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.v8.arrayGetBooleans(this.v8.getV8RuntimePtr(), this.getHandle(), index, length, resultArray);
    }

    public int getBytes(int index, int length, byte[] resultArray) {
        this.v8.checkThread();
        this.checkReleased();
        if (length > resultArray.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.v8.arrayGetBytes(this.v8.getV8RuntimePtr(), this.getHandle(), index, length, resultArray);
    }

    public String[] getStrings(int index, int length) {
        this.v8.checkThread();
        this.checkReleased();
        return this.v8.arrayGetStrings(this.v8.getV8RuntimePtr(), this.getHandle(), index, length);
    }

    public int getStrings(int index, int length, String[] resultArray) {
        this.v8.checkThread();
        this.checkReleased();
        if (length > resultArray.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.v8.arrayGetStrings(this.v8.getV8RuntimePtr(), this.getHandle(), index, length, resultArray);
    }

    public Object get(int index) {
        this.v8.checkThread();
        this.checkReleased();
        return this.v8.arrayGet(this.v8.getV8RuntimePtr(), 6, this.objectHandle, index);
    }

    public V8Array getArray(int index) {
        this.v8.checkThread();
        this.checkReleased();
        Object result2 = this.v8.arrayGet(this.v8.getV8RuntimePtr(), 5, this.objectHandle, index);
        if (result2 == null || result2 instanceof V8Array) {
            return (V8Array)result2;
        }
        throw new V8ResultUndefined();
    }

    public V8Object getObject(int index) {
        this.v8.checkThread();
        this.checkReleased();
        Object result2 = this.v8.arrayGet(this.v8.getV8RuntimePtr(), 6, this.objectHandle, index);
        if (result2 == null || result2 instanceof V8Object) {
            return (V8Object)result2;
        }
        throw new V8ResultUndefined();
    }

    public V8Array push(int value) {
        this.v8.checkThread();
        this.checkReleased();
        this.v8.addArrayIntItem(this.v8.getV8RuntimePtr(), this.getHandle(), value);
        return this;
    }

    public V8Array push(boolean value) {
        this.v8.checkThread();
        this.checkReleased();
        this.v8.addArrayBooleanItem(this.v8.getV8RuntimePtr(), this.getHandle(), value);
        return this;
    }

    public V8Array push(double value) {
        this.v8.checkThread();
        this.checkReleased();
        this.v8.addArrayDoubleItem(this.v8.getV8RuntimePtr(), this.getHandle(), value);
        return this;
    }

    public V8Array push(String value) {
        this.v8.checkThread();
        this.checkReleased();
        if (value == null) {
            this.v8.addArrayNullItem(this.v8.getV8RuntimePtr(), this.getHandle());
        } else if (value.equals(V8.getUndefined())) {
            this.v8.addArrayUndefinedItem(this.v8.getV8RuntimePtr(), this.getHandle());
        } else {
            this.v8.addArrayStringItem(this.v8.getV8RuntimePtr(), this.getHandle(), value);
        }
        return this;
    }

    public V8Array push(V8Value value) {
        this.v8.checkThread();
        this.checkReleased();
        if (value == null) {
            this.v8.addArrayNullItem(this.v8.getV8RuntimePtr(), this.getHandle());
        } else if (value.equals(V8.getUndefined())) {
            this.v8.addArrayUndefinedItem(this.v8.getV8RuntimePtr(), this.getHandle());
        } else {
            this.v8.addArrayObjectItem(this.v8.getV8RuntimePtr(), this.getHandle(), value.getHandle());
        }
        return this;
    }

    public V8Array pushNull() {
        this.v8.checkThread();
        this.checkReleased();
        this.v8.addArrayNullItem(this.v8.getV8RuntimePtr(), this.getHandle());
        return this;
    }

    public V8Array pushUndefined() {
        this.v8.checkThread();
        this.checkReleased();
        this.v8.addArrayUndefinedItem(this.v8.getV8RuntimePtr(), this.getHandle());
        return this;
    }

    static class Undefined
    extends V8Array {
        @Override
        public boolean isUndefined() {
            return true;
        }

        @Override
        public boolean isReleased() {
            return false;
        }

        @Override
        public void release() {
        }

        @Override
        public Undefined twin() {
            return (Undefined)super.twin();
        }

        @Override
        public String toString() {
            return "undefined";
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof V8Object && ((V8Object)that).isUndefined();
        }

        @Override
        public int hashCode() {
            return 919;
        }

        @Override
        public V8 getRuntime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Object add(String key2, boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Object add(String key2, double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Object add(String key2, int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Object add(String key2, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Object add(String key2, V8Value value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Object addUndefined(String key2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(String key2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Array executeArrayFunction(String name, V8Array parameters) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean executeBooleanFunction(String name, V8Array parameters) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double executeDoubleFunction(String name, V8Array parameters) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int executeIntegerFunction(String name, V8Array parameters) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Object executeObjectFunction(String name, V8Array parameters) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String executeStringFunction(String name, V8Array parameters) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void executeVoidFunction(String name, V8Array parameters) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Array getArray(String key2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getBoolean(String key2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getDouble(String key2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getInteger(String key2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getKeys() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Object getObject(String key2) throws V8ResultUndefined {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getString(String key2) throws V8ResultUndefined {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getType(String key2) throws V8ResultUndefined {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Object registerJavaMethod(JavaCallback callback, String jsFunctionName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Object registerJavaMethod(JavaVoidCallback callback, String jsFunctionName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Object registerJavaMethod(Object object, String methodName, String jsFunctionName, Class<?>[] parameterTypes, boolean includeReceiver) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Object setPrototype(V8Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Array getArray(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getBoolean(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean[] getBooleans(int index, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getBytes(int index, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getBytes(int index, int length, byte[] resultArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte getByte(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getBooleans(int index, int length, boolean[] resultArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getDouble(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double[] getDoubles(int index, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDoubles(int index, int length, double[] resultArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getInteger(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int[] getIntegers(int index, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getIntegers(int index, int length, int[] resultArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Object getObject(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getString(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getStrings(int index, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getStrings(int index, int length, String[] resultArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getType(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getType(int index, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int length() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Array push(boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Array push(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Array push(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Array push(String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Array push(V8Value value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V8Array pushUndefined() {
            throw new UnsupportedOperationException();
        }
    }
}

