/*
 * Decompiled with CFR 0.152.
 */
package mill.api;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.FileTime;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import mill.api.DummyOutputStream$;
import mill.api.PathRef;
import mill.api.PathRef$Revalidate$Always$;
import mill.api.PathRef$Revalidate$Never$;
import mill.api.PathRef$Revalidate$Once$;
import mill.api.StreamSupport$;
import mill.moduledefs.Scaladoc;
import os.Path;
import os.Path$;
import os.PathConvertible$StringConvertible$;
import os.Shellable;
import os.Shellable$;
import os.StatInfo;
import os.SubPath;
import os.exists$;
import os.perms$;
import os.read$inputStream$;
import os.walk$;
import scala.Array;
import scala.Array$;
import scala.Array$UnapplySeqWrapper$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableOps;
import scala.math.Ordering$String$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.DynamicVariable;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;
import upickle.core.Types;
import upickle.default$;

public final class PathRef$
implements Serializable {
    public static final PathRef$ MODULE$ = new PathRef$();
    private static final DynamicVariable<PathRef.ValidatedPaths> validatedPaths = new DynamicVariable<PathRef.ValidatedPaths>(new PathRef.ValidatedPaths());

    public Shellable shellable(PathRef p) {
        return Shellable$.MODULE$.PathShellable(p.path());
    }

    public DynamicVariable<PathRef.ValidatedPaths> validatedPaths() {
        return validatedPaths;
    }

    public PathRef apply(Path path, boolean quick, int sig, PathRef.Revalidate revalidate) {
        return new PathRef(path, quick, sig, revalidate);
    }

    @Scaladoc(value="/**\n   * Create a [[PathRef]] by recursively digesting the content of a given `path`.\n   *\n   * @param path The digested path.\n   * @param quick If `true` the digest is only based to some file attributes (like mtime and size).\n   *              If `false` the digest is created of the files content.\n   * @return\n   */")
    public PathRef apply(Path path, boolean quick, PathRef.Revalidate revalidate) {
        Path basePath = path;
        boolean isPosix = path.wrapped().getFileSystem().supportedFileAttributeViews().contains("posix");
        MessageDigest digest = MessageDigest.getInstance("MD5");
        DigestOutputStream digestOut = new DigestOutputStream(DummyOutputStream$.MODULE$, digest);
        if (exists$.MODULE$.apply(path)) {
            Path x$1 = path;
            boolean x$22 = true;
            boolean x$3 = true;
            Function2<Path, StatInfo, Object> x$42 = walk$.MODULE$.attrs$default$2();
            boolean x$5 = walk$.MODULE$.attrs$default$3();
            int x$6 = walk$.MODULE$.attrs$default$5();
            ((IterableOps)walk$.MODULE$.attrs(x$1, x$42, x$5, true, x$6, true).sortBy((Function1<Tuple2, String> & Serializable)x$2 -> ((Path)x$2._1()).toString(), Ordering$String$.MODULE$)).withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(PathRef$.$anonfun$apply$2(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$4 -> {
                PathRef$.$anonfun$apply$3(basePath, digest, isPosix, quick, digestOut, x$4);
                return BoxedUnit.UNIT;
            });
        }
        int sig = Arrays.hashCode(digest.digest());
        return new PathRef(path, quick, sig, revalidate);
    }

    public boolean apply$default$2() {
        return false;
    }

    public PathRef.Revalidate apply$default$3() {
        return PathRef$Revalidate$Never$.MODULE$;
    }

    @Scaladoc(value="/**\n   * Default JSON formatter for [[PathRef]].\n   */")
    public Types.ReadWriter<PathRef> jsonFormatter() {
        return default$.MODULE$.readwriter(default$.MODULE$.ReadWriter().join(default$.MODULE$.StringReader(), default$.MODULE$.StringWriter())).bimap((Function1<PathRef, String> & Serializable)p -> p.toString(), (Function1<String, PathRef> & Serializable)s -> {
            Product product;
            boolean quick;
            Path path;
            String hex;
            block11: {
                boolean bl;
                String valid0;
                block10: {
                    Object object;
                    String[] stringArray = s.split(":", 4);
                    if (stringArray == null || Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(stringArray)) || new Array.UnapplySeqWrapper(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 4) != 0) {
                        throw new MatchError(stringArray);
                    }
                    String prefix = (String)Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                    String valid02 = (String)Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                    String hex2 = (String)Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
                    String pathString = (String)Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 3);
                    Tuple4<String, String, String, String> tuple4 = new Tuple4<String, String, String, String>(prefix, valid02, hex2, pathString);
                    String prefix2 = tuple4._1();
                    valid0 = tuple4._2();
                    hex = tuple4._3();
                    String pathString2 = tuple4._4();
                    path = Path$.MODULE$.apply(pathString2, PathConvertible$StringConvertible$.MODULE$);
                    String string = prefix2;
                    switch (string == null ? 0 : string.hashCode()) {
                        case 112787: {
                            if (!"ref".equals(string)) break;
                            bl = false;
                            break block10;
                        }
                        case 3479170: {
                            if (!"qref".equals(string)) break;
                            bl = true;
                            break block10;
                        }
                    }
                    throw new MatchError((Object)string);
                }
                quick = bl;
                String string = valid0;
                switch (string == null ? 0 : string.hashCode()) {
                    case 3706: {
                        if (!"v0".equals(string)) break;
                        product = PathRef$Revalidate$Never$.MODULE$;
                        break block11;
                    }
                    case 3707: {
                        if (!"v1".equals(string)) break;
                        product = PathRef$Revalidate$Once$.MODULE$;
                        break block11;
                    }
                    case 3768: {
                        if (!"vn".equals(string)) break;
                        product = PathRef$Revalidate$Always$.MODULE$;
                        break block11;
                    }
                }
                throw new MatchError((Object)string);
            }
            Product validOrig = product;
            int sig = (int)Long.parseLong(hex, 16);
            PathRef pr = MODULE$.apply(path, quick, sig, (PathRef.Revalidate)((Object)validOrig));
            MODULE$.validatedPaths().value().revalidateIfNeededOrThrow(pr);
            return pr;
        });
    }

    private Option<Tuple4<Path, Object, Object, PathRef.Revalidate>> unapply(PathRef pathRef) {
        return new Some<Tuple4<Path, Object, Object, PathRef.Revalidate>>(new Tuple4<Path, Boolean, Integer, PathRef.Revalidate>(pathRef.path(), BoxesRunTime.boxToBoolean(pathRef.quick()), BoxesRunTime.boxToInteger(pathRef.sig()), pathRef.revalidate()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PathRef$.class);
    }

    private static final void updateWithInt$1(int value, MessageDigest digest$1) {
        digest$1.update((byte)(value >>> 24));
        digest$1.update((byte)(value >>> 16));
        digest$1.update((byte)(value >>> 8));
        digest$1.update((byte)value);
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$apply$3(Path basePath$1, MessageDigest digest$1, boolean isPosix$1, boolean quick$1, DigestOutputStream digestOut$1, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 != null) {
            Path path = (Path)tuple2._1();
            StatInfo attrs = (StatInfo)tuple2._2();
            SubPath sub = path.subRelativeTo(basePath$1);
            digest$1.update(sub.toString().getBytes());
            if (!attrs.isDir()) {
                block9: {
                    BoxedUnit boxedUnit;
                    try {
                        if (isPosix$1) {
                            PathRef$.updateWithInt$1(perms$.MODULE$.apply(path, false).value(), digest$1);
                        }
                        if (quick$1) {
                            int value = new Tuple2<FileTime, Long>(attrs.mtime(), BoxesRunTime.boxToLong(attrs.size())).hashCode();
                            PathRef$.updateWithInt$1(value, digest$1);
                            boxedUnit = BoxedUnit.UNIT;
                            break block9;
                        }
                        if (Files.isReadable(path.toNIO())) {
                            Option option;
                            try {
                                option = new Some<InputStream>(read$inputStream$.MODULE$.apply(path));
                            }
                            catch (FileSystemException fileSystemException) {
                                option = None$.MODULE$;
                            }
                            Option is = option;
                            is.foreach((Function1<InputStream, Object> & Serializable)x$3 -> {
                                Using$.MODULE$.resource(x$3, (Function1<InputStream, Object> & Serializable)is -> {
                                    StreamSupport$.MODULE$.stream(is, digestOut$1);
                                    return BoxedUnit.UNIT;
                                }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
                                return BoxedUnit.UNIT;
                            });
                            boxedUnit = BoxedUnit.UNIT;
                            break block9;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (NoSuchFileException e) {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                return;
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    private PathRef$() {
    }
}

