/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 14170 $ of $
 *
 * $Id:$
 */
/* standard Net-SNMP includes */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

#include <linux/if_link.h>

/* include our parent header */
#include "sessionTable.h"


#include "sessionTable_data_access.h"

#include "ppp.h"
#include "ipdb.h"
#include "memdebug.h"

/** @ingroup interface
 * @addtogroup data_access data_access: Routines to access data
 *
 * These routines are used to locate the data used to satisfy
 * requests.
 *
 * @{
 */
/**********************************************************************
 **********************************************************************
 ***
 *** Table sessionTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * ACCEL-PPP-MIB::sessionTable is subid 1 of accelPPPSessions.
 * Its status is Current.
 * OID: .1.3.6.1.4.1.8072.100.2.1, length: 10
*/

/**
 * initialization for sessionTable data access
 *
 * This function is called during startup to allow you to
 * allocate any resources you need for the data table.
 *
 * @param sessionTable_reg
 *        Pointer to sessionTable_registration
 *
 * @retval MFD_SUCCESS : success.
 * @retval MFD_ERROR   : unrecoverable error.
 */
int
sessionTable_init_data(sessionTable_registration * sessionTable_reg)
{
    DEBUGMSGTL(("verbose:sessionTable:sessionTable_init_data","called\n"));

    /*
     * TODO:303:o: Initialize sessionTable data->
     */
    /*
    ***************************************************
    ***             START EXAMPLE CODE              ***
    ***---------------------------------------------***/
    /*
     * if you are the sole writer for the file, you could
     * open it here. However, as stated earlier, we are assuming
     * the worst case, which in this case means that the file is
     * written to by someone else, and might not even exist when
     * we start up. So we can't do anything here.
     */
    /*
    ***---------------------------------------------***
    ***              END  EXAMPLE CODE              ***
    ***************************************************/

    return MFD_SUCCESS;
} /* sessionTable_init_data */

/**
 * container overview
 *
 */

/**
 * container initialization
 *
 * @param container_ptr_ptr A pointer to a container pointer. If you
 *        create a custom container, use this parameter to return it
 *        to the MFD helper. If set to NULL, the MFD helper will
 *        allocate a container for you.
 *
 *  This function is called at startup to allow you to customize certain
 *  aspects of the access method. For the most part, it is for advanced
 *  users. The default code should suffice for most cases. If no custom
 *  container is allocated, the MFD code will create one for your.
 *
 * @remark
 *  This would also be a good place to do any initialization needed
 *  for you data source. For example, opening a connection to another
 *  process that will supply the data, opening a database, etc.
 */
void
sessionTable_container_init(netsnmp_container **container_ptr_ptr,
                             netsnmp_cache *cache)
{
    DEBUGMSGTL(("verbose:sessionTable:sessionTable_container_init","called\n"));

    if (NULL == container_ptr_ptr) {
        snmp_log(LOG_ERR,"bad container param to sessionTable_container_init\n");
        return;
    }

    /*
     * For advanced users, you can use a custom container. If you
     * do not create one, one will be created for you.
     */
    *container_ptr_ptr = NULL;

    if (NULL == cache) {
        snmp_log(LOG_ERR,"bad cache param to sessionTable_container_init\n");
        return;
    }

    /*
     * TODO:345:A: Set up sessionTable cache properties.
     *
     * Also for advanced users, you can set parameters for the
     * cache. Do not change the magic pointer, as it is used
     * by the MFD helper. To completely disable caching, set
     * cache->enabled to 0.
     */
    cache->timeout = -1; /* seconds */
} /* sessionTable_container_init */

/**
 * container shutdown
 *
 * @param container_ptr A pointer to the container.
 *
 *  This function is called at shutdown to allow you to customize certain
 *  aspects of the access method. For the most part, it is for advanced
 *  users. The default code should suffice for most cases.
 *
 *  This function is called before sessionTable_container_free().
 *
 * @remark
 *  This would also be a good place to do any cleanup needed
 *  for you data source. For example, closing a connection to another
 *  process that supplied the data, closing a database, etc.
 */
void
sessionTable_container_shutdown(netsnmp_container *container_ptr)
{
    DEBUGMSGTL(("verbose:sessionTable:sessionTable_container_shutdown","called\n"));

    if (NULL == container_ptr) {
        snmp_log(LOG_ERR,"bad params to sessionTable_container_shutdown\n");
        return;
    }

} /* sessionTable_container_shutdown */

/**
 * load initial data
 *
 * TODO:350:M: Implement sessionTable data load
 *
 * @param container container to which items should be inserted
 *
 * @retval MFD_SUCCESS              : success.
 * @retval MFD_RESOURCE_UNAVAILABLE : Can't access data source
 * @retval MFD_ERROR                : other error.
 *
 *  This function is called to load the index(es) (and data, optionally)
 *  for the every row in the data set.
 *
 * @remark
 *  While loading the data, the only important thing is the indexes.
 *  If access to your data is cheap/fast (e.g. you have a pointer to a
 *  structure in memory), it would make sense to update the data here.
 *  If, however, the accessing the data invovles more work (e.g. parsing
 *  some other existing data, or peforming calculations to derive the data),
 *  then you can limit yourself to setting the indexes and saving any
 *  information you will need later. Then use the saved information in
 *  sessionTable_row_prep() for populating data->
 *
 * @note
 *  If you need consistency between rows (like you want statistics
 *  for each row to be from the same time frame), you should set all
 *  data here.
 *
 */
int
sessionTable_container_load(netsnmp_container *container)
{
    sessionTable_rowreq_ctx *rowreq_ctx;
    size_t                 count = 0;
		struct ap_session *ses;
		struct rtnl_link_stats stats;

    DEBUGMSGTL(("verbose:sessionTable:sessionTable_container_load","called\n"));

		pthread_rwlock_rdlock(&ses_lock);
		list_for_each_entry(ses, &ses_list, entry) {
        rowreq_ctx = sessionTable_allocate_rowreq_ctx(NULL, NULL);
        if (NULL == rowreq_ctx) {
						pthread_rwlock_unlock(&ses_lock);
            snmp_log(LOG_ERR, "memory allocation failed\n");
            return MFD_RESOURCE_UNAVAILABLE;
        }
        if(MFD_SUCCESS != sessionTable_indexes_set(rowreq_ctx
                               , ses->sessionid, AP_SESSIONID_LEN
               )) {
            snmp_log(LOG_ERR,"error setting index while loading "
                     "sessionTable data->\n");
            sessionTable_release_rowreq_ctx(rowreq_ctx);
            continue;
        }

				strcpy(rowreq_ctx->data->ifname, ses->ifname);

				if (ses->username)
					rowreq_ctx->data->username = _strdup(ses->username);
				else
					rowreq_ctx->data->username = _strdup("");

				rowreq_ctx->data->peer_addr = ses->ipv4 ? ses->ipv4->peer_addr : 0;
				rowreq_ctx->data->type = ses->ctrl->type;
				rowreq_ctx->data->state = ses->state;
				rowreq_ctx->data->uptime = (ses->stop_time ? ses->stop_time : _time()) - ses->start_time;
				rowreq_ctx->data->calling_sid = _strdup(ses->ctrl->calling_station_id);
				rowreq_ctx->data->called_sid = _strdup(ses->ctrl->called_station_id);

				net = ses->net;
				ap_session_read_stats(ses, &stats);
				rowreq_ctx->data->rx_pkts = stats.rx_packets;
				rowreq_ctx->data->rx_bytes = stats.rx_bytes;
				rowreq_ctx->data->rx_gw = ses->acct_input_gigawords;
				rowreq_ctx->data->tx_pkts = stats.tx_packets;
				rowreq_ctx->data->tx_bytes = stats.tx_bytes;
				rowreq_ctx->data->tx_gw = ses->acct_output_gigawords;


        CONTAINER_INSERT(container, rowreq_ctx);
        ++count;
    }
		pthread_rwlock_unlock(&ses_lock);

    DEBUGMSGT(("verbose:sessionTable:sessionTable_container_load",
               "inserted %d records\n", (int)count));

    return MFD_SUCCESS;
} /* sessionTable_container_load */

/**
 * container clean up
 *
 * @param container container with all current items
 *
 *  This optional callback is called prior to all
 *  item's being removed from the container. If you
 *  need to do any processing before that, do it here.
 *
 * @note
 *  The MFD helper will take care of releasing all the row contexts.
 *  If you did not pass a data context pointer when allocating
 *  the rowreq context, the one that was allocated will be deleted.
 *  If you did pass one in, it will not be deleted and that memory
 *  is your responsibility.
 *
 */
void
sessionTable_container_free(netsnmp_container *container)
{
    DEBUGMSGTL(("verbose:sessionTable:sessionTable_container_free","called\n"));

    /*
     * TODO:380:M: Free sessionTable container data->
     */
} /* sessionTable_container_free */

/**
 * prepare row for processing.
 *
 *  When the agent has located the row for a request, this function is
 *  called to prepare the row for processing. If you fully populated
 *  the data context during the index setup phase, you may not need to
 *  do anything.
 *
 * @param rowreq_ctx pointer to a context.
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 */
int
sessionTable_row_prep( sessionTable_rowreq_ctx *rowreq_ctx)
{
    DEBUGMSGTL(("verbose:sessionTable:sessionTable_row_prep","called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:390:o: Prepare row for request.
     * If populating row data was delayed, this is the place to
     * fill in the row for this request.
     */

    return MFD_SUCCESS;
} /* sessionTable_row_prep */

/** @} */
