// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewCreatePeeringConnectionsParams creates a new CreatePeeringConnectionsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreatePeeringConnectionsParams() *CreatePeeringConnectionsParams {
	return &CreatePeeringConnectionsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreatePeeringConnectionsParamsWithTimeout creates a new CreatePeeringConnectionsParams object
// with the ability to set a timeout on a request.
func NewCreatePeeringConnectionsParamsWithTimeout(timeout time.Duration) *CreatePeeringConnectionsParams {
	return &CreatePeeringConnectionsParams{
		timeout: timeout,
	}
}

// NewCreatePeeringConnectionsParamsWithContext creates a new CreatePeeringConnectionsParams object
// with the ability to set a context for a request.
func NewCreatePeeringConnectionsParamsWithContext(ctx context.Context) *CreatePeeringConnectionsParams {
	return &CreatePeeringConnectionsParams{
		Context: ctx,
	}
}

// NewCreatePeeringConnectionsParamsWithHTTPClient creates a new CreatePeeringConnectionsParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreatePeeringConnectionsParamsWithHTTPClient(client *http.Client) *CreatePeeringConnectionsParams {
	return &CreatePeeringConnectionsParams{
		HTTPClient: client,
	}
}

/*
CreatePeeringConnectionsParams contains all the parameters to send to the API endpoint

	for the create peering connections operation.

	Typically these are written to a http.Request.
*/
type CreatePeeringConnectionsParams struct {

	// Body.
	Body CreatePeeringConnectionsBody

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create peering connections params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreatePeeringConnectionsParams) WithDefaults() *CreatePeeringConnectionsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create peering connections params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreatePeeringConnectionsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create peering connections params
func (o *CreatePeeringConnectionsParams) WithTimeout(timeout time.Duration) *CreatePeeringConnectionsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create peering connections params
func (o *CreatePeeringConnectionsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create peering connections params
func (o *CreatePeeringConnectionsParams) WithContext(ctx context.Context) *CreatePeeringConnectionsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create peering connections params
func (o *CreatePeeringConnectionsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create peering connections params
func (o *CreatePeeringConnectionsParams) WithHTTPClient(client *http.Client) *CreatePeeringConnectionsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create peering connections params
func (o *CreatePeeringConnectionsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the create peering connections params
func (o *CreatePeeringConnectionsParams) WithBody(body CreatePeeringConnectionsBody) *CreatePeeringConnectionsParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create peering connections params
func (o *CreatePeeringConnectionsParams) SetBody(body CreatePeeringConnectionsBody) {
	o.Body = body
}

// WithLocationOrganizationID adds the locationOrganizationID to the create peering connections params
func (o *CreatePeeringConnectionsParams) WithLocationOrganizationID(locationOrganizationID string) *CreatePeeringConnectionsParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the create peering connections params
func (o *CreatePeeringConnectionsParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the create peering connections params
func (o *CreatePeeringConnectionsParams) WithLocationProjectID(locationProjectID string) *CreatePeeringConnectionsParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the create peering connections params
func (o *CreatePeeringConnectionsParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *CreatePeeringConnectionsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if err := r.SetBodyParam(o.Body); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
