/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Aexion's Quadray Sets from FractalForums
 * @reference http://www.fractalforums.com/the-3d-mandelbulb/quadray-sets/msg31458/#msg31458

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_aexion4d_v2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 Aexion4dV2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 temp = z;
	REAL t;
	if (aux->i == 0)
	{
		t = fractal->aexion.cadd;
		REAL4 cadd = (REAL4){t, t, t, t};
		temp = (REAL4){z.x + z.y + z.z, -z.x - z.y + z.z, -z.x + z.y - z.z, z.x - z.y - z.z};
		temp = fabs(temp) + cadd + fractal->transformCommon.offsetA0000;
		if (fractal->transformCommon.functionEnabledFalse) temp = fabs(temp);
		aux->const_c = temp * fractal->transformCommon.scale1111;
		t = length(temp);
		if (!fractal->transformCommon.functionEnabledAFalse)
			z = (REAL4){0.0f, 0.0f, 0.0f, 0.0f};
		else
		{
			z = temp;
			aux->DE *= t / aux->r * fractal->analyticDE.scale1;
		}
		aux->r = t;
	}
	aux->DE = aux->DE * 2.0f * aux->r + 1.0f;
	t = 2.0f * z.w * z.z;
	temp.x = z.x * z.x - z.y * z.y;
	temp.y = t - temp.x;
	temp.x += t;
	t = 2.0f * z.x * z.y;
	temp.z = z.z * z.z - z.w * z.w;
	temp.w = t - temp.z;
	temp.z += t;

	z *= fractal->transformCommon.scale1;
	aux->DE = aux->DE * fractal->transformCommon.scale1 + fractal->analyticDE.offset0;

	z = temp + aux->const_c;
	return z;
}