/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Sierpinski3D. made from DarkBeam's Sierpinski code from M3D
 * @reference
 * http://www.fractalforums.com/mandelbulb-3d/custom-formulas-and-transforms-release-t17106/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_sierpinski3d_v2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 Sierpinski3dV2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (fractal->transformCommon.functionEnabledTFalse
			&& aux->i >= fractal->transformCommon.startIterationsT
			&& aux->i < fractal->transformCommon.stopIterationsT1)
	{
		z += fractal->transformCommon.offset000;
		z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix2, z);
	}
	if (fractal->transformCommon.functionEnabledPFalse)
	{
		// abs z
		if (fractal->transformCommon.functionEnabledAx
				&& aux->i >= fractal->transformCommon.startIterationsC
				&& aux->i < fractal->transformCommon.stopIterationsC1)
			z.x = fabs(z.x + fractal->transformCommon.offsetA000.x);

		if (fractal->transformCommon.functionEnabledAy
				&& aux->i >= fractal->transformCommon.startIterationsD
				&& aux->i < fractal->transformCommon.stopIterationsD1)
			z.y = fabs(z.y + fractal->transformCommon.offsetA000.y);

		if (fractal->transformCommon.functionEnabledAz
				&& aux->i >= fractal->transformCommon.startIterationsP
				&& aux->i < fractal->transformCommon.stopIterationsP1)
			z.z = fabs(z.z + fractal->transformCommon.offsetA000.z);
	}

	REAL4 va = (REAL4){0.0f, 0.0f, SQRT_1_3_F, 0.0f};
	REAL4 vb = (REAL4){0.0f, -2.0f * SQRT_1_3_F, -1.0f, 0.0f};
	REAL4 vc = (REAL4){-1.0f, SQRT_1_3_F, -1.0f, 0.0f};
	REAL4 vd = (REAL4){1.0f, SQRT_1_3_F, -1.0f, 0.0f};
	if (fractal->transformCommon.functionEnabledDFalse)
	{
		va *= fractal->transformCommon.scale1111.x;
		vb *= fractal->transformCommon.scale1111.y;
		vc *= fractal->transformCommon.scale1111.z;
		vd *= fractal->transformCommon.scale1111.w;
	}
	REAL4 tv = z - va;
	REAL d = dot(tv, tv);
	REAL4 v = va;
	REAL td = d;

	tv = z - vb;
	d = dot(tv, tv);
	if (d < td)
	{
		v = vb;
		td = d;
	}
	tv = z - vc;
	d = dot(tv, tv);
	if (d < td)
	{
		v = vc;
		td = d;
	}
	tv = z - vd;
	d = dot(tv, tv);
	if (d < td)
	{
		v = vd;
	}
	z = v + fractal->transformCommon.scale2 * (z - v);
	aux->DE *= fabs(fractal->transformCommon.scale2);

	// spherical inv
	if (fractal->transformCommon.functionEnabledSFalse
			&& aux->i >= fractal->transformCommon.startIterationsS
			&& aux->i < fractal->transformCommon.stopIterationsS)
	{
		REAL m = 1.0f;
		REAL rr = dot(z, z);
		if (rr < fractal->transformCommon.invert0)
			m = fractal->transformCommon.inv0;
		else if (rr < fractal->transformCommon.invert1)
			m = 1.0f / rr;
		else
			m = fractal->transformCommon.inv1;
		z *= m;
		aux->DE *= m;
	}

	// rotation
	if (fractal->transformCommon.functionEnabledRFalse
			&& aux->i >= fractal->transformCommon.startIterationsR
			&& aux->i < fractal->transformCommon.stopIterationsR)
	{
		z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, z);
	}

	if (fractal->analyticDE.enabledFalse)
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
	return z;
}