/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2024 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * abs add conditional.

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_abs_add_conditional.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfAbsAddConditionalIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (fractal->transformCommon.functionEnabledx)
	{
		z.x = sign(z.x)
					* (fractal->transformCommon.offset111.x - fabs(z.x)
						 + fabs(z.x) * fractal->transformCommon.scale3D000.x);
	}

	if (fractal->transformCommon.functionEnabledy)
	{
		z.y = sign(z.y)
					* (fractal->transformCommon.offset111.y - fabs(z.y)
						 + fabs(z.y) * fractal->transformCommon.scale3D000.y);
	}

	if (fractal->transformCommon.functionEnabledz)
	{
		z.z = sign(z.z)
					* (fractal->transformCommon.offset111.z - fabs(z.z)
						 + fabs(z.z) * fractal->transformCommon.scale3D000.z);
	}

	aux->DE *= fractal->analyticDE.scale1; // DE tweak
	return z;
}