/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Based on a DarkBeam fold formula adapted by Knighty
 * refer
 http://www.fractalforums.com/amazing-box-amazing-surf-and-variations/'new'-fractal-type-mandalay/msg81348/#msg81348

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_mandalay_fold4d.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfMandalayFold4dIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	Q_UNUSED(aux);

	// darkbeam fold

	REAL signX = sign(z.x);
	REAL signY = sign(z.y);
	REAL signZ = sign(z.z);
	REAL signW = sign(z.w);
	z = fabs(z);

	REAL4 fo = fractal->transformCommon.offsetp5555;
	REAL4 g = fractal->transformCommon.offsetA0000;
	REAL4 p = z;
	REAL4 q = z;

	REAL t1, t2, v, v1;

	if (p.z > p.y)
	{
		REAL temp = p.y;
		p.y = p.z;
		p.z = temp;
	}

	t1 = p.x - 2.0f * fo.x;
	t2 = p.y - 4.0f * fo.x;
	v = max(fabs(t1 + fo.x) - fo.x, t2);
	v1 = max(t1 - g.x, p.y);
	v = min(v, v1);
	q.x = min(v, p.x);

	if (!fractal->transformCommon.functionEnabledSwFalse)
		p = z;
	else
		p = q;

	if (p.w > p.z)
	{
		REAL temp = p.z;
		p.z = p.w;
		p.w = temp;
	}

	t1 = p.y - 2.0f * fo.y;
	t2 = p.z - 4.0f * fo.y;
	v = max(fabs(t1 + fo.y) - fo.y, t2);
	v1 = max(t1 - g.y, p.z);
	v = min(v, v1);
	q.y = min(v, p.y);

	if (!fractal->transformCommon.functionEnabledSwFalse)
		p = z;
	else
		p = q;

	if (p.x > p.w)
	{
		REAL temp = p.w;
		p.w = p.x;
		p.x = temp;
	}

	t1 = p.z - 2.0f * fo.z;
	t2 = p.w - 4.0f * fo.z;
	v = max(fabs(t1 + fo.z) - fo.z, t2);
	v1 = max(t1 - g.z, p.w);
	v = min(v, v1);
	q.z = min(v, p.z);

	if (!fractal->transformCommon.functionEnabledSwFalse)
		p = z;
	else
		p = q;

	if (p.y > p.x)
	{
		REAL temp = p.x;
		p.x = p.y;
		p.y = temp;
	}

	t1 = p.w - 2.0f * fo.w;
	t2 = p.x - 4.0f * fo.w;
	v = max(fabs(t1 + fo.w) - fo.w, t2);
	v1 = max(t1 - g.w, p.x);
	v = min(v, v1);
	q.w = min(v, p.w);

	z = q;
	z.x *= signX;
	z.y *= signY;
	z.z *= signZ;
	z.w *= signW;
	return z;
}