/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2024 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Inverse spherical coords. Fast conversion without parameters.
 * Formula by Luca GN 2011, from M3D, from Wikipedia;
 * @reference
 * http://www.fractalforums.com/mandelbulb-3d/custom-formulas-and-transforms-release-t17106/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_spherical_coord_invs.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfSphericalCoordInvsIteration(
	REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	Q_UNUSED(aux);

	REAL4 t = z;
	REAL sn = 0.0f;
	if (fractal->transformCommon.functionEnabled) // M3D version
	{
		sn = z.x * native_sin(z.y);
		t.x = sn * native_cos(z.z);
		t.y = sn * native_sin(z.z);
		t.z = z.x * native_cos(z.y);
	}

	if (fractal->transformCommon.functionEnabledAFalse)
	{
		sn = z.z * native_sin(z.x);
		t.x = sn * native_sin(z.y);
		t.y = z.z * native_cos(z.x);
		t.z = sn * native_cos(z.y);
	}

	if (fractal->transformCommon.functionEnabledBFalse)
	{
		sn = z.y * native_sin(z.x);
		t.x = sn * native_sin(z.z);
		t.y = sn * native_cos(z.z);
		t.z = z.y * native_cos(z.x);
	}

	z = t + fractal->transformCommon.offset000;
	return z;
}