/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2024 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * spherical fold Parab, coded by mclarekin
 * @reference
 * http://www.fractalforums.com/amazing-box-amazing-surf-and-variations/smooth-spherical-fold/msg101051/#new
 * This formula contains aux.color and aux.actualScaleA

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_spherical_fold_parab.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfSphericalFoldParabIteration(
	REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL m = 1.0f;
	REAL rr;
	REAL colorAdd = 0.0f;
	// spherical fold
	if (fractal->transformCommon.functionEnabledSFalse
			&& aux->i >= fractal->transformCommon.startIterationsS
			&& aux->i < fractal->transformCommon.stopIterationsS)
	{
		rr = dot(z, z);
		REAL tempM = rr;
		m = fractal->transformCommon.maxMinR2factor;
		// if (r2 < 1e-21f) r2 = 1e-21f;
		if (rr < fractal->transformCommon.minR2p25)
		{
			if (fractal->transformCommon.functionEnabledAyFalse && m > tempM) m = tempM + (tempM - m);
			z *= m;
			aux->DE = aux->DE * m;
			colorAdd += fractal->mandelbox.color.factorSp1;
		}
		else if (rr < fractal->transformCommon.maxR2d1)
		{
			m = fractal->transformCommon.maxR2d1 / rr;
			if (fractal->transformCommon.functionEnabledAyFalse && m > tempM) m = tempM + (tempM - m);
			z *= m;
			aux->DE = aux->DE * m;
			colorAdd += fractal->mandelbox.color.factorSp2;
		}
	}
	if (aux->i >= fractal->transformCommon.startIterations
			&& aux->i < fractal->transformCommon.stopIterations)
	{
		rr = dot(z, z);
		z += fractal->mandelbox.offset;
		z *= fractal->transformCommon.scale;
		aux->DE = aux->DE * fabs(fractal->transformCommon.scale) + 1.0f;
		REAL maxScale = fractal->transformCommon.scale4;
		REAL midPoint = (maxScale - 1.0f) * 0.5f;
		rr += fractal->transformCommon.offset0;
		REAL maxR2 = fractal->transformCommon.scale1;
		REAL halfMax = maxR2 * 0.5f;
		REAL factor = midPoint / (halfMax * halfMax);

		REAL tempM = rr + fractal->transformCommon.offsetA0;
		if (rr < halfMax)
		{
			if (!fractal->transformCommon.functionEnabledOFalse)
				m = maxScale - (rr * rr) * factor;
			else
				m = 1.0f + (maxR2 - rr) * (maxR2 - rr) * factor;
			if (fractal->transformCommon.functionEnabledAxFalse && m > tempM) m = tempM + (tempM - m);
			z *= m;
			aux->DE = aux->DE * m;
			colorAdd += fractal->mandelbox.color.factorSp1;
		}
		else if (rr < maxR2)
		{
			m = 1.0f + (maxR2 - rr) * (maxR2 - rr) * factor;
			if (fractal->transformCommon.functionEnabledAxFalse && m > tempM) m = tempM + (tempM - m);
			z *= m;
			aux->DE = aux->DE * m;
			colorAdd += fractal->mandelbox.color.factorSp2;

			// z -= fractal->mandelbox.offset; //  fixed v2.32
		}
		z -= fractal->mandelbox.offset;
	}

	REAL useScale = fractal->transformCommon.scaleA1;
	if (fractal->transformCommon.functionEnabledXFalse)
	{
		if (aux->i >= fractal->transformCommon.startIterationsA
				&& aux->i < fractal->transformCommon.stopIterationsA)
		{
			useScale += aux->actualScaleA;
			z *= useScale;

			aux->DE = aux->DE * fabs(useScale) * fractal->analyticDE.scale1 + fractal->analyticDE.offset1;

			// update actualScale for next iteration
			REAL vary = fractal->transformCommon.scaleVary0
									* (fabs(aux->actualScaleA) - fractal->transformCommon.scaleB1);
			if (fractal->transformCommon.functionEnabledMFalse)
				aux->actualScaleA = -vary;
			else
				aux->actualScaleA = aux->actualScaleA - vary;
		}
		else
		{
			if (!fractal->transformCommon.functionEnabledYFalse)
			{
				z *= useScale;
				aux->DE =
					aux->DE * fabs(useScale) * fractal->analyticDE.scale1 + fractal->analyticDE.offset1;
			}
		}
	}
	else
	{
		z *= useScale;
		aux->DE = aux->DE * fabs(useScale) * fractal->analyticDE.scale1 + fractal->analyticDE.offset1;
	}

	if (fractal->foldColor.auxColorEnabledFalse && aux->i >= fractal->foldColor.startIterationsA
			&& aux->i < fractal->foldColor.stopIterationsA)
	{
		colorAdd += fractal->foldColor.difs0000.x * m;
		aux->color += colorAdd;
	}
	return z;
}