/*
// @HEADER
//
// ***********************************************************************
//
//      Teko: A package for block and physics based preconditioning
//                  Copyright 2010 Sandia Corporation
//
// Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
// the U.S. Government retains certain rights in this software.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions? Contact Eric C. Cyr (eccyr@sandia.gov)
//
// ***********************************************************************
//
// @HEADER

*/

#ifndef __tLSCIntegrationTest_tpetra_hpp__
#define __tLSCIntegrationTest_tpetra_hpp__

// Teuchos includes
#include "Teuchos_RCP.hpp"

// Tpetra includes
#include "Tpetra_Map.hpp"
#include "Tpetra_CrsMatrix.hpp"
#include "Tpetra_Vector.hpp"

#include <string>

#include "Test_Utils.hpp"
#include "Teko_Utilities.hpp"

namespace Teko {
namespace Test {

class tLSCIntegrationTest_tpetra : public UnitTest {
 public:
  virtual ~tLSCIntegrationTest_tpetra() {}

  virtual void initializeTest();
  virtual int runTest(int verbosity, std::ostream& stdstrm, std::ostream& failstrm, int& totalrun);
  virtual bool isParallel() const { return true; }

  bool test_withmassStable(int verbosity, std::ostream& os);
  bool test_nomassStable(int verbosity, std::ostream& os);
  bool test_plConstruction(int verbosity, std::ostream& os);

 protected:
  void loadStableSystem();
  void solveList(Teuchos::ParameterList& paramList, int vcycles);

  double tolerance_;

  Teuchos::RCP<const Tpetra::Map<LO, GO, NT> > velMap_;   // map of velocity space
  Teuchos::RCP<const Tpetra::Map<LO, GO, NT> > prsMap_;   // map of pressure space
  Teuchos::RCP<const Tpetra::Map<LO, GO, NT> > fullMap_;  // map of pressure space

  // stable discretizations matrices
  Teuchos::RCP<const Tpetra::CrsMatrix<ST, LO, GO, NT> > sF_;
  Teuchos::RCP<const Tpetra::CrsMatrix<ST, LO, GO, NT> > sB_;
  Teuchos::RCP<const Tpetra::CrsMatrix<ST, LO, GO, NT> > sBt_;
  Teuchos::RCP<const Tpetra::CrsMatrix<ST, LO, GO, NT> > sQu_;
  Teuchos::RCP<Tpetra::Operator<ST, LO, GO, NT> > sA_;

  // stable rhs and IFISS solution
  Teuchos::RCP<Tpetra::Vector<ST, LO, GO, NT> > rhs_;
  Teuchos::RCP<const Tpetra::Vector<ST, LO, GO, NT> > sExact_;
};

}  // namespace Test
}  // end namespace Teko

#endif
