package security

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// IotAlertsClient is the API spec for Microsoft.Security (Azure Security Center) resource provider
type IotAlertsClient struct {
	BaseClient
}

// NewIotAlertsClient creates an instance of the IotAlertsClient client.
func NewIotAlertsClient(subscriptionID string, ascLocation string) IotAlertsClient {
	return NewIotAlertsClientWithBaseURI(DefaultBaseURI, subscriptionID, ascLocation)
}

// NewIotAlertsClientWithBaseURI creates an instance of the IotAlertsClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewIotAlertsClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) IotAlertsClient {
	return IotAlertsClient{NewWithBaseURI(baseURI, subscriptionID, ascLocation)}
}

// Get get IoT alert
// Parameters:
// scope - scope of the query: Subscription (i.e. /subscriptions/{subscriptionId}) or IoT Hub (i.e.
// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Devices/iotHubs/{iotHubName})
// iotAlertID - id of the alert
func (client IotAlertsClient) Get(ctx context.Context, scope string, iotAlertID string) (result IotAlertModel, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotAlertsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, scope, iotAlertID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotAlertsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.IotAlertsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotAlertsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client IotAlertsClient) GetPreparer(ctx context.Context, scope string, iotAlertID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"iotAlertId": autorest.Encode("path", iotAlertID),
		"scope":      scope,
	}

	const APIVersion = "2020-08-06-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Security/iotAlerts/{iotAlertId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client IotAlertsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client IotAlertsClient) GetResponder(resp *http.Response) (result IotAlertModel, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List list IoT alerts
// Parameters:
// scope - scope of the query: Subscription (i.e. /subscriptions/{subscriptionId}) or IoT Hub (i.e.
// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Devices/iotHubs/{iotHubName})
// minStartTimeUtc - filter by minimum startTimeUtc (ISO 8601 format)
// maxStartTimeUtc - filter by maximum startTimeUtc (ISO 8601 format)
// alertType - filter by alert type
// deviceManagementType - get devices only from specific type, Managed or Unmanaged.
// compromisedEntity - filter by compromised device
// limit - limit the number of items returned in a single page
// skipToken - skip token used for pagination
func (client IotAlertsClient) List(ctx context.Context, scope string, minStartTimeUtc string, maxStartTimeUtc string, alertType string, deviceManagementType ManagementState, compromisedEntity string, limit *int32, skipToken string) (result IotAlertListModelPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotAlertsClient.List")
		defer func() {
			sc := -1
			if result.ialm.Response.Response != nil {
				sc = result.ialm.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, scope, minStartTimeUtc, maxStartTimeUtc, alertType, deviceManagementType, compromisedEntity, limit, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotAlertsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.ialm.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.IotAlertsClient", "List", resp, "Failure sending request")
		return
	}

	result.ialm, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotAlertsClient", "List", resp, "Failure responding to request")
		return
	}
	if result.ialm.hasNextLink() && result.ialm.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client IotAlertsClient) ListPreparer(ctx context.Context, scope string, minStartTimeUtc string, maxStartTimeUtc string, alertType string, deviceManagementType ManagementState, compromisedEntity string, limit *int32, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"scope": scope,
	}

	const APIVersion = "2020-08-06-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(minStartTimeUtc) > 0 {
		queryParameters["startTimeUtc>"] = autorest.Encode("query", minStartTimeUtc)
	}
	if len(maxStartTimeUtc) > 0 {
		queryParameters["startTimeUtc<"] = autorest.Encode("query", maxStartTimeUtc)
	}
	if len(alertType) > 0 {
		queryParameters["alertType"] = autorest.Encode("query", alertType)
	}
	if len(string(deviceManagementType)) > 0 {
		queryParameters["deviceManagementType"] = autorest.Encode("query", deviceManagementType)
	}
	if len(compromisedEntity) > 0 {
		queryParameters["compromisedEntity"] = autorest.Encode("query", compromisedEntity)
	}
	if limit != nil {
		queryParameters["$limit"] = autorest.Encode("query", *limit)
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Security/iotAlerts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client IotAlertsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client IotAlertsClient) ListResponder(resp *http.Response) (result IotAlertListModel, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client IotAlertsClient) listNextResults(ctx context.Context, lastResults IotAlertListModel) (result IotAlertListModel, err error) {
	req, err := lastResults.iotAlertListModelPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "security.IotAlertsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "security.IotAlertsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotAlertsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client IotAlertsClient) ListComplete(ctx context.Context, scope string, minStartTimeUtc string, maxStartTimeUtc string, alertType string, deviceManagementType ManagementState, compromisedEntity string, limit *int32, skipToken string) (result IotAlertListModelIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotAlertsClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, scope, minStartTimeUtc, maxStartTimeUtc, alertType, deviceManagementType, compromisedEntity, limit, skipToken)
	return
}
