package accesscontrolapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/synapse/2020-02-01-preview/accesscontrol"
	"github.com/Azure/go-autorest/autorest"
)

// BaseClientAPI contains the set of methods on the BaseClient type.
type BaseClientAPI interface {
	CreateRoleAssignment(ctx context.Context, createRoleAssignmentOptions accesscontrol.RoleAssignmentOptions) (result accesscontrol.RoleAssignmentDetails, err error)
	DeleteRoleAssignmentByID(ctx context.Context, roleAssignmentID string) (result autorest.Response, err error)
	GetCallerRoleAssignments(ctx context.Context) (result accesscontrol.ListString, err error)
	GetRoleAssignmentByID(ctx context.Context, roleAssignmentID string) (result accesscontrol.RoleAssignmentDetails, err error)
	GetRoleAssignments(ctx context.Context, roleID string, principalID string, continuationToken string) (result accesscontrol.ListRoleAssignmentDetails, err error)
	GetRoleDefinitionByID(ctx context.Context, roleID string) (result accesscontrol.SynapseRole, err error)
	GetRoleDefinitions(ctx context.Context) (result accesscontrol.RolesListResponsePage, err error)
	GetRoleDefinitionsComplete(ctx context.Context) (result accesscontrol.RolesListResponseIterator, err error)
}

var _ BaseClientAPI = (*accesscontrol.BaseClient)(nil)
