package recoveryservices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/recoveryservices/mgmt/2016-06-01/recoveryservices"

// CertificateRequest details of the certificate to be uploaded to the vault.
type CertificateRequest struct {
	Properties *RawCertificateData `json:"properties,omitempty"`
}

// CheckNameAvailabilityParameters resource Name availability input parameters - Resource type and resource
// name
type CheckNameAvailabilityParameters struct {
	// Type - Describes the Resource type: Microsoft.RecoveryServices/Vaults
	Type *string `json:"type,omitempty"`
	// Name - Resource name for which availability needs to be checked
	Name *string `json:"name,omitempty"`
}

// CheckNameAvailabilityResult response for check name availability API. Resource provider will set
// availability as true | false.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	NameAvailable     *bool   `json:"nameAvailable,omitempty"`
	Reason            *string `json:"reason,omitempty"`
	Message           *string `json:"message,omitempty"`
}

// ClientDiscoveryDisplay localized display information of an operation.
type ClientDiscoveryDisplay struct {
	// Provider - Name of the provider for display purposes
	Provider *string `json:"provider,omitempty"`
	// Resource - ResourceType for which this Operation can be performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operations Name itself.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation having details of what operation is about.
	Description *string `json:"description,omitempty"`
}

// ClientDiscoveryForLogSpecification class to represent shoebox log specification in json client
// discovery.
type ClientDiscoveryForLogSpecification struct {
	// Name - Name of the log.
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized display name
	DisplayName *string `json:"displayName,omitempty"`
	// BlobDuration - Blobs created in customer storage account per hour
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// ClientDiscoveryForProperties class to represent shoebox properties in json client discovery.
type ClientDiscoveryForProperties struct {
	// ServiceSpecification - Operation properties.
	ServiceSpecification *ClientDiscoveryForServiceSpecification `json:"serviceSpecification,omitempty"`
}

// ClientDiscoveryForServiceSpecification class to represent shoebox service specification in json client
// discovery.
type ClientDiscoveryForServiceSpecification struct {
	// LogSpecifications - List of log specifications of this operation.
	LogSpecifications *[]ClientDiscoveryForLogSpecification `json:"logSpecifications,omitempty"`
}

// ClientDiscoveryResponse operations List response which contains list of available APIs.
type ClientDiscoveryResponse struct {
	autorest.Response `json:"-"`
	// Value - List of available operations.
	Value *[]ClientDiscoveryValueForSingleAPI `json:"value,omitempty"`
	// NextLink - Link to the next chunk of the response
	NextLink *string `json:"nextLink,omitempty"`
}

// ClientDiscoveryResponseIterator provides access to a complete listing of
// ClientDiscoveryValueForSingleAPI values.
type ClientDiscoveryResponseIterator struct {
	i    int
	page ClientDiscoveryResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClientDiscoveryResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClientDiscoveryResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClientDiscoveryResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClientDiscoveryResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClientDiscoveryResponseIterator) Response() ClientDiscoveryResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClientDiscoveryResponseIterator) Value() ClientDiscoveryValueForSingleAPI {
	if !iter.page.NotDone() {
		return ClientDiscoveryValueForSingleAPI{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClientDiscoveryResponseIterator type.
func NewClientDiscoveryResponseIterator(page ClientDiscoveryResponsePage) ClientDiscoveryResponseIterator {
	return ClientDiscoveryResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cdr ClientDiscoveryResponse) IsEmpty() bool {
	return cdr.Value == nil || len(*cdr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cdr ClientDiscoveryResponse) hasNextLink() bool {
	return cdr.NextLink != nil && len(*cdr.NextLink) != 0
}

// clientDiscoveryResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cdr ClientDiscoveryResponse) clientDiscoveryResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !cdr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cdr.NextLink)))
}

// ClientDiscoveryResponsePage contains a page of ClientDiscoveryValueForSingleAPI values.
type ClientDiscoveryResponsePage struct {
	fn  func(context.Context, ClientDiscoveryResponse) (ClientDiscoveryResponse, error)
	cdr ClientDiscoveryResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClientDiscoveryResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClientDiscoveryResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cdr)
		if err != nil {
			return err
		}
		page.cdr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClientDiscoveryResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClientDiscoveryResponsePage) NotDone() bool {
	return !page.cdr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClientDiscoveryResponsePage) Response() ClientDiscoveryResponse {
	return page.cdr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClientDiscoveryResponsePage) Values() []ClientDiscoveryValueForSingleAPI {
	if page.cdr.IsEmpty() {
		return nil
	}
	return *page.cdr.Value
}

// Creates a new instance of the ClientDiscoveryResponsePage type.
func NewClientDiscoveryResponsePage(cur ClientDiscoveryResponse, getNextPage func(context.Context, ClientDiscoveryResponse) (ClientDiscoveryResponse, error)) ClientDiscoveryResponsePage {
	return ClientDiscoveryResponsePage{
		fn:  getNextPage,
		cdr: cur,
	}
}

// ClientDiscoveryValueForSingleAPI available operation details.
type ClientDiscoveryValueForSingleAPI struct {
	// Name - Name of the Operation.
	Name *string `json:"name,omitempty"`
	// Display - Contains the localized display information for this particular operation
	Display *ClientDiscoveryDisplay `json:"display,omitempty"`
	// Origin - The intended executor of the operation;governs the display of the operation in the RBAC UX and the audit logs UX
	Origin *string `json:"origin,omitempty"`
	// Properties - ShoeBox properties for the given operation.
	Properties *ClientDiscoveryForProperties `json:"properties,omitempty"`
}

// IdentityData identity for the resource.
type IdentityData struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'SystemAssigned', 'None'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IdentityData.
func (ID IdentityData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ID.Type != "" {
		objectMap["type"] = ID.Type
	}
	return json.Marshal(objectMap)
}

// JobsSummary summary of the replication job data for this vault.
type JobsSummary struct {
	// FailedJobs - Count of failed jobs.
	FailedJobs *int32 `json:"failedJobs,omitempty"`
	// SuspendedJobs - Count of suspended jobs.
	SuspendedJobs *int32 `json:"suspendedJobs,omitempty"`
	// InProgressJobs - Count of in-progress jobs.
	InProgressJobs *int32 `json:"inProgressJobs,omitempty"`
}

// MonitoringSummary summary of the replication monitoring data for this vault.
type MonitoringSummary struct {
	// UnHealthyVMCount - Count of unhealthy VMs.
	UnHealthyVMCount *int32 `json:"unHealthyVmCount,omitempty"`
	// UnHealthyProviderCount - Count of unhealthy replication providers.
	UnHealthyProviderCount *int32 `json:"unHealthyProviderCount,omitempty"`
	// EventsCount - Count of all critical warnings.
	EventsCount *int32 `json:"eventsCount,omitempty"`
	// DeprecatedProviderCount - Count of all deprecated recovery service providers.
	DeprecatedProviderCount *int32 `json:"deprecatedProviderCount,omitempty"`
	// SupportedProviderCount - Count of all the supported recovery service providers.
	SupportedProviderCount *int32 `json:"supportedProviderCount,omitempty"`
	// UnsupportedProviderCount - Count of all the unsupported recovery service providers.
	UnsupportedProviderCount *int32 `json:"unsupportedProviderCount,omitempty"`
}

// NameInfo the name of usage.
type NameInfo struct {
	// Value - Value of usage.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - Localized value of usage.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// PatchTrackedResource tracked resource with location.
type PatchTrackedResource struct {
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for PatchTrackedResource.
func (ptr PatchTrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ptr.Location != nil {
		objectMap["location"] = ptr.Location
	}
	if ptr.Tags != nil {
		objectMap["tags"] = ptr.Tags
	}
	if ptr.ETag != nil {
		objectMap["eTag"] = ptr.ETag
	}
	return json.Marshal(objectMap)
}

// PatchVault patch Resource information, as returned by the resource provider.
type PatchVault struct {
	Properties *VaultProperties `json:"properties,omitempty"`
	Sku        *Sku             `json:"sku,omitempty"`
	Identity   *IdentityData    `json:"identity,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for PatchVault.
func (pv PatchVault) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pv.Properties != nil {
		objectMap["properties"] = pv.Properties
	}
	if pv.Sku != nil {
		objectMap["sku"] = pv.Sku
	}
	if pv.Identity != nil {
		objectMap["identity"] = pv.Identity
	}
	if pv.Location != nil {
		objectMap["location"] = pv.Location
	}
	if pv.Tags != nil {
		objectMap["tags"] = pv.Tags
	}
	if pv.ETag != nil {
		objectMap["eTag"] = pv.ETag
	}
	return json.Marshal(objectMap)
}

// PrivateEndpoint the Private Endpoint network resource that is linked to the Private Endpoint connection.
type PrivateEndpoint struct {
	// ID - READ-ONLY; Gets or sets id.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection private Endpoint Connection Response Properties.
type PrivateEndpointConnection struct {
	// ProvisioningState - READ-ONLY; Gets or sets provisioning state of the private endpoint connection. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateDeleting', 'ProvisioningStateFailed', 'ProvisioningStatePending'
	ProvisioningState                 ProvisioningState                  `json:"provisioningState,omitempty"`
	PrivateEndpoint                   *PrivateEndpoint                   `json:"privateEndpoint,omitempty"`
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpoint != nil {
		objectMap["privateEndpoint"] = pec.PrivateEndpoint
	}
	if pec.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = pec.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionVaultProperties information to be stored in Vault properties as an element of
// privateEndpointConnections List.
type PrivateEndpointConnectionVaultProperties struct {
	// ID - READ-ONLY; Format of id subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.[Service]/{resource}/{resourceName}/privateEndpointConnections/{connectionName}.
	ID         *string                    `json:"id,omitempty"`
	Properties *PrivateEndpointConnection `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionVaultProperties.
func (pecvp PrivateEndpointConnectionVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pecvp.Properties != nil {
		objectMap["properties"] = pecvp.Properties
	}
	return json.Marshal(objectMap)
}

// PrivateLinkResource information of the private link resource.
type PrivateLinkResource struct {
	autorest.Response `json:"-"`
	// PrivateLinkResourceProperties - Resource properties
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; e.g. Microsoft.RecoveryServices/vaults/privateLinkResources
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateLinkResourceProperties properties of the private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; e.g. f9ad6492-33d4-4690-9999-6bfd52a0d081 (Backup) or f9ad6492-33d4-4690-9999-6bfd52a0d082 (SiteRecovery)
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; [backup-ecs1, backup-prot1, backup-prot1b, backup-prot1c, backup-id1]
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - READ-ONLY; The private link resource Private link DNS zone name.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateLinkResources class which represent the stamps associated with the vault.
type PrivateLinkResources struct {
	autorest.Response `json:"-"`
	// Value - A collection of private link resources
	Value *[]PrivateLinkResource `json:"value,omitempty"`
	// NextLink - Link to the next chunk of the response
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateLinkResourcesIterator provides access to a complete listing of PrivateLinkResource values.
type PrivateLinkResourcesIterator struct {
	i    int
	page PrivateLinkResourcesPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateLinkResourcesIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourcesIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateLinkResourcesIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateLinkResourcesIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateLinkResourcesIterator) Response() PrivateLinkResources {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateLinkResourcesIterator) Value() PrivateLinkResource {
	if !iter.page.NotDone() {
		return PrivateLinkResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateLinkResourcesIterator type.
func NewPrivateLinkResourcesIterator(page PrivateLinkResourcesPage) PrivateLinkResourcesIterator {
	return PrivateLinkResourcesIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plr PrivateLinkResources) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plr PrivateLinkResources) hasNextLink() bool {
	return plr.NextLink != nil && len(*plr.NextLink) != 0
}

// privateLinkResourcesPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr PrivateLinkResources) privateLinkResourcesPreparer(ctx context.Context) (*http.Request, error) {
	if !plr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// PrivateLinkResourcesPage contains a page of PrivateLinkResource values.
type PrivateLinkResourcesPage struct {
	fn  func(context.Context, PrivateLinkResources) (PrivateLinkResources, error)
	plr PrivateLinkResources
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateLinkResourcesPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourcesPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plr)
		if err != nil {
			return err
		}
		page.plr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateLinkResourcesPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateLinkResourcesPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateLinkResourcesPage) Response() PrivateLinkResources {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateLinkResourcesPage) Values() []PrivateLinkResource {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// Creates a new instance of the PrivateLinkResourcesPage type.
func NewPrivateLinkResourcesPage(cur PrivateLinkResources, getNextPage func(context.Context, PrivateLinkResources) (PrivateLinkResources, error)) PrivateLinkResourcesPage {
	return PrivateLinkResourcesPage{
		fn:  getNextPage,
		plr: cur,
	}
}

// PrivateLinkServiceConnectionState gets or sets private link service connection state.
type PrivateLinkServiceConnectionState struct {
	// Status - READ-ONLY; Gets or sets the status. Possible values include: 'Pending', 'Approved', 'Rejected', 'Disconnected'
	Status PrivateEndpointConnectionStatus `json:"status,omitempty"`
	// Description - READ-ONLY; Gets or sets description.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - READ-ONLY; Gets or sets actions required.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkServiceConnectionState.
func (plscs PrivateLinkServiceConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RawCertificateData raw certificate data.
type RawCertificateData struct {
	// AuthType - Specifies the authentication type. Possible values include: 'Invalid', 'ACS', 'AAD', 'AccessControlService', 'AzureActiveDirectory'
	AuthType AuthType `json:"authType,omitempty"`
	// Certificate - The base64 encoded certificate raw data string
	Certificate *[]byte `json:"certificate,omitempty"`
}

// ReplicationUsage replication usages of a vault.
type ReplicationUsage struct {
	// MonitoringSummary - Summary of the replication monitoring data for this vault.
	MonitoringSummary *MonitoringSummary `json:"monitoringSummary,omitempty"`
	// JobsSummary - Summary of the replication jobs data for this vault.
	JobsSummary *JobsSummary `json:"jobsSummary,omitempty"`
	// ProtectedItemCount - Number of replication protected items for this vault.
	ProtectedItemCount *int32 `json:"protectedItemCount,omitempty"`
	// RecoveryPlanCount - Number of replication recovery plans for this vault.
	RecoveryPlanCount *int32 `json:"recoveryPlanCount,omitempty"`
	// RegisteredServersCount - Number of servers registered to this vault.
	RegisteredServersCount *int32 `json:"registeredServersCount,omitempty"`
	// RecoveryServicesProviderAuthType - The authentication type of recovery service providers in the vault.
	RecoveryServicesProviderAuthType *int32 `json:"recoveryServicesProviderAuthType,omitempty"`
}

// ReplicationUsageList replication usages for vault.
type ReplicationUsageList struct {
	autorest.Response `json:"-"`
	// Value - The list of replication usages for the given vault.
	Value *[]ReplicationUsage `json:"value,omitempty"`
}

// Resource ARM Resource.
type Resource struct {
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ETag != nil {
		objectMap["eTag"] = r.ETag
	}
	return json.Marshal(objectMap)
}

// ResourceCertificateAndAadDetails certificate details representing the Vault credentials for AAD.
type ResourceCertificateAndAadDetails struct {
	// AadAuthority - AAD tenant authority.
	AadAuthority *string `json:"aadAuthority,omitempty"`
	// AadTenantID - AAD tenant Id.
	AadTenantID *string `json:"aadTenantId,omitempty"`
	// ServicePrincipalClientID - AAD service principal clientId.
	ServicePrincipalClientID *string `json:"servicePrincipalClientId,omitempty"`
	// ServicePrincipalObjectID - AAD service principal ObjectId.
	ServicePrincipalObjectID *string `json:"servicePrincipalObjectId,omitempty"`
	// AzureManagementEndpointAudience - Azure Management Endpoint Audience.
	AzureManagementEndpointAudience *string `json:"azureManagementEndpointAudience,omitempty"`
	// Certificate - The base64 encoded certificate raw data string.
	Certificate *[]byte `json:"certificate,omitempty"`
	// FriendlyName - Certificate friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// Issuer - Certificate issuer.
	Issuer *string `json:"issuer,omitempty"`
	// ResourceID - Resource ID of the vault.
	ResourceID *int64 `json:"resourceId,omitempty"`
	// Subject - Certificate Subject Name.
	Subject *string `json:"subject,omitempty"`
	// Thumbprint - Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ValidFrom - Certificate Validity start Date time.
	ValidFrom *date.Time `json:"validFrom,omitempty"`
	// ValidTo - Certificate Validity End Date time.
	ValidTo *date.Time `json:"validTo,omitempty"`
	// AuthType - Possible values include: 'AuthTypeResourceCertificateDetails', 'AuthTypeAzureActiveDirectory', 'AuthTypeAccessControlService'
	AuthType AuthTypeBasicResourceCertificateDetails `json:"authType,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceCertificateAndAadDetails.
func (rcaad ResourceCertificateAndAadDetails) MarshalJSON() ([]byte, error) {
	rcaad.AuthType = AuthTypeAzureActiveDirectory
	objectMap := make(map[string]interface{})
	if rcaad.AadAuthority != nil {
		objectMap["aadAuthority"] = rcaad.AadAuthority
	}
	if rcaad.AadTenantID != nil {
		objectMap["aadTenantId"] = rcaad.AadTenantID
	}
	if rcaad.ServicePrincipalClientID != nil {
		objectMap["servicePrincipalClientId"] = rcaad.ServicePrincipalClientID
	}
	if rcaad.ServicePrincipalObjectID != nil {
		objectMap["servicePrincipalObjectId"] = rcaad.ServicePrincipalObjectID
	}
	if rcaad.AzureManagementEndpointAudience != nil {
		objectMap["azureManagementEndpointAudience"] = rcaad.AzureManagementEndpointAudience
	}
	if rcaad.Certificate != nil {
		objectMap["certificate"] = rcaad.Certificate
	}
	if rcaad.FriendlyName != nil {
		objectMap["friendlyName"] = rcaad.FriendlyName
	}
	if rcaad.Issuer != nil {
		objectMap["issuer"] = rcaad.Issuer
	}
	if rcaad.ResourceID != nil {
		objectMap["resourceId"] = rcaad.ResourceID
	}
	if rcaad.Subject != nil {
		objectMap["subject"] = rcaad.Subject
	}
	if rcaad.Thumbprint != nil {
		objectMap["thumbprint"] = rcaad.Thumbprint
	}
	if rcaad.ValidFrom != nil {
		objectMap["validFrom"] = rcaad.ValidFrom
	}
	if rcaad.ValidTo != nil {
		objectMap["validTo"] = rcaad.ValidTo
	}
	if rcaad.AuthType != "" {
		objectMap["authType"] = rcaad.AuthType
	}
	return json.Marshal(objectMap)
}

// AsResourceCertificateAndAadDetails is the BasicResourceCertificateDetails implementation for ResourceCertificateAndAadDetails.
func (rcaad ResourceCertificateAndAadDetails) AsResourceCertificateAndAadDetails() (*ResourceCertificateAndAadDetails, bool) {
	return &rcaad, true
}

// AsResourceCertificateAndAcsDetails is the BasicResourceCertificateDetails implementation for ResourceCertificateAndAadDetails.
func (rcaad ResourceCertificateAndAadDetails) AsResourceCertificateAndAcsDetails() (*ResourceCertificateAndAcsDetails, bool) {
	return nil, false
}

// AsResourceCertificateDetails is the BasicResourceCertificateDetails implementation for ResourceCertificateAndAadDetails.
func (rcaad ResourceCertificateAndAadDetails) AsResourceCertificateDetails() (*ResourceCertificateDetails, bool) {
	return nil, false
}

// AsBasicResourceCertificateDetails is the BasicResourceCertificateDetails implementation for ResourceCertificateAndAadDetails.
func (rcaad ResourceCertificateAndAadDetails) AsBasicResourceCertificateDetails() (BasicResourceCertificateDetails, bool) {
	return &rcaad, true
}

// ResourceCertificateAndAcsDetails certificate details representing the Vault credentials for ACS.
type ResourceCertificateAndAcsDetails struct {
	// GlobalAcsNamespace - ACS namespace name - tenant for our service.
	GlobalAcsNamespace *string `json:"globalAcsNamespace,omitempty"`
	// GlobalAcsHostName - Acs mgmt host name to connect to.
	GlobalAcsHostName *string `json:"globalAcsHostName,omitempty"`
	// GlobalAcsRPRealm - Global ACS namespace RP realm.
	GlobalAcsRPRealm *string `json:"globalAcsRPRealm,omitempty"`
	// Certificate - The base64 encoded certificate raw data string.
	Certificate *[]byte `json:"certificate,omitempty"`
	// FriendlyName - Certificate friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// Issuer - Certificate issuer.
	Issuer *string `json:"issuer,omitempty"`
	// ResourceID - Resource ID of the vault.
	ResourceID *int64 `json:"resourceId,omitempty"`
	// Subject - Certificate Subject Name.
	Subject *string `json:"subject,omitempty"`
	// Thumbprint - Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ValidFrom - Certificate Validity start Date time.
	ValidFrom *date.Time `json:"validFrom,omitempty"`
	// ValidTo - Certificate Validity End Date time.
	ValidTo *date.Time `json:"validTo,omitempty"`
	// AuthType - Possible values include: 'AuthTypeResourceCertificateDetails', 'AuthTypeAzureActiveDirectory', 'AuthTypeAccessControlService'
	AuthType AuthTypeBasicResourceCertificateDetails `json:"authType,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceCertificateAndAcsDetails.
func (rcaad ResourceCertificateAndAcsDetails) MarshalJSON() ([]byte, error) {
	rcaad.AuthType = AuthTypeAccessControlService
	objectMap := make(map[string]interface{})
	if rcaad.GlobalAcsNamespace != nil {
		objectMap["globalAcsNamespace"] = rcaad.GlobalAcsNamespace
	}
	if rcaad.GlobalAcsHostName != nil {
		objectMap["globalAcsHostName"] = rcaad.GlobalAcsHostName
	}
	if rcaad.GlobalAcsRPRealm != nil {
		objectMap["globalAcsRPRealm"] = rcaad.GlobalAcsRPRealm
	}
	if rcaad.Certificate != nil {
		objectMap["certificate"] = rcaad.Certificate
	}
	if rcaad.FriendlyName != nil {
		objectMap["friendlyName"] = rcaad.FriendlyName
	}
	if rcaad.Issuer != nil {
		objectMap["issuer"] = rcaad.Issuer
	}
	if rcaad.ResourceID != nil {
		objectMap["resourceId"] = rcaad.ResourceID
	}
	if rcaad.Subject != nil {
		objectMap["subject"] = rcaad.Subject
	}
	if rcaad.Thumbprint != nil {
		objectMap["thumbprint"] = rcaad.Thumbprint
	}
	if rcaad.ValidFrom != nil {
		objectMap["validFrom"] = rcaad.ValidFrom
	}
	if rcaad.ValidTo != nil {
		objectMap["validTo"] = rcaad.ValidTo
	}
	if rcaad.AuthType != "" {
		objectMap["authType"] = rcaad.AuthType
	}
	return json.Marshal(objectMap)
}

// AsResourceCertificateAndAadDetails is the BasicResourceCertificateDetails implementation for ResourceCertificateAndAcsDetails.
func (rcaad ResourceCertificateAndAcsDetails) AsResourceCertificateAndAadDetails() (*ResourceCertificateAndAadDetails, bool) {
	return nil, false
}

// AsResourceCertificateAndAcsDetails is the BasicResourceCertificateDetails implementation for ResourceCertificateAndAcsDetails.
func (rcaad ResourceCertificateAndAcsDetails) AsResourceCertificateAndAcsDetails() (*ResourceCertificateAndAcsDetails, bool) {
	return &rcaad, true
}

// AsResourceCertificateDetails is the BasicResourceCertificateDetails implementation for ResourceCertificateAndAcsDetails.
func (rcaad ResourceCertificateAndAcsDetails) AsResourceCertificateDetails() (*ResourceCertificateDetails, bool) {
	return nil, false
}

// AsBasicResourceCertificateDetails is the BasicResourceCertificateDetails implementation for ResourceCertificateAndAcsDetails.
func (rcaad ResourceCertificateAndAcsDetails) AsBasicResourceCertificateDetails() (BasicResourceCertificateDetails, bool) {
	return &rcaad, true
}

// BasicResourceCertificateDetails certificate details representing the Vault credentials.
type BasicResourceCertificateDetails interface {
	AsResourceCertificateAndAadDetails() (*ResourceCertificateAndAadDetails, bool)
	AsResourceCertificateAndAcsDetails() (*ResourceCertificateAndAcsDetails, bool)
	AsResourceCertificateDetails() (*ResourceCertificateDetails, bool)
}

// ResourceCertificateDetails certificate details representing the Vault credentials.
type ResourceCertificateDetails struct {
	// Certificate - The base64 encoded certificate raw data string.
	Certificate *[]byte `json:"certificate,omitempty"`
	// FriendlyName - Certificate friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// Issuer - Certificate issuer.
	Issuer *string `json:"issuer,omitempty"`
	// ResourceID - Resource ID of the vault.
	ResourceID *int64 `json:"resourceId,omitempty"`
	// Subject - Certificate Subject Name.
	Subject *string `json:"subject,omitempty"`
	// Thumbprint - Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ValidFrom - Certificate Validity start Date time.
	ValidFrom *date.Time `json:"validFrom,omitempty"`
	// ValidTo - Certificate Validity End Date time.
	ValidTo *date.Time `json:"validTo,omitempty"`
	// AuthType - Possible values include: 'AuthTypeResourceCertificateDetails', 'AuthTypeAzureActiveDirectory', 'AuthTypeAccessControlService'
	AuthType AuthTypeBasicResourceCertificateDetails `json:"authType,omitempty"`
}

func unmarshalBasicResourceCertificateDetails(body []byte) (BasicResourceCertificateDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["authType"] {
	case string(AuthTypeAzureActiveDirectory):
		var rcaad ResourceCertificateAndAadDetails
		err := json.Unmarshal(body, &rcaad)
		return rcaad, err
	case string(AuthTypeAccessControlService):
		var rcaad ResourceCertificateAndAcsDetails
		err := json.Unmarshal(body, &rcaad)
		return rcaad, err
	default:
		var rcd ResourceCertificateDetails
		err := json.Unmarshal(body, &rcd)
		return rcd, err
	}
}
func unmarshalBasicResourceCertificateDetailsArray(body []byte) ([]BasicResourceCertificateDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rcdArray := make([]BasicResourceCertificateDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rcd, err := unmarshalBasicResourceCertificateDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		rcdArray[index] = rcd
	}
	return rcdArray, nil
}

// MarshalJSON is the custom marshaler for ResourceCertificateDetails.
func (rcd ResourceCertificateDetails) MarshalJSON() ([]byte, error) {
	rcd.AuthType = AuthTypeResourceCertificateDetails
	objectMap := make(map[string]interface{})
	if rcd.Certificate != nil {
		objectMap["certificate"] = rcd.Certificate
	}
	if rcd.FriendlyName != nil {
		objectMap["friendlyName"] = rcd.FriendlyName
	}
	if rcd.Issuer != nil {
		objectMap["issuer"] = rcd.Issuer
	}
	if rcd.ResourceID != nil {
		objectMap["resourceId"] = rcd.ResourceID
	}
	if rcd.Subject != nil {
		objectMap["subject"] = rcd.Subject
	}
	if rcd.Thumbprint != nil {
		objectMap["thumbprint"] = rcd.Thumbprint
	}
	if rcd.ValidFrom != nil {
		objectMap["validFrom"] = rcd.ValidFrom
	}
	if rcd.ValidTo != nil {
		objectMap["validTo"] = rcd.ValidTo
	}
	if rcd.AuthType != "" {
		objectMap["authType"] = rcd.AuthType
	}
	return json.Marshal(objectMap)
}

// AsResourceCertificateAndAadDetails is the BasicResourceCertificateDetails implementation for ResourceCertificateDetails.
func (rcd ResourceCertificateDetails) AsResourceCertificateAndAadDetails() (*ResourceCertificateAndAadDetails, bool) {
	return nil, false
}

// AsResourceCertificateAndAcsDetails is the BasicResourceCertificateDetails implementation for ResourceCertificateDetails.
func (rcd ResourceCertificateDetails) AsResourceCertificateAndAcsDetails() (*ResourceCertificateAndAcsDetails, bool) {
	return nil, false
}

// AsResourceCertificateDetails is the BasicResourceCertificateDetails implementation for ResourceCertificateDetails.
func (rcd ResourceCertificateDetails) AsResourceCertificateDetails() (*ResourceCertificateDetails, bool) {
	return &rcd, true
}

// AsBasicResourceCertificateDetails is the BasicResourceCertificateDetails implementation for ResourceCertificateDetails.
func (rcd ResourceCertificateDetails) AsBasicResourceCertificateDetails() (BasicResourceCertificateDetails, bool) {
	return &rcd, true
}

// Sku identifies the unique system identifier for each Azure resource.
type Sku struct {
	// Name - The Sku name. Possible values include: 'Standard', 'RS0'
	Name SkuName `json:"name,omitempty"`
}

// TrackedResource tracked resource with location.
type TrackedResource struct {
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.ETag != nil {
		objectMap["eTag"] = tr.ETag
	}
	return json.Marshal(objectMap)
}

// UpgradeDetails details for upgrading vault.
type UpgradeDetails struct {
	// OperationID - READ-ONLY; ID of the vault upgrade operation.
	OperationID *string `json:"operationId,omitempty"`
	// StartTimeUtc - READ-ONLY; UTC time at which the upgrade operation has started.
	StartTimeUtc *date.Time `json:"startTimeUtc,omitempty"`
	// LastUpdatedTimeUtc - READ-ONLY; UTC time at which the upgrade operation status was last updated.
	LastUpdatedTimeUtc *date.Time `json:"lastUpdatedTimeUtc,omitempty"`
	// EndTimeUtc - READ-ONLY; UTC time at which the upgrade operation has ended.
	EndTimeUtc *date.Time `json:"endTimeUtc,omitempty"`
	// Status - READ-ONLY; Status of the vault upgrade operation. Possible values include: 'Unknown', 'InProgress', 'Upgraded', 'Failed'
	Status VaultUpgradeState `json:"status,omitempty"`
	// Message - READ-ONLY; Message to the user containing information about the upgrade operation.
	Message *string `json:"message,omitempty"`
	// TriggerType - READ-ONLY; The way the vault upgrade was triggered. Possible values include: 'UserTriggered', 'ForcedUpgrade'
	TriggerType TriggerType `json:"triggerType,omitempty"`
	// UpgradedResourceID - READ-ONLY; Resource ID of the upgraded vault.
	UpgradedResourceID *string `json:"upgradedResourceId,omitempty"`
	// PreviousResourceID - READ-ONLY; Resource ID of the vault before the upgrade.
	PreviousResourceID *string `json:"previousResourceId,omitempty"`
}

// MarshalJSON is the custom marshaler for UpgradeDetails.
func (ud UpgradeDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Vault resource information, as returned by the resource provider.
type Vault struct {
	autorest.Response `json:"-"`
	Identity          *IdentityData    `json:"identity,omitempty"`
	Properties        *VaultProperties `json:"properties,omitempty"`
	Sku               *Sku             `json:"sku,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for Vault.
func (vVar Vault) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vVar.Identity != nil {
		objectMap["identity"] = vVar.Identity
	}
	if vVar.Properties != nil {
		objectMap["properties"] = vVar.Properties
	}
	if vVar.Sku != nil {
		objectMap["sku"] = vVar.Sku
	}
	if vVar.Location != nil {
		objectMap["location"] = vVar.Location
	}
	if vVar.Tags != nil {
		objectMap["tags"] = vVar.Tags
	}
	if vVar.ETag != nil {
		objectMap["eTag"] = vVar.ETag
	}
	return json.Marshal(objectMap)
}

// VaultCertificateResponse certificate corresponding to a vault that can be used by clients to register
// themselves with the vault.
type VaultCertificateResponse struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID         *string                         `json:"id,omitempty"`
	Properties BasicResourceCertificateDetails `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VaultCertificateResponse.
func (vcr VaultCertificateResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = vcr.Properties
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VaultCertificateResponse struct.
func (vcr *VaultCertificateResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vcr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vcr.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vcr.ID = &ID
			}
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicResourceCertificateDetails(*v)
				if err != nil {
					return err
				}
				vcr.Properties = properties
			}
		}
	}

	return nil
}

// VaultExtendedInfo vault extended information.
type VaultExtendedInfo struct {
	// IntegrityKey - Integrity key.
	IntegrityKey *string `json:"integrityKey,omitempty"`
	// EncryptionKey - Encryption key.
	EncryptionKey *string `json:"encryptionKey,omitempty"`
	// EncryptionKeyThumbprint - Encryption key thumbprint.
	EncryptionKeyThumbprint *string `json:"encryptionKeyThumbprint,omitempty"`
	// Algorithm - Algorithm for Vault ExtendedInfo
	Algorithm *string `json:"algorithm,omitempty"`
}

// VaultExtendedInfoResource vault extended information.
type VaultExtendedInfoResource struct {
	autorest.Response  `json:"-"`
	*VaultExtendedInfo `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for VaultExtendedInfoResource.
func (veir VaultExtendedInfoResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if veir.VaultExtendedInfo != nil {
		objectMap["properties"] = veir.VaultExtendedInfo
	}
	if veir.ETag != nil {
		objectMap["eTag"] = veir.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VaultExtendedInfoResource struct.
func (veir *VaultExtendedInfoResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vaultExtendedInfo VaultExtendedInfo
				err = json.Unmarshal(*v, &vaultExtendedInfo)
				if err != nil {
					return err
				}
				veir.VaultExtendedInfo = &vaultExtendedInfo
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				veir.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				veir.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				veir.Type = &typeVar
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				veir.ETag = &eTag
			}
		}
	}

	return nil
}

// VaultList the response model for a list of Vaults.
type VaultList struct {
	autorest.Response `json:"-"`
	Value             *[]Vault `json:"value,omitempty"`
	// NextLink - READ-ONLY
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for VaultList.
func (vl VaultList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vl.Value != nil {
		objectMap["value"] = vl.Value
	}
	return json.Marshal(objectMap)
}

// VaultListIterator provides access to a complete listing of Vault values.
type VaultListIterator struct {
	i    int
	page VaultListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VaultListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VaultListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VaultListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VaultListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VaultListIterator) Response() VaultList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VaultListIterator) Value() Vault {
	if !iter.page.NotDone() {
		return Vault{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VaultListIterator type.
func NewVaultListIterator(page VaultListPage) VaultListIterator {
	return VaultListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vl VaultList) IsEmpty() bool {
	return vl.Value == nil || len(*vl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vl VaultList) hasNextLink() bool {
	return vl.NextLink != nil && len(*vl.NextLink) != 0
}

// vaultListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vl VaultList) vaultListPreparer(ctx context.Context) (*http.Request, error) {
	if !vl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vl.NextLink)))
}

// VaultListPage contains a page of Vault values.
type VaultListPage struct {
	fn func(context.Context, VaultList) (VaultList, error)
	vl VaultList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VaultListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VaultListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vl)
		if err != nil {
			return err
		}
		page.vl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VaultListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VaultListPage) NotDone() bool {
	return !page.vl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VaultListPage) Response() VaultList {
	return page.vl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VaultListPage) Values() []Vault {
	if page.vl.IsEmpty() {
		return nil
	}
	return *page.vl.Value
}

// Creates a new instance of the VaultListPage type.
func NewVaultListPage(cur VaultList, getNextPage func(context.Context, VaultList) (VaultList, error)) VaultListPage {
	return VaultListPage{
		fn: getNextPage,
		vl: cur,
	}
}

// VaultProperties properties of the vault.
type VaultProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning State.
	ProvisioningState *string         `json:"provisioningState,omitempty"`
	UpgradeDetails    *UpgradeDetails `json:"upgradeDetails,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; List of private endpoint connection.
	PrivateEndpointConnections *[]PrivateEndpointConnectionVaultProperties `json:"privateEndpointConnections,omitempty"`
	// PrivateEndpointStateForBackup - READ-ONLY; Private endpoint state for backup. Possible values include: 'VaultPrivateEndpointStateNone', 'VaultPrivateEndpointStateEnabled'
	PrivateEndpointStateForBackup VaultPrivateEndpointState `json:"privateEndpointStateForBackup,omitempty"`
	// PrivateEndpointStateForSiteRecovery - READ-ONLY; Private endpoint state for site recovery. Possible values include: 'VaultPrivateEndpointStateNone', 'VaultPrivateEndpointStateEnabled'
	PrivateEndpointStateForSiteRecovery VaultPrivateEndpointState `json:"privateEndpointStateForSiteRecovery,omitempty"`
}

// MarshalJSON is the custom marshaler for VaultProperties.
func (vp VaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vp.UpgradeDetails != nil {
		objectMap["upgradeDetails"] = vp.UpgradeDetails
	}
	return json.Marshal(objectMap)
}

// VaultUsage usages of a vault.
type VaultUsage struct {
	// Unit - Unit of the usage. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond'
	Unit UsagesUnit `json:"unit,omitempty"`
	// QuotaPeriod - Quota period of usage.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
	// NextResetTime - Next reset time of usage.
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
	// CurrentValue - Current value of usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Limit - Limit of usage.
	Limit *int64 `json:"limit,omitempty"`
	// Name - Name of usage.
	Name *NameInfo `json:"name,omitempty"`
}

// VaultUsageList usage for vault.
type VaultUsageList struct {
	autorest.Response `json:"-"`
	// Value - The list of usages for the given vault.
	Value *[]VaultUsage `json:"value,omitempty"`
}
