package packet

// These test vectors contain V4 or V5 symmetric key encrypted packets followed
// by an integrity protected packet (SEIPD v1 or v2).

type packetSequence struct {
	password string
	packets  string
	contents string
}

var keyAndIpePackets = []*packetSequence{symEncTest, aeadEaxRFC, aeadOcbRFC, aeadGcmRFC}

var aeadEaxRFC = &packetSequence{
	password: "password",
	packets:  "c340051e07010b0308a5ae579d1fc5d82bff69224f919993b3506fa3b59a6a73cff8da746b88e357e8ae54eb87e1d70575d72f60232990523e9a59094922406be1c3d269020701069ff90e3b321964f3a42913c8dcc6619325015227efb7eaeaa49f04c2e674175d4a3d226ed6afcb9ca9ac122c1470e11c63d4c0ab241c6a938ad48bf99a5a99b90bba8325de61047540258ab7959a95ad051dda96eb15431dfef5f5e2255ca78261546e339a",
	contents: "cb1362000000000048656c6c6f2c20776f726c6421d50eae5bf0cd6705500355816cb0c8ff",
}

var aeadOcbRFC = &packetSequence{
	password: "password",
	packets:  "c33f051d07020b030856a298d2f5e36453ffcfcc5c11664edb9db42590d7dc46b078c5c0419cc51b3a4687cb32e5b7031ce7c66975765b5c21d92aef4cc05c3fead2690207020620a661f731fc9a3032b5623326027e3a5d8db5748ebeff0b0c5910d09ecdd641ff9fd38562758035bc49754ce1bf3fffa7dad0a3b8104f5133cf42a4100a83eef4ca1b4801a8846bf42bcda7c8ce9d65e212f301cbcd98fdcade694a877ad4247323f6e857",
	contents: "cb1362000000000048656c6c6f2c20776f726c6421d50eae6aa1649b56aa835b2613902bd2",
}

var aeadGcmRFC = &packetSequence{
	password: "password",
	packets:  "c33c051a07030b0308e9d39785b2070008ffb42e7c483ef4884457cb37260c0c4bf3f2cd6cb7b6e38b5bf33467c1c71944dd590346662f5ade61ff84bce0d26902070306fcb94490bcb98bbdc9d106c6090266940f72e89edc21b5596b1576b101ed0f9ffc6fc6d65bbfd24dcd0790966e6d1e85a30053784cb1d8b6a0699ef12155a7b2ad6258531b57651fd7777912fa95e35d9b40216f69a4c248db28ff4331f1632907399e6ff9",
	contents: "cb1362000000000048656c6c6f2c20776f726c6421d50e1ce2269a9eddef81032172b7ed7c",
}

var symEncTest = &packetSequence{
	password: "password",
	packets:  "c32e04090308f9f479ee0862ee8700a86d5cce4c166b5a7d664dcbe0f0eb2696a3e8a815fe8913251605ad79cc865f15d24301c3da8f5003383b9bd62c673589e2292d990902227311905ff4a7f694727578468e15d9f1aadb41572c4b2a789d7f93896661249200b64af9fbf6abf001f5498d036a",
	contents: "cb1875076d73672e7478745cafc23e636f6e74656e74732e0d0a",
}
