package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeModels invokes the cloudapi.DescribeModels API synchronously
// api document: https://help.aliyun.com/api/cloudapi/describemodels.html
func (client *Client) DescribeModels(request *DescribeModelsRequest) (response *DescribeModelsResponse, err error) {
	response = CreateDescribeModelsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeModelsWithChan invokes the cloudapi.DescribeModels API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/describemodels.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeModelsWithChan(request *DescribeModelsRequest) (<-chan *DescribeModelsResponse, <-chan error) {
	responseChan := make(chan *DescribeModelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeModels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeModelsWithCallback invokes the cloudapi.DescribeModels API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/describemodels.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeModelsWithCallback(request *DescribeModelsRequest, callback func(response *DescribeModelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeModelsResponse
		var err error
		defer close(result)
		response, err = client.DescribeModels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeModelsRequest is the request struct for api DescribeModels
type DescribeModelsRequest struct {
	*requests.RpcRequest
	ModelId       string           `position:"Query" name:"ModelId"`
	GroupId       string           `position:"Query" name:"GroupId"`
	ModelName     string           `position:"Query" name:"ModelName"`
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeModelsResponse is the response struct for api DescribeModels
type DescribeModelsResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	TotalCount   int          `json:"TotalCount" xml:"TotalCount"`
	PageSize     int          `json:"PageSize" xml:"PageSize"`
	PageNumber   int          `json:"PageNumber" xml:"PageNumber"`
	ModelDetails ModelDetails `json:"ModelDetails" xml:"ModelDetails"`
}

// CreateDescribeModelsRequest creates a request to invoke DescribeModels API
func CreateDescribeModelsRequest() (request *DescribeModelsRequest) {
	request = &DescribeModelsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeModels", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeModelsResponse creates a response to parse from DescribeModels response
func CreateDescribeModelsResponse() (response *DescribeModelsResponse) {
	response = &DescribeModelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
