package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInvocationResults invokes the ehpc.ListInvocationResults API synchronously
func (client *Client) ListInvocationResults(request *ListInvocationResultsRequest) (response *ListInvocationResultsResponse, err error) {
	response = CreateListInvocationResultsResponse()
	err = client.DoAction(request, response)
	return
}

// ListInvocationResultsWithChan invokes the ehpc.ListInvocationResults API asynchronously
func (client *Client) ListInvocationResultsWithChan(request *ListInvocationResultsRequest) (<-chan *ListInvocationResultsResponse, <-chan error) {
	responseChan := make(chan *ListInvocationResultsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInvocationResults(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInvocationResultsWithCallback invokes the ehpc.ListInvocationResults API asynchronously
func (client *Client) ListInvocationResultsWithCallback(request *ListInvocationResultsRequest, callback func(response *ListInvocationResultsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInvocationResultsResponse
		var err error
		defer close(result)
		response, err = client.ListInvocationResults(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInvocationResultsRequest is the request struct for api ListInvocationResults
type ListInvocationResultsRequest struct {
	*requests.RpcRequest
	Instance           *[]ListInvocationResultsInstance `position:"Query" name:"Instance"  type:"Repeated"`
	ClusterId          string                           `position:"Query" name:"ClusterId"`
	CommandId          string                           `position:"Query" name:"CommandId"`
	PageNumber         requests.Integer                 `position:"Query" name:"PageNumber"`
	InvokeRecordStatus string                           `position:"Query" name:"InvokeRecordStatus"`
	PageSize           requests.Integer                 `position:"Query" name:"PageSize"`
}

// ListInvocationResultsInstance is a repeated param struct in ListInvocationResultsRequest
type ListInvocationResultsInstance struct {
	Id string `name:"Id"`
}

// ListInvocationResultsResponse is the response struct for api ListInvocationResults
type ListInvocationResultsResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	TotalCount        int               `json:"TotalCount" xml:"TotalCount"`
	PageNumber        int               `json:"PageNumber" xml:"PageNumber"`
	PageSize          int               `json:"PageSize" xml:"PageSize"`
	InvocationResults InvocationResults `json:"InvocationResults" xml:"InvocationResults"`
}

// CreateListInvocationResultsRequest creates a request to invoke ListInvocationResults API
func CreateListInvocationResultsRequest() (request *ListInvocationResultsRequest) {
	request = &ListInvocationResultsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "ListInvocationResults", "", "")
	request.Method = requests.GET
	return
}

// CreateListInvocationResultsResponse creates a response to parse from ListInvocationResults response
func CreateListInvocationResultsResponse() (response *ListInvocationResultsResponse) {
	response = &ListInvocationResultsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
