package jarvis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCdnCertify invokes the jarvis.DescribeCdnCertify API synchronously
// api document: https://help.aliyun.com/api/jarvis/describecdncertify.html
func (client *Client) DescribeCdnCertify(request *DescribeCdnCertifyRequest) (response *DescribeCdnCertifyResponse, err error) {
	response = CreateDescribeCdnCertifyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCdnCertifyWithChan invokes the jarvis.DescribeCdnCertify API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describecdncertify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCdnCertifyWithChan(request *DescribeCdnCertifyRequest) (<-chan *DescribeCdnCertifyResponse, <-chan error) {
	responseChan := make(chan *DescribeCdnCertifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCdnCertify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCdnCertifyWithCallback invokes the jarvis.DescribeCdnCertify API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describecdncertify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCdnCertifyWithCallback(request *DescribeCdnCertifyRequest, callback func(response *DescribeCdnCertifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCdnCertifyResponse
		var err error
		defer close(result)
		response, err = client.DescribeCdnCertify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCdnCertifyRequest is the request struct for api DescribeCdnCertify
type DescribeCdnCertifyRequest struct {
	*requests.RpcRequest
	SourceIp   string `position:"Query" name:"SourceIp"`
	Lang       string `position:"Query" name:"Lang"`
	SourceCode string `position:"Query" name:"SourceCode"`
}

// DescribeCdnCertifyResponse is the response struct for api DescribeCdnCertify
type DescribeCdnCertifyResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	IsCdnVendor bool   `json:"IsCdnVendor" xml:"IsCdnVendor"`
	Module      string `json:"Module" xml:"Module"`
}

// CreateDescribeCdnCertifyRequest creates a request to invoke DescribeCdnCertify API
func CreateDescribeCdnCertifyRequest() (request *DescribeCdnCertifyRequest) {
	request = &DescribeCdnCertifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("jarvis", "2018-02-06", "DescribeCdnCertify", "jarvis", "openAPI")
	return
}

// CreateDescribeCdnCertifyResponse creates a response to parse from DescribeCdnCertify response
func CreateDescribeCdnCertifyResponse() (response *DescribeCdnCertifyResponse) {
	response = &DescribeCdnCertifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
