package jarvis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCdnSubscription invokes the jarvis.DescribeCdnSubscription API synchronously
// api document: https://help.aliyun.com/api/jarvis/describecdnsubscription.html
func (client *Client) DescribeCdnSubscription(request *DescribeCdnSubscriptionRequest) (response *DescribeCdnSubscriptionResponse, err error) {
	response = CreateDescribeCdnSubscriptionResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCdnSubscriptionWithChan invokes the jarvis.DescribeCdnSubscription API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describecdnsubscription.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCdnSubscriptionWithChan(request *DescribeCdnSubscriptionRequest) (<-chan *DescribeCdnSubscriptionResponse, <-chan error) {
	responseChan := make(chan *DescribeCdnSubscriptionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCdnSubscription(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCdnSubscriptionWithCallback invokes the jarvis.DescribeCdnSubscription API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describecdnsubscription.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCdnSubscriptionWithCallback(request *DescribeCdnSubscriptionRequest, callback func(response *DescribeCdnSubscriptionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCdnSubscriptionResponse
		var err error
		defer close(result)
		response, err = client.DescribeCdnSubscription(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCdnSubscriptionRequest is the request struct for api DescribeCdnSubscription
type DescribeCdnSubscriptionRequest struct {
	*requests.RpcRequest
	SourceIp          string           `position:"Query" name:"SourceIp"`
	SubscriptionState requests.Integer `position:"Query" name:"SubscriptionState"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage       requests.Integer `position:"Query" name:"CurrentPage"`
	Lang              string           `position:"Query" name:"Lang"`
	VendorName        string           `position:"Query" name:"VendorName"`
	SourceCode        string           `position:"Query" name:"SourceCode"`
}

// DescribeCdnSubscriptionResponse is the response struct for api DescribeCdnSubscription
type DescribeCdnSubscriptionResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Module    string   `json:"Module" xml:"Module"`
	PageInfo  PageInfo `json:"PageInfo" xml:"PageInfo"`
	DataList  []Data   `json:"DataList" xml:"DataList"`
}

// CreateDescribeCdnSubscriptionRequest creates a request to invoke DescribeCdnSubscription API
func CreateDescribeCdnSubscriptionRequest() (request *DescribeCdnSubscriptionRequest) {
	request = &DescribeCdnSubscriptionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("jarvis", "2018-02-06", "DescribeCdnSubscription", "jarvis", "openAPI")
	return
}

// CreateDescribeCdnSubscriptionResponse creates a response to parse from DescribeCdnSubscription response
func CreateDescribeCdnSubscriptionResponse() (response *DescribeCdnSubscriptionResponse) {
	response = &DescribeCdnSubscriptionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
