package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitInnerJob invokes the mts.SubmitInnerJob API synchronously
func (client *Client) SubmitInnerJob(request *SubmitInnerJobRequest) (response *SubmitInnerJobResponse, err error) {
	response = CreateSubmitInnerJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitInnerJobWithChan invokes the mts.SubmitInnerJob API asynchronously
func (client *Client) SubmitInnerJobWithChan(request *SubmitInnerJobRequest) (<-chan *SubmitInnerJobResponse, <-chan error) {
	responseChan := make(chan *SubmitInnerJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitInnerJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitInnerJobWithCallback invokes the mts.SubmitInnerJob API asynchronously
func (client *Client) SubmitInnerJobWithCallback(request *SubmitInnerJobRequest, callback func(response *SubmitInnerJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitInnerJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitInnerJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitInnerJobRequest is the request struct for api SubmitInnerJob
type SubmitInnerJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Video                string           `position:"Query" name:"Video"`
	Uid                  requests.Integer `position:"Query" name:"Uid"`
	Images               string           `position:"Query" name:"Images"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PipelineId           string           `position:"Query" name:"PipelineId"`
	Config               string           `position:"Query" name:"Config"`
}

// SubmitInnerJobResponse is the response struct for api SubmitInnerJob
type SubmitInnerJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateSubmitInnerJobRequest creates a request to invoke SubmitInnerJob API
func CreateSubmitInnerJobRequest() (request *SubmitInnerJobRequest) {
	request = &SubmitInnerJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SubmitInnerJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitInnerJobResponse creates a response to parse from SubmitInnerJob response
func CreateSubmitInnerJobResponse() (response *SubmitInnerJobResponse) {
	response = &SubmitInnerJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
