package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryUserGroupMember invokes the quickbi_public.QueryUserGroupMember API synchronously
func (client *Client) QueryUserGroupMember(request *QueryUserGroupMemberRequest) (response *QueryUserGroupMemberResponse, err error) {
	response = CreateQueryUserGroupMemberResponse()
	err = client.DoAction(request, response)
	return
}

// QueryUserGroupMemberWithChan invokes the quickbi_public.QueryUserGroupMember API asynchronously
func (client *Client) QueryUserGroupMemberWithChan(request *QueryUserGroupMemberRequest) (<-chan *QueryUserGroupMemberResponse, <-chan error) {
	responseChan := make(chan *QueryUserGroupMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryUserGroupMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryUserGroupMemberWithCallback invokes the quickbi_public.QueryUserGroupMember API asynchronously
func (client *Client) QueryUserGroupMemberWithCallback(request *QueryUserGroupMemberRequest, callback func(response *QueryUserGroupMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryUserGroupMemberResponse
		var err error
		defer close(result)
		response, err = client.QueryUserGroupMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryUserGroupMemberRequest is the request struct for api QueryUserGroupMember
type QueryUserGroupMemberRequest struct {
	*requests.RpcRequest
	AccessPoint string `position:"Query" name:"AccessPoint"`
	UserGroupId string `position:"Query" name:"UserGroupId"`
	SignType    string `position:"Query" name:"SignType"`
	Keyword     string `position:"Query" name:"Keyword"`
}

// QueryUserGroupMemberResponse is the response struct for api QueryUserGroupMember
type QueryUserGroupMemberResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    []Data `json:"Result" xml:"Result"`
}

// CreateQueryUserGroupMemberRequest creates a request to invoke QueryUserGroupMember API
func CreateQueryUserGroupMemberRequest() (request *QueryUserGroupMemberRequest) {
	request = &QueryUserGroupMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2020-07-31", "QueryUserGroupMember", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryUserGroupMemberResponse creates a response to parse from QueryUserGroupMember response
func CreateQueryUserGroupMemberResponse() (response *QueryUserGroupMemberResponse) {
	response = &QueryUserGroupMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
