package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVsDomainRecordData invokes the vs.DescribeVsDomainRecordData API synchronously
func (client *Client) DescribeVsDomainRecordData(request *DescribeVsDomainRecordDataRequest) (response *DescribeVsDomainRecordDataResponse, err error) {
	response = CreateDescribeVsDomainRecordDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVsDomainRecordDataWithChan invokes the vs.DescribeVsDomainRecordData API asynchronously
func (client *Client) DescribeVsDomainRecordDataWithChan(request *DescribeVsDomainRecordDataRequest) (<-chan *DescribeVsDomainRecordDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVsDomainRecordDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVsDomainRecordData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVsDomainRecordDataWithCallback invokes the vs.DescribeVsDomainRecordData API asynchronously
func (client *Client) DescribeVsDomainRecordDataWithCallback(request *DescribeVsDomainRecordDataRequest, callback func(response *DescribeVsDomainRecordDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVsDomainRecordDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVsDomainRecordData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVsDomainRecordDataRequest is the request struct for api DescribeVsDomainRecordData
type DescribeVsDomainRecordDataRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	ShowLog    string           `position:"Query" name:"ShowLog"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeVsDomainRecordDataResponse is the response struct for api DescribeVsDomainRecordData
type DescribeVsDomainRecordDataResponse struct {
	*responses.BaseResponse
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	DomainName            string                `json:"DomainName" xml:"DomainName"`
	StartTime             string                `json:"StartTime" xml:"StartTime"`
	EndTime               string                `json:"EndTime" xml:"EndTime"`
	RecordDataPerInterval RecordDataPerInterval `json:"RecordDataPerInterval" xml:"RecordDataPerInterval"`
}

// CreateDescribeVsDomainRecordDataRequest creates a request to invoke DescribeVsDomainRecordData API
func CreateDescribeVsDomainRecordDataRequest() (request *DescribeVsDomainRecordDataRequest) {
	request = &DescribeVsDomainRecordDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeVsDomainRecordData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeVsDomainRecordDataResponse creates a response to parse from DescribeVsDomainRecordData response
func CreateDescribeVsDomainRecordDataResponse() (response *DescribeVsDomainRecordDataResponse) {
	response = &DescribeVsDomainRecordDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
