// Copyright (c) HashiCorp, Inc.

package addlicense

// This file is autogenerated by running ./generate-spdx-list.sh

var spdxIds = []string{

	// BSD Zero Clause License
	// https://spdx.org/licenses/0BSD.html
	"0BSD",

	// Attribution Assurance License
	// https://spdx.org/licenses/AAL.html
	"AAL",

	// Amazon Digital Services License
	// https://spdx.org/licenses/ADSL.html
	"ADSL",

	// Academic Free License v1.1
	// https://spdx.org/licenses/AFL-1.1.html
	"AFL-1.1",

	// Academic Free License v1.2
	// https://spdx.org/licenses/AFL-1.2.html
	"AFL-1.2",

	// Academic Free License v2.0
	// https://spdx.org/licenses/AFL-2.0.html
	"AFL-2.0",

	// Academic Free License v2.1
	// https://spdx.org/licenses/AFL-2.1.html
	"AFL-2.1",

	// Academic Free License v3.0
	// https://spdx.org/licenses/AFL-3.0.html
	"AFL-3.0",

	// Affero General Public License v1.0 only
	// https://spdx.org/licenses/AGPL-1.0-only.html
	"AGPL-1.0-only",

	// Affero General Public License v1.0 or later
	// https://spdx.org/licenses/AGPL-1.0-or-later.html
	"AGPL-1.0-or-later",

	// GNU Affero General Public License v3.0 only
	// https://spdx.org/licenses/AGPL-3.0-only.html
	"AGPL-3.0-only",

	// GNU Affero General Public License v3.0 or later
	// https://spdx.org/licenses/AGPL-3.0-or-later.html
	"AGPL-3.0-or-later",

	// AMD's plpa_map.c License
	// https://spdx.org/licenses/AMDPLPA.html
	"AMDPLPA",

	// Apple MIT License
	// https://spdx.org/licenses/AML.html
	"AML",

	// Academy of Motion Picture Arts and Sciences BSD
	// https://spdx.org/licenses/AMPAS.html
	"AMPAS",

	// ANTLR Software Rights Notice with license fallback
	// https://spdx.org/licenses/ANTLR-PD-fallback.html
	"ANTLR-PD-fallback",

	// ANTLR Software Rights Notice
	// https://spdx.org/licenses/ANTLR-PD.html
	"ANTLR-PD",

	// Adobe Postscript AFM License
	// https://spdx.org/licenses/APAFML.html
	"APAFML",

	// Adaptive Public License 1.0
	// https://spdx.org/licenses/APL-1.0.html
	"APL-1.0",

	// Apple Public Source License 1.0
	// https://spdx.org/licenses/APSL-1.0.html
	"APSL-1.0",

	// Apple Public Source License 1.1
	// https://spdx.org/licenses/APSL-1.1.html
	"APSL-1.1",

	// Apple Public Source License 1.2
	// https://spdx.org/licenses/APSL-1.2.html
	"APSL-1.2",

	// Apple Public Source License 2.0
	// https://spdx.org/licenses/APSL-2.0.html
	"APSL-2.0",

	// Abstyles License
	// https://spdx.org/licenses/Abstyles.html
	"Abstyles",

	// Adobe Systems Incorporated Source Code License Agreement
	// https://spdx.org/licenses/Adobe-2006.html
	"Adobe-2006",

	// Adobe Glyph List License
	// https://spdx.org/licenses/Adobe-Glyph.html
	"Adobe-Glyph",

	// Afmparse License
	// https://spdx.org/licenses/Afmparse.html
	"Afmparse",

	// Aladdin Free Public License
	// https://spdx.org/licenses/Aladdin.html
	"Aladdin",

	// Apache License 1.0
	// https://spdx.org/licenses/Apache-1.0.html
	"Apache-1.0",

	// Apache License 1.1
	// https://spdx.org/licenses/Apache-1.1.html
	"Apache-1.1",

	// Apache License 2.0
	// https://spdx.org/licenses/Apache-2.0.html
	"Apache-2.0",

	// App::s2p License
	// https://spdx.org/licenses/App-s2p.html
	"App-s2p",

	// Arphic Public License
	// https://spdx.org/licenses/Arphic-1999.html
	"Arphic-1999",

	// Artistic License 1.0 (Perl)
	// https://spdx.org/licenses/Artistic-1.0-Perl.html
	"Artistic-1.0-Perl",

	// Artistic License 1.0 w/clause 8
	// https://spdx.org/licenses/Artistic-1.0-cl8.html
	"Artistic-1.0-cl8",

	// Artistic License 1.0
	// https://spdx.org/licenses/Artistic-1.0.html
	"Artistic-1.0",

	// Artistic License 2.0
	// https://spdx.org/licenses/Artistic-2.0.html
	"Artistic-2.0",

	// BSD 1-Clause License
	// https://spdx.org/licenses/BSD-1-Clause.html
	"BSD-1-Clause",

	// BSD-2-Clause Plus Patent License
	// https://spdx.org/licenses/BSD-2-Clause-Patent.html
	"BSD-2-Clause-Patent",

	// BSD 2-Clause with views sentence
	// https://spdx.org/licenses/BSD-2-Clause-Views.html
	"BSD-2-Clause-Views",

	// BSD 2-Clause "Simplified" License
	// https://spdx.org/licenses/BSD-2-Clause.html
	"BSD-2-Clause",

	// BSD with attribution
	// https://spdx.org/licenses/BSD-3-Clause-Attribution.html
	"BSD-3-Clause-Attribution",

	// BSD 3-Clause Clear License
	// https://spdx.org/licenses/BSD-3-Clause-Clear.html
	"BSD-3-Clause-Clear",

	// Lawrence Berkeley National Labs BSD variant license
	// https://spdx.org/licenses/BSD-3-Clause-LBNL.html
	"BSD-3-Clause-LBNL",

	// BSD 3-Clause Modification
	// https://spdx.org/licenses/BSD-3-Clause-Modification.html
	"BSD-3-Clause-Modification",

	// BSD 3-Clause No Military License
	// https://spdx.org/licenses/BSD-3-Clause-No-Military-License.html
	"BSD-3-Clause-No-Military-License",

	// BSD 3-Clause No Nuclear License 2014
	// https://spdx.org/licenses/BSD-3-Clause-No-Nuclear-License-2014.html
	"BSD-3-Clause-No-Nuclear-License-2014",

	// BSD 3-Clause No Nuclear License
	// https://spdx.org/licenses/BSD-3-Clause-No-Nuclear-License.html
	"BSD-3-Clause-No-Nuclear-License",

	// BSD 3-Clause No Nuclear Warranty
	// https://spdx.org/licenses/BSD-3-Clause-No-Nuclear-Warranty.html
	"BSD-3-Clause-No-Nuclear-Warranty",

	// BSD 3-Clause Open MPI variant
	// https://spdx.org/licenses/BSD-3-Clause-Open-MPI.html
	"BSD-3-Clause-Open-MPI",

	// BSD 3-Clause "New" or "Revised" License
	// https://spdx.org/licenses/BSD-3-Clause.html
	"BSD-3-Clause",

	// BSD 4 Clause Shortened
	// https://spdx.org/licenses/BSD-4-Clause-Shortened.html
	"BSD-4-Clause-Shortened",

	// BSD-4-Clause (University of California-Specific)
	// https://spdx.org/licenses/BSD-4-Clause-UC.html
	"BSD-4-Clause-UC",

	// BSD 4-Clause "Original" or "Old" License
	// https://spdx.org/licenses/BSD-4-Clause.html
	"BSD-4-Clause",

	// BSD Protection License
	// https://spdx.org/licenses/BSD-Protection.html
	"BSD-Protection",

	// BSD Source Code Attribution
	// https://spdx.org/licenses/BSD-Source-Code.html
	"BSD-Source-Code",

	// Boost Software License 1.0
	// https://spdx.org/licenses/BSL-1.0.html
	"BSL-1.0",

	// Business Source License 1.1
	// https://spdx.org/licenses/BUSL-1.1.html
	"BUSL-1.1",

	// Baekmuk License
	// https://spdx.org/licenses/Baekmuk.html
	"Baekmuk",

	// Bahyph License
	// https://spdx.org/licenses/Bahyph.html
	"Bahyph",

	// Barr License
	// https://spdx.org/licenses/Barr.html
	"Barr",

	// Beerware License
	// https://spdx.org/licenses/Beerware.html
	"Beerware",

	// BitTorrent Open Source License v1.0
	// https://spdx.org/licenses/BitTorrent-1.0.html
	"BitTorrent-1.0",

	// BitTorrent Open Source License v1.1
	// https://spdx.org/licenses/BitTorrent-1.1.html
	"BitTorrent-1.1",

	// Bitstream Vera Font License
	// https://spdx.org/licenses/Bitstream-Vera.html
	"Bitstream-Vera",

	// Blue Oak Model License 1.0.0
	// https://spdx.org/licenses/BlueOak-1.0.0.html
	"BlueOak-1.0.0",

	// Borceux license
	// https://spdx.org/licenses/Borceux.html
	"Borceux",

	// Computational Use of Data Agreement v1.0
	// https://spdx.org/licenses/C-UDA-1.0.html
	"C-UDA-1.0",

	// Cryptographic Autonomy License 1.0 (Combined Work Exception)
	// https://spdx.org/licenses/CAL-1.0-Combined-Work-Exception.html
	"CAL-1.0-Combined-Work-Exception",

	// Cryptographic Autonomy License 1.0
	// https://spdx.org/licenses/CAL-1.0.html
	"CAL-1.0",

	// Computer Associates Trusted Open Source License 1.1
	// https://spdx.org/licenses/CATOSL-1.1.html
	"CATOSL-1.1",

	// Creative Commons Attribution 1.0 Generic
	// https://spdx.org/licenses/CC-BY-1.0.html
	"CC-BY-1.0",

	// Creative Commons Attribution 2.0 Generic
	// https://spdx.org/licenses/CC-BY-2.0.html
	"CC-BY-2.0",

	// Creative Commons Attribution 2.5 Australia
	// https://spdx.org/licenses/CC-BY-2.5-AU.html
	"CC-BY-2.5-AU",

	// Creative Commons Attribution 2.5 Generic
	// https://spdx.org/licenses/CC-BY-2.5.html
	"CC-BY-2.5",

	// Creative Commons Attribution 3.0 Austria
	// https://spdx.org/licenses/CC-BY-3.0-AT.html
	"CC-BY-3.0-AT",

	// Creative Commons Attribution 3.0 Germany
	// https://spdx.org/licenses/CC-BY-3.0-DE.html
	"CC-BY-3.0-DE",

	// Creative Commons Attribution 3.0 IGO
	// https://spdx.org/licenses/CC-BY-3.0-IGO.html
	"CC-BY-3.0-IGO",

	// Creative Commons Attribution 3.0 Netherlands
	// https://spdx.org/licenses/CC-BY-3.0-NL.html
	"CC-BY-3.0-NL",

	// Creative Commons Attribution 3.0 United States
	// https://spdx.org/licenses/CC-BY-3.0-US.html
	"CC-BY-3.0-US",

	// Creative Commons Attribution 3.0 Unported
	// https://spdx.org/licenses/CC-BY-3.0.html
	"CC-BY-3.0",

	// Creative Commons Attribution 4.0 International
	// https://spdx.org/licenses/CC-BY-4.0.html
	"CC-BY-4.0",

	// Creative Commons Attribution Non Commercial 1.0 Generic
	// https://spdx.org/licenses/CC-BY-NC-1.0.html
	"CC-BY-NC-1.0",

	// Creative Commons Attribution Non Commercial 2.0 Generic
	// https://spdx.org/licenses/CC-BY-NC-2.0.html
	"CC-BY-NC-2.0",

	// Creative Commons Attribution Non Commercial 2.5 Generic
	// https://spdx.org/licenses/CC-BY-NC-2.5.html
	"CC-BY-NC-2.5",

	// Creative Commons Attribution Non Commercial 3.0 Germany
	// https://spdx.org/licenses/CC-BY-NC-3.0-DE.html
	"CC-BY-NC-3.0-DE",

	// Creative Commons Attribution Non Commercial 3.0 Unported
	// https://spdx.org/licenses/CC-BY-NC-3.0.html
	"CC-BY-NC-3.0",

	// Creative Commons Attribution Non Commercial 4.0 International
	// https://spdx.org/licenses/CC-BY-NC-4.0.html
	"CC-BY-NC-4.0",

	// Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic
	// https://spdx.org/licenses/CC-BY-NC-ND-1.0.html
	"CC-BY-NC-ND-1.0",

	// Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic
	// https://spdx.org/licenses/CC-BY-NC-ND-2.0.html
	"CC-BY-NC-ND-2.0",

	// Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic
	// https://spdx.org/licenses/CC-BY-NC-ND-2.5.html
	"CC-BY-NC-ND-2.5",

	// Creative Commons Attribution Non Commercial No Derivatives 3.0 Germany
	// https://spdx.org/licenses/CC-BY-NC-ND-3.0-DE.html
	"CC-BY-NC-ND-3.0-DE",

	// Creative Commons Attribution Non Commercial No Derivatives 3.0 IGO
	// https://spdx.org/licenses/CC-BY-NC-ND-3.0-IGO.html
	"CC-BY-NC-ND-3.0-IGO",

	// Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported
	// https://spdx.org/licenses/CC-BY-NC-ND-3.0.html
	"CC-BY-NC-ND-3.0",

	// Creative Commons Attribution Non Commercial No Derivatives 4.0 International
	// https://spdx.org/licenses/CC-BY-NC-ND-4.0.html
	"CC-BY-NC-ND-4.0",

	// Creative Commons Attribution Non Commercial Share Alike 1.0 Generic
	// https://spdx.org/licenses/CC-BY-NC-SA-1.0.html
	"CC-BY-NC-SA-1.0",

	// Creative Commons Attribution-NonCommercial-ShareAlike 2.0 France
	// https://spdx.org/licenses/CC-BY-NC-SA-2.0-FR.html
	"CC-BY-NC-SA-2.0-FR",

	// Creative Commons Attribution Non Commercial Share Alike 2.0 England and Wales
	// https://spdx.org/licenses/CC-BY-NC-SA-2.0-UK.html
	"CC-BY-NC-SA-2.0-UK",

	// Creative Commons Attribution Non Commercial Share Alike 2.0 Generic
	// https://spdx.org/licenses/CC-BY-NC-SA-2.0.html
	"CC-BY-NC-SA-2.0",

	// Creative Commons Attribution Non Commercial Share Alike 2.5 Generic
	// https://spdx.org/licenses/CC-BY-NC-SA-2.5.html
	"CC-BY-NC-SA-2.5",

	// Creative Commons Attribution Non Commercial Share Alike 3.0 Germany
	// https://spdx.org/licenses/CC-BY-NC-SA-3.0-DE.html
	"CC-BY-NC-SA-3.0-DE",

	// Creative Commons Attribution Non Commercial Share Alike 3.0 IGO
	// https://spdx.org/licenses/CC-BY-NC-SA-3.0-IGO.html
	"CC-BY-NC-SA-3.0-IGO",

	// Creative Commons Attribution Non Commercial Share Alike 3.0 Unported
	// https://spdx.org/licenses/CC-BY-NC-SA-3.0.html
	"CC-BY-NC-SA-3.0",

	// Creative Commons Attribution Non Commercial Share Alike 4.0 International
	// https://spdx.org/licenses/CC-BY-NC-SA-4.0.html
	"CC-BY-NC-SA-4.0",

	// Creative Commons Attribution No Derivatives 1.0 Generic
	// https://spdx.org/licenses/CC-BY-ND-1.0.html
	"CC-BY-ND-1.0",

	// Creative Commons Attribution No Derivatives 2.0 Generic
	// https://spdx.org/licenses/CC-BY-ND-2.0.html
	"CC-BY-ND-2.0",

	// Creative Commons Attribution No Derivatives 2.5 Generic
	// https://spdx.org/licenses/CC-BY-ND-2.5.html
	"CC-BY-ND-2.5",

	// Creative Commons Attribution No Derivatives 3.0 Germany
	// https://spdx.org/licenses/CC-BY-ND-3.0-DE.html
	"CC-BY-ND-3.0-DE",

	// Creative Commons Attribution No Derivatives 3.0 Unported
	// https://spdx.org/licenses/CC-BY-ND-3.0.html
	"CC-BY-ND-3.0",

	// Creative Commons Attribution No Derivatives 4.0 International
	// https://spdx.org/licenses/CC-BY-ND-4.0.html
	"CC-BY-ND-4.0",

	// Creative Commons Attribution Share Alike 1.0 Generic
	// https://spdx.org/licenses/CC-BY-SA-1.0.html
	"CC-BY-SA-1.0",

	// Creative Commons Attribution Share Alike 2.0 England and Wales
	// https://spdx.org/licenses/CC-BY-SA-2.0-UK.html
	"CC-BY-SA-2.0-UK",

	// Creative Commons Attribution Share Alike 2.0 Generic
	// https://spdx.org/licenses/CC-BY-SA-2.0.html
	"CC-BY-SA-2.0",

	// Creative Commons Attribution Share Alike 2.1 Japan
	// https://spdx.org/licenses/CC-BY-SA-2.1-JP.html
	"CC-BY-SA-2.1-JP",

	// Creative Commons Attribution Share Alike 2.5 Generic
	// https://spdx.org/licenses/CC-BY-SA-2.5.html
	"CC-BY-SA-2.5",

	// Creative Commons Attribution Share Alike 3.0 Austria
	// https://spdx.org/licenses/CC-BY-SA-3.0-AT.html
	"CC-BY-SA-3.0-AT",

	// Creative Commons Attribution Share Alike 3.0 Germany
	// https://spdx.org/licenses/CC-BY-SA-3.0-DE.html
	"CC-BY-SA-3.0-DE",

	// Creative Commons Attribution Share Alike 3.0 Unported
	// https://spdx.org/licenses/CC-BY-SA-3.0.html
	"CC-BY-SA-3.0",

	// Creative Commons Attribution Share Alike 4.0 International
	// https://spdx.org/licenses/CC-BY-SA-4.0.html
	"CC-BY-SA-4.0",

	// Creative Commons Public Domain Dedication and Certification
	// https://spdx.org/licenses/CC-PDDC.html
	"CC-PDDC",

	// Creative Commons Zero v1.0 Universal
	// https://spdx.org/licenses/CC0-1.0.html
	"CC0-1.0",

	// Common Development and Distribution License 1.0
	// https://spdx.org/licenses/CDDL-1.0.html
	"CDDL-1.0",

	// Common Development and Distribution License 1.1
	// https://spdx.org/licenses/CDDL-1.1.html
	"CDDL-1.1",

	// Common Documentation License 1.0
	// https://spdx.org/licenses/CDL-1.0.html
	"CDL-1.0",

	// Community Data License Agreement Permissive 1.0
	// https://spdx.org/licenses/CDLA-Permissive-1.0.html
	"CDLA-Permissive-1.0",

	// Community Data License Agreement Permissive 2.0
	// https://spdx.org/licenses/CDLA-Permissive-2.0.html
	"CDLA-Permissive-2.0",

	// Community Data License Agreement Sharing 1.0
	// https://spdx.org/licenses/CDLA-Sharing-1.0.html
	"CDLA-Sharing-1.0",

	// CeCILL Free Software License Agreement v1.0
	// https://spdx.org/licenses/CECILL-1.0.html
	"CECILL-1.0",

	// CeCILL Free Software License Agreement v1.1
	// https://spdx.org/licenses/CECILL-1.1.html
	"CECILL-1.1",

	// CeCILL Free Software License Agreement v2.0
	// https://spdx.org/licenses/CECILL-2.0.html
	"CECILL-2.0",

	// CeCILL Free Software License Agreement v2.1
	// https://spdx.org/licenses/CECILL-2.1.html
	"CECILL-2.1",

	// CeCILL-B Free Software License Agreement
	// https://spdx.org/licenses/CECILL-B.html
	"CECILL-B",

	// CeCILL-C Free Software License Agreement
	// https://spdx.org/licenses/CECILL-C.html
	"CECILL-C",

	// CERN Open Hardware Licence v1.1
	// https://spdx.org/licenses/CERN-OHL-1.1.html
	"CERN-OHL-1.1",

	// CERN Open Hardware Licence v1.2
	// https://spdx.org/licenses/CERN-OHL-1.2.html
	"CERN-OHL-1.2",

	// CERN Open Hardware Licence Version 2 - Permissive
	// https://spdx.org/licenses/CERN-OHL-P-2.0.html
	"CERN-OHL-P-2.0",

	// CERN Open Hardware Licence Version 2 - Strongly Reciprocal
	// https://spdx.org/licenses/CERN-OHL-S-2.0.html
	"CERN-OHL-S-2.0",

	// CERN Open Hardware Licence Version 2 - Weakly Reciprocal
	// https://spdx.org/licenses/CERN-OHL-W-2.0.html
	"CERN-OHL-W-2.0",

	// CNRI Jython License
	// https://spdx.org/licenses/CNRI-Jython.html
	"CNRI-Jython",

	// CNRI Python Open Source GPL Compatible License Agreement
	// https://spdx.org/licenses/CNRI-Python-GPL-Compatible.html
	"CNRI-Python-GPL-Compatible",

	// CNRI Python License
	// https://spdx.org/licenses/CNRI-Python.html
	"CNRI-Python",

	// Copyfree Open Innovation License
	// https://spdx.org/licenses/COIL-1.0.html
	"COIL-1.0",

	// Common Public Attribution License 1.0
	// https://spdx.org/licenses/CPAL-1.0.html
	"CPAL-1.0",

	// Common Public License 1.0
	// https://spdx.org/licenses/CPL-1.0.html
	"CPL-1.0",

	// Code Project Open License 1.02
	// https://spdx.org/licenses/CPOL-1.02.html
	"CPOL-1.02",

	// CUA Office Public License v1.0
	// https://spdx.org/licenses/CUA-OPL-1.0.html
	"CUA-OPL-1.0",

	// Caldera License
	// https://spdx.org/licenses/Caldera.html
	"Caldera",

	// Clarified Artistic License
	// https://spdx.org/licenses/ClArtistic.html
	"ClArtistic",

	// Community Specification License 1.0
	// https://spdx.org/licenses/Community-Spec-1.0.html
	"Community-Spec-1.0",

	// Condor Public License v1.1
	// https://spdx.org/licenses/Condor-1.1.html
	"Condor-1.1",

	// Crossword License
	// https://spdx.org/licenses/Crossword.html
	"Crossword",

	// CrystalStacker License
	// https://spdx.org/licenses/CrystalStacker.html
	"CrystalStacker",

	// Cube License
	// https://spdx.org/licenses/Cube.html
	"Cube",

	// Deutsche Freie Software Lizenz
	// https://spdx.org/licenses/D-FSL-1.0.html
	"D-FSL-1.0",

	// Data licence Germany – attribution – version 2.0
	// https://spdx.org/licenses/DL-DE-BY-2.0.html
	"DL-DE-BY-2.0",

	// DOC License
	// https://spdx.org/licenses/DOC.html
	"DOC",

	// Detection Rule License 1.0
	// https://spdx.org/licenses/DRL-1.0.html
	"DRL-1.0",

	// DSDP License
	// https://spdx.org/licenses/DSDP.html
	"DSDP",

	// Dotseqn License
	// https://spdx.org/licenses/Dotseqn.html
	"Dotseqn",

	// Educational Community License v1.0
	// https://spdx.org/licenses/ECL-1.0.html
	"ECL-1.0",

	// Educational Community License v2.0
	// https://spdx.org/licenses/ECL-2.0.html
	"ECL-2.0",

	// Eiffel Forum License v1.0
	// https://spdx.org/licenses/EFL-1.0.html
	"EFL-1.0",

	// Eiffel Forum License v2.0
	// https://spdx.org/licenses/EFL-2.0.html
	"EFL-2.0",

	// EPICS Open License
	// https://spdx.org/licenses/EPICS.html
	"EPICS",

	// Eclipse Public License 1.0
	// https://spdx.org/licenses/EPL-1.0.html
	"EPL-1.0",

	// Eclipse Public License 2.0
	// https://spdx.org/licenses/EPL-2.0.html
	"EPL-2.0",

	// EU DataGrid Software License
	// https://spdx.org/licenses/EUDatagrid.html
	"EUDatagrid",

	// European Union Public License 1.0
	// https://spdx.org/licenses/EUPL-1.0.html
	"EUPL-1.0",

	// European Union Public License 1.1
	// https://spdx.org/licenses/EUPL-1.1.html
	"EUPL-1.1",

	// European Union Public License 1.2
	// https://spdx.org/licenses/EUPL-1.2.html
	"EUPL-1.2",

	// Elastic License 2.0
	// https://spdx.org/licenses/Elastic-2.0.html
	"Elastic-2.0",

	// Entessa Public License v1.0
	// https://spdx.org/licenses/Entessa.html
	"Entessa",

	// Erlang Public License v1.1
	// https://spdx.org/licenses/ErlPL-1.1.html
	"ErlPL-1.1",

	// Eurosym License
	// https://spdx.org/licenses/Eurosym.html
	"Eurosym",

	// Fraunhofer FDK AAC Codec Library
	// https://spdx.org/licenses/FDK-AAC.html
	"FDK-AAC",

	// FSF All Permissive License
	// https://spdx.org/licenses/FSFAP.html
	"FSFAP",

	// FSF Unlimited License
	// https://spdx.org/licenses/FSFUL.html
	"FSFUL",

	// FSF Unlimited License (with License Retention)
	// https://spdx.org/licenses/FSFULLR.html
	"FSFULLR",

	// Freetype Project License
	// https://spdx.org/licenses/FTL.html
	"FTL",

	// Fair License
	// https://spdx.org/licenses/Fair.html
	"Fair",

	// Frameworx Open License 1.0
	// https://spdx.org/licenses/Frameworx-1.0.html
	"Frameworx-1.0",

	// FreeBSD Documentation License
	// https://spdx.org/licenses/FreeBSD-DOC.html
	"FreeBSD-DOC",

	// FreeImage Public License v1.0
	// https://spdx.org/licenses/FreeImage.html
	"FreeImage",

	// GD License
	// https://spdx.org/licenses/GD.html
	"GD",

	// GNU Free Documentation License v1.1 only - invariants
	// https://spdx.org/licenses/GFDL-1.1-invariants-only.html
	"GFDL-1.1-invariants-only",

	// GNU Free Documentation License v1.1 or later - invariants
	// https://spdx.org/licenses/GFDL-1.1-invariants-or-later.html
	"GFDL-1.1-invariants-or-later",

	// GNU Free Documentation License v1.1 only - no invariants
	// https://spdx.org/licenses/GFDL-1.1-no-invariants-only.html
	"GFDL-1.1-no-invariants-only",

	// GNU Free Documentation License v1.1 or later - no invariants
	// https://spdx.org/licenses/GFDL-1.1-no-invariants-or-later.html
	"GFDL-1.1-no-invariants-or-later",

	// GNU Free Documentation License v1.1 only
	// https://spdx.org/licenses/GFDL-1.1-only.html
	"GFDL-1.1-only",

	// GNU Free Documentation License v1.1 or later
	// https://spdx.org/licenses/GFDL-1.1-or-later.html
	"GFDL-1.1-or-later",

	// GNU Free Documentation License v1.2 only - invariants
	// https://spdx.org/licenses/GFDL-1.2-invariants-only.html
	"GFDL-1.2-invariants-only",

	// GNU Free Documentation License v1.2 or later - invariants
	// https://spdx.org/licenses/GFDL-1.2-invariants-or-later.html
	"GFDL-1.2-invariants-or-later",

	// GNU Free Documentation License v1.2 only - no invariants
	// https://spdx.org/licenses/GFDL-1.2-no-invariants-only.html
	"GFDL-1.2-no-invariants-only",

	// GNU Free Documentation License v1.2 or later - no invariants
	// https://spdx.org/licenses/GFDL-1.2-no-invariants-or-later.html
	"GFDL-1.2-no-invariants-or-later",

	// GNU Free Documentation License v1.2 only
	// https://spdx.org/licenses/GFDL-1.2-only.html
	"GFDL-1.2-only",

	// GNU Free Documentation License v1.2 or later
	// https://spdx.org/licenses/GFDL-1.2-or-later.html
	"GFDL-1.2-or-later",

	// GNU Free Documentation License v1.3 only - invariants
	// https://spdx.org/licenses/GFDL-1.3-invariants-only.html
	"GFDL-1.3-invariants-only",

	// GNU Free Documentation License v1.3 or later - invariants
	// https://spdx.org/licenses/GFDL-1.3-invariants-or-later.html
	"GFDL-1.3-invariants-or-later",

	// GNU Free Documentation License v1.3 only - no invariants
	// https://spdx.org/licenses/GFDL-1.3-no-invariants-only.html
	"GFDL-1.3-no-invariants-only",

	// GNU Free Documentation License v1.3 or later - no invariants
	// https://spdx.org/licenses/GFDL-1.3-no-invariants-or-later.html
	"GFDL-1.3-no-invariants-or-later",

	// GNU Free Documentation License v1.3 only
	// https://spdx.org/licenses/GFDL-1.3-only.html
	"GFDL-1.3-only",

	// GNU Free Documentation License v1.3 or later
	// https://spdx.org/licenses/GFDL-1.3-or-later.html
	"GFDL-1.3-or-later",

	// GL2PS License
	// https://spdx.org/licenses/GL2PS.html
	"GL2PS",

	// Good Luck With That Public License
	// https://spdx.org/licenses/GLWTPL.html
	"GLWTPL",

	// GNU General Public License v1.0 only
	// https://spdx.org/licenses/GPL-1.0-only.html
	"GPL-1.0-only",

	// GNU General Public License v1.0 or later
	// https://spdx.org/licenses/GPL-1.0-or-later.html
	"GPL-1.0-or-later",

	// GNU General Public License v2.0 only
	// https://spdx.org/licenses/GPL-2.0-only.html
	"GPL-2.0-only",

	// GNU General Public License v2.0 or later
	// https://spdx.org/licenses/GPL-2.0-or-later.html
	"GPL-2.0-or-later",

	// GNU General Public License v3.0 only
	// https://spdx.org/licenses/GPL-3.0-only.html
	"GPL-3.0-only",

	// GNU General Public License v3.0 or later
	// https://spdx.org/licenses/GPL-3.0-or-later.html
	"GPL-3.0-or-later",

	// Giftware License
	// https://spdx.org/licenses/Giftware.html
	"Giftware",

	// 3dfx Glide License
	// https://spdx.org/licenses/Glide.html
	"Glide",

	// Glulxe License
	// https://spdx.org/licenses/Glulxe.html
	"Glulxe",

	// Historical Permission Notice and Disclaimer - sell variant
	// https://spdx.org/licenses/HPND-sell-variant.html
	"HPND-sell-variant",

	// Historical Permission Notice and Disclaimer
	// https://spdx.org/licenses/HPND.html
	"HPND",

	// HTML Tidy License
	// https://spdx.org/licenses/HTMLTIDY.html
	"HTMLTIDY",

	// Haskell Language Report License
	// https://spdx.org/licenses/HaskellReport.html
	"HaskellReport",

	// Hippocratic License 2.1
	// https://spdx.org/licenses/Hippocratic-2.1.html
	"Hippocratic-2.1",

	// IBM PowerPC Initialization and Boot Software
	// https://spdx.org/licenses/IBM-pibs.html
	"IBM-pibs",

	// ICU License
	// https://spdx.org/licenses/ICU.html
	"ICU",

	// Independent JPEG Group License
	// https://spdx.org/licenses/IJG.html
	"IJG",

	// IPA Font License
	// https://spdx.org/licenses/IPA.html
	"IPA",

	// IBM Public License v1.0
	// https://spdx.org/licenses/IPL-1.0.html
	"IPL-1.0",

	// ISC License
	// https://spdx.org/licenses/ISC.html
	"ISC",

	// ImageMagick License
	// https://spdx.org/licenses/ImageMagick.html
	"ImageMagick",

	// Imlib2 License
	// https://spdx.org/licenses/Imlib2.html
	"Imlib2",

	// Info-ZIP License
	// https://spdx.org/licenses/Info-ZIP.html
	"Info-ZIP",

	// Intel ACPI Software License Agreement
	// https://spdx.org/licenses/Intel-ACPI.html
	"Intel-ACPI",

	// Intel Open Source License
	// https://spdx.org/licenses/Intel.html
	"Intel",

	// Interbase Public License v1.0
	// https://spdx.org/licenses/Interbase-1.0.html
	"Interbase-1.0",

	// Japan Network Information Center License
	// https://spdx.org/licenses/JPNIC.html
	"JPNIC",

	// JSON License
	// https://spdx.org/licenses/JSON.html
	"JSON",

	// Jam License
	// https://spdx.org/licenses/Jam.html
	"Jam",

	// JasPer License
	// https://spdx.org/licenses/JasPer-2.0.html
	"JasPer-2.0",

	// Licence Art Libre 1.2
	// https://spdx.org/licenses/LAL-1.2.html
	"LAL-1.2",

	// Licence Art Libre 1.3
	// https://spdx.org/licenses/LAL-1.3.html
	"LAL-1.3",

	// GNU Library General Public License v2 only
	// https://spdx.org/licenses/LGPL-2.0-only.html
	"LGPL-2.0-only",

	// GNU Library General Public License v2 or later
	// https://spdx.org/licenses/LGPL-2.0-or-later.html
	"LGPL-2.0-or-later",

	// GNU Lesser General Public License v2.1 only
	// https://spdx.org/licenses/LGPL-2.1-only.html
	"LGPL-2.1-only",

	// GNU Lesser General Public License v2.1 or later
	// https://spdx.org/licenses/LGPL-2.1-or-later.html
	"LGPL-2.1-or-later",

	// GNU Lesser General Public License v3.0 only
	// https://spdx.org/licenses/LGPL-3.0-only.html
	"LGPL-3.0-only",

	// GNU Lesser General Public License v3.0 or later
	// https://spdx.org/licenses/LGPL-3.0-or-later.html
	"LGPL-3.0-or-later",

	// Lesser General Public License For Linguistic Resources
	// https://spdx.org/licenses/LGPLLR.html
	"LGPLLR",

	// Lucent Public License Version 1.0
	// https://spdx.org/licenses/LPL-1.0.html
	"LPL-1.0",

	// Lucent Public License v1.02
	// https://spdx.org/licenses/LPL-1.02.html
	"LPL-1.02",

	// LaTeX Project Public License v1.0
	// https://spdx.org/licenses/LPPL-1.0.html
	"LPPL-1.0",

	// LaTeX Project Public License v1.1
	// https://spdx.org/licenses/LPPL-1.1.html
	"LPPL-1.1",

	// LaTeX Project Public License v1.2
	// https://spdx.org/licenses/LPPL-1.2.html
	"LPPL-1.2",

	// LaTeX Project Public License v1.3a
	// https://spdx.org/licenses/LPPL-1.3a.html
	"LPPL-1.3a",

	// LaTeX Project Public License v1.3c
	// https://spdx.org/licenses/LPPL-1.3c.html
	"LPPL-1.3c",

	// LZMA SDK License (versions 9.11 to 9.20)
	// https://spdx.org/licenses/LZMA-SDK-9.11-to-9.20.html
	"LZMA-SDK-9.11-to-9.20",

	// LZMA SDK License (versions 9.22 and beyond)
	// https://spdx.org/licenses/LZMA-SDK-9.22.html
	"LZMA-SDK-9.22",

	// Latex2e License
	// https://spdx.org/licenses/Latex2e.html
	"Latex2e",

	// Leptonica License
	// https://spdx.org/licenses/Leptonica.html
	"Leptonica",

	// Licence Libre du Québec – Permissive version 1.1
	// https://spdx.org/licenses/LiLiQ-P-1.1.html
	"LiLiQ-P-1.1",

	// Licence Libre du Québec – Réciprocité version 1.1
	// https://spdx.org/licenses/LiLiQ-R-1.1.html
	"LiLiQ-R-1.1",

	// Licence Libre du Québec – Réciprocité forte version 1.1
	// https://spdx.org/licenses/LiLiQ-Rplus-1.1.html
	"LiLiQ-Rplus-1.1",

	// libpng License
	// https://spdx.org/licenses/Libpng.html
	"Libpng",

	// Linux Kernel Variant of OpenIB.org license
	// https://spdx.org/licenses/Linux-OpenIB.html
	"Linux-OpenIB",

	// Linux man-pages Copyleft
	// https://spdx.org/licenses/Linux-man-pages-copyleft.html
	"Linux-man-pages-copyleft",

	// MIT No Attribution
	// https://spdx.org/licenses/MIT-0.html
	"MIT-0",

	// CMU License
	// https://spdx.org/licenses/MIT-CMU.html
	"MIT-CMU",

	// MIT License Modern Variant
	// https://spdx.org/licenses/MIT-Modern-Variant.html
	"MIT-Modern-Variant",

	// Enlightenment License (e16)
	// https://spdx.org/licenses/MIT-advertising.html
	"MIT-advertising",

	// enna License
	// https://spdx.org/licenses/MIT-enna.html
	"MIT-enna",

	// feh License
	// https://spdx.org/licenses/MIT-feh.html
	"MIT-feh",

	// MIT Open Group variant
	// https://spdx.org/licenses/MIT-open-group.html
	"MIT-open-group",

	// MIT License
	// https://spdx.org/licenses/MIT.html
	"MIT",

	// MIT +no-false-attribs license
	// https://spdx.org/licenses/MITNFA.html
	"MITNFA",

	// Mozilla Public License 1.0
	// https://spdx.org/licenses/MPL-1.0.html
	"MPL-1.0",

	// Mozilla Public License 1.1
	// https://spdx.org/licenses/MPL-1.1.html
	"MPL-1.1",

	// Mozilla Public License 2.0 (no copyleft exception)
	// https://spdx.org/licenses/MPL-2.0-no-copyleft-exception.html
	"MPL-2.0-no-copyleft-exception",

	// Mozilla Public License 2.0
	// https://spdx.org/licenses/MPL-2.0.html
	"MPL-2.0",

	// Microsoft Limited Public License
	// https://spdx.org/licenses/MS-LPL.html
	"MS-LPL",

	// Microsoft Public License
	// https://spdx.org/licenses/MS-PL.html
	"MS-PL",

	// Microsoft Reciprocal License
	// https://spdx.org/licenses/MS-RL.html
	"MS-RL",

	// Matrix Template Library License
	// https://spdx.org/licenses/MTLL.html
	"MTLL",

	// MakeIndex License
	// https://spdx.org/licenses/MakeIndex.html
	"MakeIndex",

	// Minpack License
	// https://spdx.org/licenses/Minpack.html
	"Minpack",

	// The MirOS Licence
	// https://spdx.org/licenses/MirOS.html
	"MirOS",

	// Motosoto License
	// https://spdx.org/licenses/Motosoto.html
	"Motosoto",

	// Mulan Permissive Software License, Version 1
	// https://spdx.org/licenses/MulanPSL-1.0.html
	"MulanPSL-1.0",

	// Mulan Permissive Software License, Version 2
	// https://spdx.org/licenses/MulanPSL-2.0.html
	"MulanPSL-2.0",

	// Multics License
	// https://spdx.org/licenses/Multics.html
	"Multics",

	// Mup License
	// https://spdx.org/licenses/Mup.html
	"Mup",

	// Nara Institute of Science and Technology License (2003)
	// https://spdx.org/licenses/NAIST-2003.html
	"NAIST-2003",

	// NASA Open Source Agreement 1.3
	// https://spdx.org/licenses/NASA-1.3.html
	"NASA-1.3",

	// Net Boolean Public License v1
	// https://spdx.org/licenses/NBPL-1.0.html
	"NBPL-1.0",

	// Non-Commercial Government Licence
	// https://spdx.org/licenses/NCGL-UK-2.0.html
	"NCGL-UK-2.0",

	// University of Illinois/NCSA Open Source License
	// https://spdx.org/licenses/NCSA.html
	"NCSA",

	// Nethack General Public License
	// https://spdx.org/licenses/NGPL.html
	"NGPL",

	// NICTA Public Software License, Version 1.0
	// https://spdx.org/licenses/NICTA-1.0.html
	"NICTA-1.0",

	// NIST Public Domain Notice with license fallback
	// https://spdx.org/licenses/NIST-PD-fallback.html
	"NIST-PD-fallback",

	// NIST Public Domain Notice
	// https://spdx.org/licenses/NIST-PD.html
	"NIST-PD",

	// Norwegian Licence for Open Government Data (NLOD) 1.0
	// https://spdx.org/licenses/NLOD-1.0.html
	"NLOD-1.0",

	// Norwegian Licence for Open Government Data (NLOD) 2.0
	// https://spdx.org/licenses/NLOD-2.0.html
	"NLOD-2.0",

	// No Limit Public License
	// https://spdx.org/licenses/NLPL.html
	"NLPL",

	// Netizen Open Source License
	// https://spdx.org/licenses/NOSL.html
	"NOSL",

	// Netscape Public License v1.0
	// https://spdx.org/licenses/NPL-1.0.html
	"NPL-1.0",

	// Netscape Public License v1.1
	// https://spdx.org/licenses/NPL-1.1.html
	"NPL-1.1",

	// Non-Profit Open Software License 3.0
	// https://spdx.org/licenses/NPOSL-3.0.html
	"NPOSL-3.0",

	// NRL License
	// https://spdx.org/licenses/NRL.html
	"NRL",

	// NTP No Attribution
	// https://spdx.org/licenses/NTP-0.html
	"NTP-0",

	// NTP License
	// https://spdx.org/licenses/NTP.html
	"NTP",

	// Naumen Public License
	// https://spdx.org/licenses/Naumen.html
	"Naumen",

	// Net-SNMP License
	// https://spdx.org/licenses/Net-SNMP.html
	"Net-SNMP",

	// NetCDF license
	// https://spdx.org/licenses/NetCDF.html
	"NetCDF",

	// Newsletr License
	// https://spdx.org/licenses/Newsletr.html
	"Newsletr",

	// Nokia Open Source License
	// https://spdx.org/licenses/Nokia.html
	"Nokia",

	// Noweb License
	// https://spdx.org/licenses/Noweb.html
	"Noweb",

	// Open Use of Data Agreement v1.0
	// https://spdx.org/licenses/O-UDA-1.0.html
	"O-UDA-1.0",

	// Open CASCADE Technology Public License
	// https://spdx.org/licenses/OCCT-PL.html
	"OCCT-PL",

	// OCLC Research Public License 2.0
	// https://spdx.org/licenses/OCLC-2.0.html
	"OCLC-2.0",

	// Open Data Commons Attribution License v1.0
	// https://spdx.org/licenses/ODC-By-1.0.html
	"ODC-By-1.0",

	// Open Data Commons Open Database License v1.0
	// https://spdx.org/licenses/ODbL-1.0.html
	"ODbL-1.0",

	// SIL Open Font License 1.0 with Reserved Font Name
	// https://spdx.org/licenses/OFL-1.0-RFN.html
	"OFL-1.0-RFN",

	// SIL Open Font License 1.0 with no Reserved Font Name
	// https://spdx.org/licenses/OFL-1.0-no-RFN.html
	"OFL-1.0-no-RFN",

	// SIL Open Font License 1.0
	// https://spdx.org/licenses/OFL-1.0.html
	"OFL-1.0",

	// SIL Open Font License 1.1 with Reserved Font Name
	// https://spdx.org/licenses/OFL-1.1-RFN.html
	"OFL-1.1-RFN",

	// SIL Open Font License 1.1 with no Reserved Font Name
	// https://spdx.org/licenses/OFL-1.1-no-RFN.html
	"OFL-1.1-no-RFN",

	// SIL Open Font License 1.1
	// https://spdx.org/licenses/OFL-1.1.html
	"OFL-1.1",

	// OGC Software License, Version 1.0
	// https://spdx.org/licenses/OGC-1.0.html
	"OGC-1.0",

	// Taiwan Open Government Data License, version 1.0
	// https://spdx.org/licenses/OGDL-Taiwan-1.0.html
	"OGDL-Taiwan-1.0",

	// Open Government Licence - Canada
	// https://spdx.org/licenses/OGL-Canada-2.0.html
	"OGL-Canada-2.0",

	// Open Government Licence v1.0
	// https://spdx.org/licenses/OGL-UK-1.0.html
	"OGL-UK-1.0",

	// Open Government Licence v2.0
	// https://spdx.org/licenses/OGL-UK-2.0.html
	"OGL-UK-2.0",

	// Open Government Licence v3.0
	// https://spdx.org/licenses/OGL-UK-3.0.html
	"OGL-UK-3.0",

	// Open Group Test Suite License
	// https://spdx.org/licenses/OGTSL.html
	"OGTSL",

	// Open LDAP Public License v1.1
	// https://spdx.org/licenses/OLDAP-1.1.html
	"OLDAP-1.1",

	// Open LDAP Public License v1.2
	// https://spdx.org/licenses/OLDAP-1.2.html
	"OLDAP-1.2",

	// Open LDAP Public License v1.3
	// https://spdx.org/licenses/OLDAP-1.3.html
	"OLDAP-1.3",

	// Open LDAP Public License v1.4
	// https://spdx.org/licenses/OLDAP-1.4.html
	"OLDAP-1.4",

	// Open LDAP Public License v2.0.1
	// https://spdx.org/licenses/OLDAP-2.0.1.html
	"OLDAP-2.0.1",

	// Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B)
	// https://spdx.org/licenses/OLDAP-2.0.html
	"OLDAP-2.0",

	// Open LDAP Public License v2.1
	// https://spdx.org/licenses/OLDAP-2.1.html
	"OLDAP-2.1",

	// Open LDAP Public License v2.2.1
	// https://spdx.org/licenses/OLDAP-2.2.1.html
	"OLDAP-2.2.1",

	// Open LDAP Public License 2.2.2
	// https://spdx.org/licenses/OLDAP-2.2.2.html
	"OLDAP-2.2.2",

	// Open LDAP Public License v2.2
	// https://spdx.org/licenses/OLDAP-2.2.html
	"OLDAP-2.2",

	// Open LDAP Public License v2.3
	// https://spdx.org/licenses/OLDAP-2.3.html
	"OLDAP-2.3",

	// Open LDAP Public License v2.4
	// https://spdx.org/licenses/OLDAP-2.4.html
	"OLDAP-2.4",

	// Open LDAP Public License v2.5
	// https://spdx.org/licenses/OLDAP-2.5.html
	"OLDAP-2.5",

	// Open LDAP Public License v2.6
	// https://spdx.org/licenses/OLDAP-2.6.html
	"OLDAP-2.6",

	// Open LDAP Public License v2.7
	// https://spdx.org/licenses/OLDAP-2.7.html
	"OLDAP-2.7",

	// Open LDAP Public License v2.8
	// https://spdx.org/licenses/OLDAP-2.8.html
	"OLDAP-2.8",

	// Open Market License
	// https://spdx.org/licenses/OML.html
	"OML",

	// Open Public License v1.0
	// https://spdx.org/licenses/OPL-1.0.html
	"OPL-1.0",

	// Open Publication License v1.0
	// https://spdx.org/licenses/OPUBL-1.0.html
	"OPUBL-1.0",

	// OSET Public License version 2.1
	// https://spdx.org/licenses/OSET-PL-2.1.html
	"OSET-PL-2.1",

	// Open Software License 1.0
	// https://spdx.org/licenses/OSL-1.0.html
	"OSL-1.0",

	// Open Software License 1.1
	// https://spdx.org/licenses/OSL-1.1.html
	"OSL-1.1",

	// Open Software License 2.0
	// https://spdx.org/licenses/OSL-2.0.html
	"OSL-2.0",

	// Open Software License 2.1
	// https://spdx.org/licenses/OSL-2.1.html
	"OSL-2.1",

	// Open Software License 3.0
	// https://spdx.org/licenses/OSL-3.0.html
	"OSL-3.0",

	// OpenSSL License
	// https://spdx.org/licenses/OpenSSL.html
	"OpenSSL",

	// Open Data Commons Public Domain Dedication & License 1.0
	// https://spdx.org/licenses/PDDL-1.0.html
	"PDDL-1.0",

	// PHP License v3.0
	// https://spdx.org/licenses/PHP-3.0.html
	"PHP-3.0",

	// PHP License v3.01
	// https://spdx.org/licenses/PHP-3.01.html
	"PHP-3.01",

	// Python Software Foundation License 2.0
	// https://spdx.org/licenses/PSF-2.0.html
	"PSF-2.0",

	// The Parity Public License 6.0.0
	// https://spdx.org/licenses/Parity-6.0.0.html
	"Parity-6.0.0",

	// The Parity Public License 7.0.0
	// https://spdx.org/licenses/Parity-7.0.0.html
	"Parity-7.0.0",

	// Plexus Classworlds License
	// https://spdx.org/licenses/Plexus.html
	"Plexus",

	// PolyForm Noncommercial License 1.0.0
	// https://spdx.org/licenses/PolyForm-Noncommercial-1.0.0.html
	"PolyForm-Noncommercial-1.0.0",

	// PolyForm Small Business License 1.0.0
	// https://spdx.org/licenses/PolyForm-Small-Business-1.0.0.html
	"PolyForm-Small-Business-1.0.0",

	// PostgreSQL License
	// https://spdx.org/licenses/PostgreSQL.html
	"PostgreSQL",

	// Python License 2.0.1
	// https://spdx.org/licenses/Python-2.0.1.html
	"Python-2.0.1",

	// Python License 2.0
	// https://spdx.org/licenses/Python-2.0.html
	"Python-2.0",

	// Q Public License 1.0
	// https://spdx.org/licenses/QPL-1.0.html
	"QPL-1.0",

	// Qhull License
	// https://spdx.org/licenses/Qhull.html
	"Qhull",

	// Red Hat eCos Public License v1.1
	// https://spdx.org/licenses/RHeCos-1.1.html
	"RHeCos-1.1",

	// Reciprocal Public License 1.1
	// https://spdx.org/licenses/RPL-1.1.html
	"RPL-1.1",

	// Reciprocal Public License 1.5
	// https://spdx.org/licenses/RPL-1.5.html
	"RPL-1.5",

	// RealNetworks Public Source License v1.0
	// https://spdx.org/licenses/RPSL-1.0.html
	"RPSL-1.0",

	// RSA Message-Digest License
	// https://spdx.org/licenses/RSA-MD.html
	"RSA-MD",

	// Ricoh Source Code Public License
	// https://spdx.org/licenses/RSCPL.html
	"RSCPL",

	// Rdisc License
	// https://spdx.org/licenses/Rdisc.html
	"Rdisc",

	// Ruby License
	// https://spdx.org/licenses/Ruby.html
	"Ruby",

	// Sax Public Domain Notice
	// https://spdx.org/licenses/SAX-PD.html
	"SAX-PD",

	// SCEA Shared Source License
	// https://spdx.org/licenses/SCEA.html
	"SCEA",

	// SGI Free Software License B v1.0
	// https://spdx.org/licenses/SGI-B-1.0.html
	"SGI-B-1.0",

	// SGI Free Software License B v1.1
	// https://spdx.org/licenses/SGI-B-1.1.html
	"SGI-B-1.1",

	// SGI Free Software License B v2.0
	// https://spdx.org/licenses/SGI-B-2.0.html
	"SGI-B-2.0",

	// Solderpad Hardware License v0.5
	// https://spdx.org/licenses/SHL-0.5.html
	"SHL-0.5",

	// Solderpad Hardware License, Version 0.51
	// https://spdx.org/licenses/SHL-0.51.html
	"SHL-0.51",

	// Sun Industry Standards Source License v1.2
	// https://spdx.org/licenses/SISSL-1.2.html
	"SISSL-1.2",

	// Sun Industry Standards Source License v1.1
	// https://spdx.org/licenses/SISSL.html
	"SISSL",

	// Standard ML of New Jersey License
	// https://spdx.org/licenses/SMLNJ.html
	"SMLNJ",

	// Secure Messaging Protocol Public License
	// https://spdx.org/licenses/SMPPL.html
	"SMPPL",

	// SNIA Public License 1.1
	// https://spdx.org/licenses/SNIA.html
	"SNIA",

	// Sun Public License v1.0
	// https://spdx.org/licenses/SPL-1.0.html
	"SPL-1.0",

	// SSH OpenSSH license
	// https://spdx.org/licenses/SSH-OpenSSH.html
	"SSH-OpenSSH",

	// SSH short notice
	// https://spdx.org/licenses/SSH-short.html
	"SSH-short",

	// Server Side Public License, v 1
	// https://spdx.org/licenses/SSPL-1.0.html
	"SSPL-1.0",

	// Scheme Widget Library (SWL) Software License Agreement
	// https://spdx.org/licenses/SWL.html
	"SWL",

	// Saxpath License
	// https://spdx.org/licenses/Saxpath.html
	"Saxpath",

	// Scheme Language Report License
	// https://spdx.org/licenses/SchemeReport.html
	"SchemeReport",

	// Sendmail License 8.23
	// https://spdx.org/licenses/Sendmail-8.23.html
	"Sendmail-8.23",

	// Sendmail License
	// https://spdx.org/licenses/Sendmail.html
	"Sendmail",

	// Simple Public License 2.0
	// https://spdx.org/licenses/SimPL-2.0.html
	"SimPL-2.0",

	// Sleepycat License
	// https://spdx.org/licenses/Sleepycat.html
	"Sleepycat",

	// Spencer License 86
	// https://spdx.org/licenses/Spencer-86.html
	"Spencer-86",

	// Spencer License 94
	// https://spdx.org/licenses/Spencer-94.html
	"Spencer-94",

	// Spencer License 99
	// https://spdx.org/licenses/Spencer-99.html
	"Spencer-99",

	// SugarCRM Public License v1.1.3
	// https://spdx.org/licenses/SugarCRM-1.1.3.html
	"SugarCRM-1.1.3",

	// TAPR Open Hardware License v1.0
	// https://spdx.org/licenses/TAPR-OHL-1.0.html
	"TAPR-OHL-1.0",

	// TCL/TK License
	// https://spdx.org/licenses/TCL.html
	"TCL",

	// TCP Wrappers License
	// https://spdx.org/licenses/TCP-wrappers.html
	"TCP-wrappers",

	// TMate Open Source License
	// https://spdx.org/licenses/TMate.html
	"TMate",

	// TORQUE v2.5+ Software License v1.1
	// https://spdx.org/licenses/TORQUE-1.1.html
	"TORQUE-1.1",

	// Trusster Open Source License
	// https://spdx.org/licenses/TOSL.html
	"TOSL",

	// Technische Universitaet Berlin License 1.0
	// https://spdx.org/licenses/TU-Berlin-1.0.html
	"TU-Berlin-1.0",

	// Technische Universitaet Berlin License 2.0
	// https://spdx.org/licenses/TU-Berlin-2.0.html
	"TU-Berlin-2.0",

	// Upstream Compatibility License v1.0
	// https://spdx.org/licenses/UCL-1.0.html
	"UCL-1.0",

	// Universal Permissive License v1.0
	// https://spdx.org/licenses/UPL-1.0.html
	"UPL-1.0",

	// Unicode License Agreement - Data Files and Software (2015)
	// https://spdx.org/licenses/Unicode-DFS-2015.html
	"Unicode-DFS-2015",

	// Unicode License Agreement - Data Files and Software (2016)
	// https://spdx.org/licenses/Unicode-DFS-2016.html
	"Unicode-DFS-2016",

	// Unicode Terms of Use
	// https://spdx.org/licenses/Unicode-TOU.html
	"Unicode-TOU",

	// The Unlicense
	// https://spdx.org/licenses/Unlicense.html
	"Unlicense",

	// VOSTROM Public License for Open Source
	// https://spdx.org/licenses/VOSTROM.html
	"VOSTROM",

	// Vovida Software License v1.0
	// https://spdx.org/licenses/VSL-1.0.html
	"VSL-1.0",

	// Vim License
	// https://spdx.org/licenses/Vim.html
	"Vim",

	// W3C Software Notice and License (1998-07-20)
	// https://spdx.org/licenses/W3C-19980720.html
	"W3C-19980720",

	// W3C Software Notice and Document License (2015-05-13)
	// https://spdx.org/licenses/W3C-20150513.html
	"W3C-20150513",

	// W3C Software Notice and License (2002-12-31)
	// https://spdx.org/licenses/W3C.html
	"W3C",

	// Do What The F*ck You Want To Public License
	// https://spdx.org/licenses/WTFPL.html
	"WTFPL",

	// Sybase Open Watcom Public License 1.0
	// https://spdx.org/licenses/Watcom-1.0.html
	"Watcom-1.0",

	// Wsuipa License
	// https://spdx.org/licenses/Wsuipa.html
	"Wsuipa",

	// X11 License Distribution Modification Variant
	// https://spdx.org/licenses/X11-distribute-modifications-variant.html
	"X11-distribute-modifications-variant",

	// X11 License
	// https://spdx.org/licenses/X11.html
	"X11",

	// XFree86 License 1.1
	// https://spdx.org/licenses/XFree86-1.1.html
	"XFree86-1.1",

	// XSkat License
	// https://spdx.org/licenses/XSkat.html
	"XSkat",

	// Xerox License
	// https://spdx.org/licenses/Xerox.html
	"Xerox",

	// X.Net License
	// https://spdx.org/licenses/Xnet.html
	"Xnet",

	// Yahoo! Public License v1.0
	// https://spdx.org/licenses/YPL-1.0.html
	"YPL-1.0",

	// Yahoo! Public License v1.1
	// https://spdx.org/licenses/YPL-1.1.html
	"YPL-1.1",

	// Zope Public License 1.1
	// https://spdx.org/licenses/ZPL-1.1.html
	"ZPL-1.1",

	// Zope Public License 2.0
	// https://spdx.org/licenses/ZPL-2.0.html
	"ZPL-2.0",

	// Zope Public License 2.1
	// https://spdx.org/licenses/ZPL-2.1.html
	"ZPL-2.1",

	// Zed License
	// https://spdx.org/licenses/Zed.html
	"Zed",

	// Zend License v2.0
	// https://spdx.org/licenses/Zend-2.0.html
	"Zend-2.0",

	// Zimbra Public License v1.3
	// https://spdx.org/licenses/Zimbra-1.3.html
	"Zimbra-1.3",

	// Zimbra Public License v1.4
	// https://spdx.org/licenses/Zimbra-1.4.html
	"Zimbra-1.4",

	// zlib License
	// https://spdx.org/licenses/Zlib.html
	"Zlib",

	// SQLite Blessing
	// https://spdx.org/licenses/blessing.html
	"blessing",

	// bzip2 and libbzip2 License v1.0.6
	// https://spdx.org/licenses/bzip2-1.0.6.html
	"bzip2-1.0.6",

	// copyleft-next 0.3.0
	// https://spdx.org/licenses/copyleft-next-0.3.0.html
	"copyleft-next-0.3.0",

	// copyleft-next 0.3.1
	// https://spdx.org/licenses/copyleft-next-0.3.1.html
	"copyleft-next-0.3.1",

	// curl License
	// https://spdx.org/licenses/curl.html
	"curl",

	// diffmark license
	// https://spdx.org/licenses/diffmark.html
	"diffmark",

	// dvipdfm License
	// https://spdx.org/licenses/dvipdfm.html
	"dvipdfm",

	// eGenix.com Public License 1.1.0
	// https://spdx.org/licenses/eGenix.html
	"eGenix",

	// Etalab Open License 2.0
	// https://spdx.org/licenses/etalab-2.0.html
	"etalab-2.0",

	// gSOAP Public License v1.3b
	// https://spdx.org/licenses/gSOAP-1.3b.html
	"gSOAP-1.3b",

	// gnuplot License
	// https://spdx.org/licenses/gnuplot.html
	"gnuplot",

	// iMatix Standard Function Library Agreement
	// https://spdx.org/licenses/iMatix.html
	"iMatix",

	// PNG Reference Library version 2
	// https://spdx.org/licenses/libpng-2.0.html
	"libpng-2.0",

	// libselinux public domain notice
	// https://spdx.org/licenses/libselinux-1.0.html
	"libselinux-1.0",

	// libtiff License
	// https://spdx.org/licenses/libtiff.html
	"libtiff",

	// mpi Permissive License
	// https://spdx.org/licenses/mpi-permissive.html
	"mpi-permissive",

	// mpich2 License
	// https://spdx.org/licenses/mpich2.html
	"mpich2",

	// mplus Font License
	// https://spdx.org/licenses/mplus.html
	"mplus",

	// psfrag License
	// https://spdx.org/licenses/psfrag.html
	"psfrag",

	// psutils License
	// https://spdx.org/licenses/psutils.html
	"psutils",

	// xinetd License
	// https://spdx.org/licenses/xinetd.html
	"xinetd",

	// XPP License
	// https://spdx.org/licenses/xpp.html
	"xpp",

	// zlib/libpng License with Acknowledgement
	// https://spdx.org/licenses/zlib-acknowledgement.html
	"zlib-acknowledgement",
}

// ValidSPDX takes in a string and returns true if it represents a valid SPDX ID
func ValidSPDX(id string) bool {
	for _, v := range spdxIds {
		if v == id {
			return true
		}
	}
	return false
}
