/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_gsw extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_PW = "Palau";
        final String metaValue_ar = "Arabisch";
        final String metaValue_hy = "Armenisch";
        final String metaValue_ban = "Balinesisch";
        final String metaValue_bn = "Bengalisch";
        final String metaValue_zbl = "Bliss-Symbool";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Koptisch";
        final String metaValue_ka = "Georgisch";
        final String metaValue_got = "Gotisch";
        final String metaValue_el = "Griechisch";
        final String metaValue_zh = "Chineesisch";
        final String metaValue_he = "Hebräisch";
        final String metaValue_ja = "Japanisch";
        final String metaValue_kn = "Kannada";
        final String metaValue_mn = "Mongolisch";
        final String metaValue_nqo = "N’Ko";
        final String metaValue_ota = "Osmanisch";
        final String metaValue_sam = "Samaritanisch";
        final String metaValue_si = "Singhalesisch";
        final String metaValue_su = "Sundanesisch";
        final String metaValue_syr = "Syrisch";
        final String metaValue_ta = "Tamilisch";
        final String metaValue_te = "Telugu";
        final String metaValue_tl = "Tagalog";
        final String metaValue_bo = "Tibeetisch";
        final String metaValue_uga = "Ugaritisch";
        final String metaValue_peo = "Altpersisch";
        final Object[][] data = new Object[][] {
            { "001", "Wält" },
            { "002", "Afrika" },
            { "003", "Nordameerika" },
            { "005", "Süüdameerika" },
            { "009", "Ozeaanie" },
            { "011", "Weschtafrika" },
            { "013", "Mittelameerika" },
            { "014", "Oschtafrika" },
            { "015", "Nordafrika" },
            { "017", "Zentraalafrika" },
            { "018", "Süüdlichs Afrika" },
            { "019", "Nord-, Mittel- und Süüdameerika" },
            { "021", "Nördlichs Ameerika" },
            { "029", "Karibik" },
            { "030", "Oschtaasie" },
            { "034", "Süüdaasie" },
            { "035", "Süüdoschtaasie" },
            { "039", "Süüdeuropa" },
            { "053", "Auschtraalie und Nöiseeland" },
            { "054", "Melaneesie" },
            { "057", "Mikroneesischs Inselgebiet" },
            { "061", "Polineesie" },
            { "142", "Aasie" },
            { "143", "Zentraalaasie" },
            { "145", "Weschtaasie" },
            { "150", "Euroopa" },
            { "151", "Oschteuroopa" },
            { "154", "Nordeuroopa" },
            { "155", "Weschteuroopa" },
            { "419", "Latiinameerika" },
            { "AD", "Andorra" },
            { "AE", "Veräinigti Arabischi Emirate" },
            { "AF", "Afganischtan" },
            { "AG", "Antigua und Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albaanie" },
            { "AM", "Armeenie" },
            { "AO", "Angoola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentiinie" },
            { "AS", "Amerikaanisch-Samoa" },
            { "AT", "Ööschtriich" },
            { "AU", "Auschtraalie" },
            { "AW", "Aruba" },
            { "AX", "Aaland-Insle" },
            { "AZ", "Aserbäidschan" },
            { "BA", "Bosnie und Herzegowina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesch" },
            { "BE", "Belgie" },
            { "BF", "Burkina Faaso" },
            { "BG", "Bulgaarie" },
            { "BH", "Bachräin" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barthelemi" },
            { "BM", "Bermuuda" },
            { "BN", "Brunäi Tarussalam" },
            { "BO", "Boliivie" },
            { "BR", "Brasilie" },
            { "BS", "Bahaamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet-Insle" },
            { "BW", "Botswana" },
            { "BY", "Wiissrussland" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokos-Insle" },
            { "CD", "Temokraatischi Republik Kongo" },
            { "CF", "Zentraalafrikaanischi Republik" },
            { "CG", "Kongo" },
            { "CH", "Schwiiz" },
            { "CI", "Elfebäiküschte" },
            { "CK", "Cook-Insle" },
            { "CL", "Tschile" },
            { "CM", "Kamerun" },
            { "CN", "Chiina" },
            { "CO", "Kolumbie" },
            { "CR", "Coschta Rica" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CX", "Wienachts-Insle" },
            { "CY", "Zypere" },
            { "CZ", "Tschechischi Republik" },
            { "DE", "Tüütschland" },
            { "DJ", "Tschibuuti" },
            { "DK", "Tänemark" },
            { "DM", "Tominica" },
            { "DO", "Tominikaanischi Republik" },
            { "DZ", "Algeerie" },
            { "EC", "Ecuador" },
            { "EE", "Eestland" },
            { "EG", "Ägüpte" },
            { "EH", "Weschtsahara" },
            { "ER", "Äritreea" },
            { "ES", "Schpanie" },
            { "ET", "Äthiopie" },
            { "EU", "Europääischi Unioon" },
            { "FI", "Finnland" },
            { "FJ", "Fitschi" },
            { "FK", "Falkland-Insle" },
            { "FM", "Mikroneesie" },
            { "FO", "Färöer" },
            { "FR", "Frankriich" },
            { "GA", "Gabun" },
            { "GB", "Veräinigts Chönigriich" },
            { "GD", "Grenada" },
            { "GE", "Geoorgie" },
            { "GF", "Französisch-Guäjaana" },
            { "GG", "Gäärnsi" },
            { "GH", "Gaana" },
            { "GI", "Gibraltar" },
            { "GL", "Gröönland" },
            { "GM", "Gambia" },
            { "GN", "Gineea" },
            { "GP", "Guadälup" },
            { "GQ", "Äquatoriaalgineea" },
            { "GR", "Griecheland" },
            { "GS", "Süüdgeorgie und d’süüdlichi Sändwitsch-Insle" },
            { "GT", "Guatemaala" },
            { "GU", "Guam" },
            { "GW", "Gineea-Bissau" },
            { "GY", "Guäjaana" },
            { "HK", "Sonderverwaltigszone Hongkong" },
            { "HM", "Höörd- und MäcDonald-Insle" },
            { "HN", "Honduras" },
            { "HR", "Kroaazie" },
            { "HT", "Haiti" },
            { "HU", "Ungarn" },
            { "ID", "Indoneesie" },
            { "IE", "Irland" },
            { "IL", "Israel" },
            { "IM", "Insle vo Män" },
            { "IN", "Indie" },
            { "IQ", "Iraak" },
            { "IR", "Iraan" },
            { "IS", "Iisland" },
            { "IT", "Itaalie" },
            { "JE", "Dschörsi" },
            { "JM", "Dschamäika" },
            { "JO", "Jordaanie" },
            { "JP", "Japan" },
            { "KE", "Keenia" },
            { "KG", "Kirgiisischtan" },
            { "KH", "Kambodscha" },
            { "KI", "Kiribaati" },
            { "KM", "Komoore" },
            { "KN", "St. Kitts und Niuwis" },
            { "KP", "Demokraatischi Volksrepublik Koreea" },
            { "KR", "Republik Koreea" },
            { "KW", "Kuwäit" },
            { "KY", "Käimän-Insle" },
            { "KZ", "Kasachschtan" },
            { "LA", "Laaos" },
            { "LB", "Libanon" },
            { "LC", "St. Lutschiia" },
            { "LI", "Liächteschtäi" },
            { "LK", "Schri Lanka" },
            { "LR", "Libeeria" },
            { "LS", "Lesooto" },
            { "LT", "Littaue" },
            { "LU", "Luxemburg" },
            { "LV", "Lettland" },
            { "LY", "Lüübie" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Republik Moldau" },
            { "ME", "Monteneegro" },
            { "MF", "St. Martin" },
            { "MG", "Madagaschkar" },
            { "MH", "Marshallinsle" },
            { "ML", "Maali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolei" },
            { "MO", "Sonderverwaltigszone Macao" },
            { "MP", "Nördlichi Mariaane" },
            { "MQ", "Martinigg" },
            { "MR", "Mauretaanie" },
            { "MS", "Moosörrat" },
            { "MT", "Malta" },
            { "MU", "Mauriizius" },
            { "MV", "Malediiwe" },
            { "MW", "Malaawi" },
            { "MX", "Mexiko" },
            { "MY", "Maläisia" },
            { "MZ", "Mosambik" },
            { "NA", "Namiibia" },
            { "NC", "Nöikaledoonie" },
            { "NE", "Niger" },
            { "NF", "Norfolk-Insle" },
            { "NG", "Nigeeria" },
            { "NI", "Nicaraagua" },
            { "NL", "Holland" },
            { "NO", "Norweege" },
            { "NP", "Neepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nöiseeland" },
            { "OM", "Omaan" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Französisch-Polineesie" },
            { "PG", "Papua-Neuguinea" },
            { "PH", "Philippiine" },
            { "PK", "Pakischtan" },
            { "PL", "Poole" },
            { "PM", "St. Pierr und Miggelo" },
            { "PN", "Pitggäärn" },
            { "PR", "Puerto Riggo" },
            { "PS", "Paläschtinänsischi Gebiet" },
            { "PT", "Portugal" },
            { "PW", metaValue_PW },
            { "PY", "Paraguai" },
            { "QA", "Ggatar" },
            { "QO", "Üssers Ozeaanie" },
            { "RE", "Reünioon" },
            { "RO", "Rumäänie" },
            { "RS", "Särbie" },
            { "RU", "Russland" },
            { "RW", "Ruanda" },
            { "SA", "Saudi-Araabie" },
            { "SB", "Salomoone" },
            { "SC", "Seischälle" },
            { "SD", "Sudan" },
            { "SE", "Schweede" },
            { "SG", "Singapuur" },
            { "SH", "St. Helena" },
            { "SI", "Sloweenie" },
            { "SJ", "Svalbard und Jaan Määie" },
            { "SK", "Slowakäi" },
            { "SL", "Sierra Leoone" },
            { "SM", "San Mariino" },
            { "SN", "Senegal" },
            { "SO", "Somaalie" },
            { "SR", "Surinam" },
            { "ST", "Sao Tome und Prinssipe" },
            { "SV", "El Salvador" },
            { "SY", "Süürie" },
            { "SZ", "Swasiland" },
            { "TC", "Törks- und Gaiggos-Insle" },
            { "TD", "Tschad" },
            { "TF", "Französischi Süüd- und Antarktisgebiet" },
            { "TG", "Toogo" },
            { "TH", "Thailand" },
            { "TJ", "Tadschikischtan" },
            { "TK", "Tokelau" },
            { "TL", "Oschttimor" },
            { "TM", "Turkmeenischtan" },
            { "TN", "Tuneesie" },
            { "TO", "Tonga" },
            { "TR", "Türggei" },
            { "TT", "Trinidad und Tobaago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansaniia" },
            { "UA", "Ukraiine" },
            { "UG", "Uganda" },
            { "UM", "Amerikanisch-Ozeaanie" },
            { "US", "Veräinigti Schtaate" },
            { "UY", "Uruguay" },
            { "UZ", "Uschbeekischtan" },
            { "VA", "Vatikanstadt" },
            { "VC", "St. Vincent und d’Grönadiine" },
            { "VE", "Venezueela" },
            { "VG", "Britischi Jungfere-Insle" },
            { "VI", "Amerikaanischi Jungfere-Insle" },
            { "VN", "Wietnam" },
            { "VU", "Wanuatu" },
            { "WF", "Wallis und Futuuna" },
            { "WS", "Samooa" },
            { "YE", "Jeeme" },
            { "YT", "Majott" },
            { "ZA", "Süüdafrika" },
            { "ZM", "Sambia" },
            { "ZW", "Simbabwe" },
            { "ZZ", "Unbekannti oder ungültigi Regioon" },
            { "aa", "Afar" },
            { "ab", "Abchasisch" },
            { "ae", "Avestisch" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amharisch" },
            { "an", "Aragonesisch" },
            { "ar", metaValue_ar },
            { "as", "Assamesisch" },
            { "av", "Awarisch" },
            { "ay", "Aymara" },
            { "az", "Aserbaidschanisch" },
            { "ba", "Baschkirisch" },
            { "be", "Wiissrussisch" },
            { "bg", "Bulgaarisch" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "Brötoonisch" },
            { "bs", "Bosnisch" },
            { "ca", "Katalaanisch" },
            { "ce", "Tschetscheenisch" },
            { "ch", "Chamorro" },
            { "co", "Korsisch" },
            { "cr", "Cree" },
            { "cs", "Tschechisch" },
            { "cu", "Chileslawisch" },
            { "cv", "Tschuwaschisch" },
            { "cy", "Walisisch" },
            { "da", "Tänisch" },
            { "de", "Tüütsch" },
            { "dv", "Malediivisch" },
            { "dz", "Dschongkha" },
            { "ee", "Ewe" },
            { "el", metaValue_el },
            { "en", "Änglisch" },
            { "eo", "Eschperanto" },
            { "es", "Schpanisch" },
            { "et", "Eestnisch" },
            { "eu", "Baskisch" },
            { "fa", "Persisch" },
            { "ff", "Ful" },
            { "fi", "Finnisch" },
            { "fj", "Fidschianisch" },
            { "fo", "Färöisch" },
            { "fr", "Französisch" },
            { "fy", "Friesisch" },
            { "ga", "Iirisch" },
            { "gd", "Schottisch-Gäälisch" },
            { "gl", "Galizisch" },
            { "gn", "Guarani" },
            { "gu", "Gujarati" },
            { "gv", "Manx-Gäälisch" },
            { "ha", "Haussa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "ho", "Hiri-Motu" },
            { "hr", "Kroazisch" },
            { "ht", "Haitisch" },
            { "hu", "Ungarisch" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Indonesisch" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sezuanischs Yi" },
            { "ik", "Inupiak" },
            { "io", "Ido" },
            { "is", "Iisländisch" },
            { "it", "Italiänisch" },
            { "iu", "Inukitut" },
            { "ja", metaValue_ja },
            { "jv", "Javanisch" },
            { "ka", metaValue_ka },
            { "kg", "Kongolesisch" },
            { "ki", "Kikuyu-Schpraach" },
            { "kj", "Kwanyama" },
            { "kk", "Kasachisch" },
            { "kl", "Gröönländisch" },
            { "km", "Kambodschanisch" },
            { "kn", metaValue_kn },
            { "ko", "Koreaanisch" },
            { "kr", "Kanuri-Schpraach" },
            { "ks", "Kaschmirisch" },
            { "ku", "Kurdisch" },
            { "kv", "Komi-Schpraach" },
            { "kw", "Kornisch" },
            { "ky", "Kirgiisisch" },
            { "la", "Latiin" },
            { "lb", "Luxemburgisch" },
            { "lg", "Ganda-Schpraach" },
            { "li", "Limburgisch" },
            { "ln", "Lingala" },
            { "lo", "Laozisch" },
            { "lt", "Litauisch" },
            { "lu", "Luba" },
            { "lv", "Lettisch" },
            { "mg", "Madagassisch" },
            { "mh", "Marschallesisch" },
            { "mi", "Maori" },
            { "mk", "Mazedonisch" },
            { "ml", "Malayalam" },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Malaiisch" },
            { "mt", "Maltesisch" },
            { "my", "Birmanisch" },
            { "na", "Nauruisch" },
            { "nb", "Norwegisch Bokmål" },
            { "nd", "Nord-Ndebele-Schpraach" },
            { "ne", "Nepalesisch" },
            { "ng", "Ndonga" },
            { "nl", "Niderländisch" },
            { "nn", "Norwegisch Nynorsk" },
            { "no", "Norwegisch" },
            { "nr", "Süüd-Ndebele-Schpraach" },
            { "nv", "Navajo-Schpraach" },
            { "ny", "Chewa-Schpraach" },
            { "oc", "Okzitanisch" },
            { "oj", "Ojibwa-Schpraach" },
            { "om", "Oromo" },
            { "or", "Orija" },
            { "os", "Ossezisch" },
            { "pa", "Pandschabisch" },
            { "pi", "Pali" },
            { "pl", "Polnisch" },
            { "ps", "Paschtu" },
            { "pt", "Portugiisisch" },
            { "qu", "Quechua" },
            { "rm", "Rätoromanisch" },
            { "rn", "Rundi-Schpraach" },
            { "ro", "Rumänisch" },
            { "ru", "Russisch" },
            { "rw", "Ruandisch" },
            { "sa", "Sanschkrit" },
            { "sc", "Sardisch" },
            { "sd", "Sindhi" },
            { "se", "Nord-Samisch" },
            { "sg", "Sango" },
            { "sh", "Serbo-Kroatisch" },
            { "si", metaValue_si },
            { "sk", "Slowakisch" },
            { "sl", "Slowenisch" },
            { "sm", "Samoanisch" },
            { "sn", "Schhona" },
            { "so", "Somali" },
            { "sq", "Albanisch" },
            { "sr", "Serbisch" },
            { "ss", "Swazi" },
            { "st", "Süüd-Sotho-Schpraach" },
            { "su", metaValue_su },
            { "sv", "Schwedisch" },
            { "sw", "Suaheli" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "Tadschikisch" },
            { "th", "Thailändisch" },
            { "ti", "Tigrinja" },
            { "tk", "Turkmenisch" },
            { "tl", metaValue_tl },
            { "tn", "Tswana-Schpraach" },
            { "to", "Tongaisch" },
            { "tr", "Türkisch" },
            { "ts", "Tsonga" },
            { "tt", "Tatarisch" },
            { "tw", "Twi" },
            { "ty", "Tahitisch" },
            { "ug", "Uigurisch" },
            { "uk", "Ukrainisch" },
            { "ur", "Urdu" },
            { "uz", "Usbekisch" },
            { "ve", "Venda-Schpraach" },
            { "vi", "Vietnamesisch" },
            { "vo", "Volapük" },
            { "wa", "Wallonisch" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Jiddisch" },
            { "yo", "Yoruba" },
            { "za", "Zhuang" },
            { "zh", metaValue_zh },
            { "zu", "Zulu" },
            { "ace", "Aceh" },
            { "ach", "Acholi" },
            { "ada", "Adangme" },
            { "ady", "Adygai" },
            { "afh", "Afrihili" },
            { "ain", "Ainu" },
            { "akk", "Akkadisch" },
            { "ale", "Aleutisch" },
            { "alt", "Süüd-Altaisch" },
            { "ang", "Altänglisch" },
            { "anp", "Angika" },
            { "arc", "Aramääisch" },
            { "arn", "Araukanisch" },
            { "arp", "Arapaho" },
            { "arw", "Arawak" },
            { "ast", "Aschturianisch" },
            { "awa", "Awadhi" },
            { "bal", "Belutschisch" },
            { "ban", metaValue_ban },
            { "bas", "Basaa" },
            { "bej", "Bedauye" },
            { "bem", "Bemba" },
            { "bho", "Bhodschpuri" },
            { "bik", "Bikolisch" },
            { "bin", "Bini" },
            { "bla", "Blackfoot-Schpraach" },
            { "bra", "Braj-Bhakha" },
            { "bua", "Burjatisch" },
            { "bug", "Bugineesisch" },
            { "byn", "Blin" },
            { "cad", "Caddo" },
            { "car", "Kariibisch" },
            { "cch", "Atsam" },
            { "ceb", "Cebuano" },
            { "chb", "Tschibtscha" },
            { "chg", "Tschagataisch" },
            { "chk", "Trukesisch" },
            { "chm", "Tscheremissisch" },
            { "chn", "Chinook" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "Cheyenne" },
            { "cop", metaValue_cop },
            { "crh", "Krimtatarisch" },
            { "csb", "Kaschubisch" },
            { "dak", "Takota" },
            { "dar", "Targiinisch" },
            { "del", "Delaware-Schpraach" },
            { "den", "Slavey" },
            { "dgr", "Togrib" },
            { "din", "Tinka" },
            { "doi", "Togri" },
            { "dsb", "Nidersorbisch" },
            { "dua", "Tuala" },
            { "dum", "Mittelniderländisch" },
            { "dyu", "Tiula" },
            { "efi", "Efikisch" },
            { "egy", "Altägyptisch" },
            { "eka", "Ekajuk" },
            { "elx", "Elamisch" },
            { "enm", "Mittelänglisch" },
            { "ewo", "Ewondo" },
            { "fan", "Pangwe-Schpraach" },
            { "fat", "Fanti-Schpraach" },
            { "fil", "Filipino" },
            { "fon", "Fon" },
            { "frm", "Mittelfranzösisch" },
            { "fro", "Altfranzösisch" },
            { "frr", "Nordfriesisch" },
            { "frs", "Oschtfriesisch" },
            { "fur", "Friulisch" },
            { "gaa", "Ga" },
            { "gay", "Gayo" },
            { "gba", "Gbaya" },
            { "gez", "Geez" },
            { "gil", "Gilbertesisch" },
            { "gmh", "Mittelhochtüütsch" },
            { "goh", "Althochtüütsch" },
            { "gon", "Gondi" },
            { "gor", "Mongondou" },
            { "got", metaValue_got },
            { "grb", "Grebo" },
            { "grc", "Altgriechisch" },
            { "gsw", "Schwiizertüütsch" },
            { "gwi", "Kutchinisch" },
            { "hai", "Haida" },
            { "haw", "Hawaiianisch" },
            { "hil", "Hiligaynonisch" },
            { "hit", "Hethitisch" },
            { "hmn", "Miao" },
            { "hsb", "Obersorbisch" },
            { "hup", "Hupa" },
            { "iba", "Ibanisch" },
            { "ilo", "Ilokano" },
            { "inh", "Inguschisch" },
            { "jbo", "Lojbanisch" },
            { "jpr", "Jüüdisch-Persisch" },
            { "jrb", "Jüüdisch-Arabisch" },
            { "kaa", "Karakalpakisch" },
            { "kab", "Kabylisch" },
            { "kac", "Kachin-Schpraach" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kaw", "Kawi" },
            { "kbd", "Kabardinisch" },
            { "kcg", "Tyap" },
            { "kfo", "Koro" },
            { "kha", "Khasisch" },
            { "kho", "Sakisch" },
            { "kmb", "Kimbundu-Schpraach" },
            { "kok", "Konkani" },
            { "kos", "Kosraeanisch" },
            { "kpe", "Kpelle-Schpraach" },
            { "krc", "Karatschaiisch-Balkarisch" },
            { "krl", "Karelisch" },
            { "kru", "Oraon-Schpraach" },
            { "kum", "Kumükisch" },
            { "kut", "Kutenai-Schpraach" },
            { "lad", "Ladino" },
            { "lah", "Lahndanisch" },
            { "lam", "Lambanisch" },
            { "lez", "Lesgisch" },
            { "lol", "Mongo" },
            { "loz", "Rotse-Schpraach" },
            { "lua", "Luba-Lulua" },
            { "lui", "Luiseno-Schpraach" },
            { "lun", "Lunda-Schpraach" },
            { "luo", "Luo-Schpraach" },
            { "lus", "Lushai-Schpraach" },
            { "mad", "Maduresisch" },
            { "mag", "Khotta" },
            { "mai", "Maithili" },
            { "mak", "Makassarisch" },
            { "man", "Manding-Schpraach" },
            { "mas", "Massai-Schpraach" },
            { "mdf", "Mokschamordwinisch" },
            { "mdr", "Mandaresisch" },
            { "men", "Mende-Schpraach" },
            { "mga", "Mittelirisch" },
            { "mic", "Micmac-Schpraach" },
            { "min", "Minangkabau-Schpraach" },
            { "mnc", "Mandschurisch" },
            { "mni", "Meithei-Schpraach" },
            { "moh", "Mohawk-Schpraach" },
            { "mos", "Mossi-Schpraach" },
            { "mul", "Mehrschpraachig" },
            { "mus", "Muskogee-Schpraach" },
            { "mwl", "Mirandesisch" },
            { "mwr", "Marwarisch" },
            { "myv", "Erzya" },
            { "nap", "Neapolitanisch" },
            { "nds", "Nidertüütsch" },
            { "new", "Newarisch" },
            { "nia", "Nias-Schpraach" },
            { "niu", "Niue-Schpraach" },
            { "nog", "Nogaisch" },
            { "non", "Altnordisch" },
            { "nqo", metaValue_nqo },
            { "nso", "Nord-Sotho-Schpraach" },
            { "nwc", "Alt-Newari" },
            { "nym", "Nyamwezi-Schpraach" },
            { "nyn", "Nyankole" },
            { "nyo", "Nyoro" },
            { "nzi", "Nzima" },
            { "osa", "Osage-Schpraach" },
            { "ota", metaValue_ota },
            { "pag", "Pangasinanisch" },
            { "pal", "Mittelpersisch" },
            { "pam", "Pampanggan-Schpraach" },
            { "pap", "Papiamento" },
            { "pau", metaValue_PW },
            { "peo", metaValue_peo },
            { "phn", "Phönikisch" },
            { "pon", "Ponapeanisch" },
            { "pro", "Altprovenzalisch" },
            { "raj", "Rajasthani" },
            { "rap", "Oschterinsel-Schpraach" },
            { "rar", "Rarotonganisch" },
            { "rom", "Zigüünerschpraach" },
            { "rup", "Aromunisch" },
            { "sad", "Sandawe-Schpraach" },
            { "sah", "Jakutisch" },
            { "sam", metaValue_sam },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "scn", "Sizilianisch" },
            { "sco", "Schottisch" },
            { "sel", "Selkupisch" },
            { "sga", "Altirisch" },
            { "shn", "Schan-Schpraach" },
            { "sid", "Sidamo" },
            { "sma", "Süüd-Samisch" },
            { "smj", "Lule-Samisch" },
            { "smn", "Inari-Samisch" },
            { "sms", "Skolt-Samisch" },
            { "snk", "Soninke-Schpraach" },
            { "sog", "Sogdisch" },
            { "srn", "Srananisch" },
            { "srr", "Serer-Schpraach" },
            { "suk", "Sukuma-Schpraach" },
            { "sus", "Susu" },
            { "sux", "Sumerisch" },
            { "syc", "Altsyrisch" },
            { "syr", metaValue_syr },
            { "tem", "Temne" },
            { "ter", "Tereno-Schpraach" },
            { "tet", "Tetum-Schpraach" },
            { "tig", "Tigre" },
            { "tiv", "Tiv-Schpraach" },
            { "tkl", "Tokelauanisch" },
            { "tlh", "Klingonisch" },
            { "tli", "Tlingit-Schpraach" },
            { "tmh", "Tamaseq" },
            { "tog", "Tsonga-Schpraach" },
            { "tpi", "Neumelanesisch" },
            { "tsi", "Tsimshian-Schpraach" },
            { "tum", "Tumbuka-Schpraach" },
            { "tvl", "Elliceanisch" },
            { "tyv", "Tuwinisch" },
            { "udm", "Udmurtisch" },
            { "uga", metaValue_uga },
            { "umb", "Mbundu-Schpraach" },
            { "und", "Unbeschtimmti Schpraach" },
            { "vai", "Vai-Schpraach" },
            { "vot", "Wotisch" },
            { "wal", "Walamo-Schpraach" },
            { "war", "Waray" },
            { "was", "Washo-Schpraach" },
            { "xal", "Kalmückisch" },
            { "yao", "Yao-Schpraach" },
            { "yap", "Yapesisch" },
            { "zap", "Zapotekisch" },
            { "zbl", metaValue_zbl },
            { "zen", "Zenaga" },
            { "zun", "Zuni-Schpraach" },
            { "zxx", "Kän schpraachliche Inhalt" },
            { "zza", "Zaza" },
            { "Arab", metaValue_ar },
            { "Armn", metaValue_hy },
            { "Avst", "Aveschtisch" },
            { "Bali", metaValue_ban },
            { "Batk", "Battakisch" },
            { "Beng", metaValue_bn },
            { "Blis", metaValue_zbl },
            { "Bopo", "Bopomofo" },
            { "Brah", "Brahmi" },
            { "Brai", "Blindäschrift" },
            { "Bugi", "Buginesisch" },
            { "Buhd", "Buhid" },
            { "Cans", "UCAS" },
            { "Cari", "Karisch" },
            { "Cher", metaValue_chr },
            { "Cirt", "Cirth" },
            { "Copt", metaValue_cop },
            { "Cprt", "Zypriotisch" },
            { "Cyrl", "Kyrillisch" },
            { "Cyrs", "Altchileslawisch" },
            { "Deva", "Tövanagaari" },
            { "Dsrt", "Teseret" },
            { "Egyd", "Temozisch-Ägüptisch" },
            { "Egyh", "Hiraazisch-Ägüptisch" },
            { "Egyp", "Ägüptischi Hiroglüüfe" },
            { "Ethi", "Äzioopisch" },
            { "Geok", "Ghutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "Glagolitisch" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", "Guscharati" },
            { "Guru", "Gurmukhi" },
            { "Hang", "Hangul" },
            { "Hani", metaValue_zh },
            { "Hano", "Hanunoo" },
            { "Hans", "Veräifachti Chineesischi Schrift" },
            { "Hant", "Tradizionelli Chineesischi Schrift" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana" },
            { "Hmng", "Pahawh Hmong" },
            { "Hrkt", "Katakana oder Hiragana" },
            { "Hung", "Altungarisch" },
            { "Inds", "Indus-Schrift" },
            { "Ital", "Altitalisch" },
            { "Java", "Javanesisch" },
            { "Jpan", metaValue_ja },
            { "Kali", "Kayah Li" },
            { "Kana", "Katakana" },
            { "Khar", "Kharoshthi" },
            { "Khmr", "Khmer" },
            { "Knda", metaValue_kn },
            { "Kore", "Koreanisch" },
            { "Lana", "Lanna" },
            { "Laoo", "Laotisch" },
            { "Latf", "Latiinisch - Fraktur-Variante" },
            { "Latg", "Latiinisch - Gäälischi Variante" },
            { "Latn", "Latiinisch" },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Linear A" },
            { "Linb", "Linear B" },
            { "Lyci", "Lykisch" },
            { "Lydi", "Lydisch" },
            { "Mand", "Mandäisch" },
            { "Mani", "Manichäisch" },
            { "Maya", "Maya-Hieroglyphä" },
            { "Mero", "Meroitisch" },
            { "Mlym", "Malaysisch" },
            { "Mong", metaValue_mn },
            { "Moon", "Moon" },
            { "Mtei", "Meitei Mayek" },
            { "Mymr", "Burmesisch" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "Ogham" },
            { "Olck", "Ol Chiki" },
            { "Orkh", "Orchon-Runä" },
            { "Orya", "Oriya" },
            { "Osma", metaValue_ota },
            { "Perm", "Altpermisch" },
            { "Phag", "Phags-pa" },
            { "Phlv", "Pahlavi" },
            { "Phnx", "Phönizisch" },
            { "Plrd", "Pollard Phonetisch" },
            { "Rjng", "Rejang" },
            { "Roro", "Rongorongo" },
            { "Runr", "Runäschrift" },
            { "Samr", metaValue_sam },
            { "Sara", "Sarati" },
            { "Saur", "Saurashtra" },
            { "Sgnw", "Gebäärdeschpraach" },
            { "Shaw", "Shaw-Alphabet" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "Syrisch - Eschtrangelo-Variante" },
            { "Syrj", "Weschtsyrisch" },
            { "Syrn", "Oschtsyrisch" },
            { "Tagb", "Tagbanwa" },
            { "Tale", "Tai Le" },
            { "Talu", "Tai Lue" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Teng", "Tengwar" },
            { "Tfng", "Tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "Thaana" },
            { "Thai", "Thai" },
            { "Tibt", metaValue_bo },
            { "Ugar", metaValue_uga },
            { "Vaii", "Vai" },
            { "Visp", "Sichtbari Schpraach" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "Sumerisch-akkadischi Keilschrift" },
            { "Yiii", "Yi" },
            { "Zinh", "G’eerbtä Schriftwärt" },
            { "Zxxx", "Schriftlosi Schpraach" },
            { "Zyyy", "Unbeschtimmt" },
            { "Zzzz", "Uncodiirti Schrift" },
            { "de_AT", "Öschtriichischs Tüütsch" },
            { "de_CH", "Schwiizer Hochtüütsch" },
            { "en_AU", "Auschtralischs Änglisch" },
            { "en_CA", "Kanadischs Änglisch" },
            { "en_GB", "Britischs Änglisch" },
            { "en_US", "Amerikanischs Änglisch" },
            { "es_ES", "Ibeerischs Schpanisch" },
            { "fr_CA", "Kanadischs Französisch" },
            { "fr_CH", "Schwiizer Französisch" },
            { "nl_BE", "Fläämisch" },
            { "pt_BR", "Brasilianischs Portugiisisch" },
            { "pt_PT", "Iberischs Portugiisisch" },
            { "ro_MD", "Moldawisch" },
            { "%%1901", "Alti tüütschi Rächtschriibig" },
            { "%%1994", "Schtandardisierti Resianischi Rächtschriibig" },
            { "%%1996", "Nööi tüütschi Rächtschriibig" },
            { "es_419", "Latiinamerikanischs Schpanisch" },
            { "key.ca", "Kaländer" },
            { "key.co", "Sortiirig" },
            { "key.cu", "Wäährig" },
            { "%%BISKE", "Bela-Tialäkt" },
            { "%%BOONT", "Boontling" },
            { "%%LIPAW", "Lipowaz-Mundart" },
            { "%%NEDIS", "Natisone-Mundart" },
            { "%%NJIVA", "Njiva-Mundart" },
            { "%%OSOJS", "Osojane-Mundart" },
            { "%%POSIX", "Posix" },
            { "%%ROZAJ", "Resianisch" },
            { "%%SAAHO", "Saho" },
            { "%%SOLBA", "Solbica-Mundart" },
            { "zh_Hans", "Veräifachts Chineesisch" },
            { "zh_Hant", "Tradizionells Chineesisch" },
            { "%%FONIPA", "Foneetisch (IPA)" },
            { "%%FONUPA", "Foneetisch (UPA)" },
            { "%%SCOUSE", "Scouse-Mundart" },
            { "%%TARASK", "Taraskievica-Rächtschriibig" },
            { "%%AREVELA", "Oschtarmeenisch" },
            { "%%AREVMDA", "Weschtarmeenisch" },
            { "%%MONOTON", "Monotonisch" },
            { "%%POLYTON", "Politonisch" },
            { "%%REVISED", "Nööi Rächtschriibig" },
            { "%%1606NICT", "Schpaats Mittelfranzösisch" },
            { "%%BAKU1926", "Äinheitlichs Türggischs Alfabeet" },
            { "%%SCOTLAND", "Schottischs Schtandardänglisch" },
            { "type.ca.roc", "Kaländer vor Republik Chiina" },
            { "type.ca.hebrew", "Hebrääisch Kaländer" },
            { "type.ca.indian", "Indisch Nationaalkaländer" },
            { "type.co.pinyin", "Pinyin-Sortiirregle" },
            { "type.co.stroke", "Strichfolg" },
            { "type.ca.chinese", "Chineesisch Kaländer" },
            { "type.ca.buddhist", "Buddhischtisch Kaländer" },
            { "type.ca.japanese", "Japaanisch Kaländer" },
            { "type.ca.gregorian", "Gregoriaanisch Kaländer" },
            { "type.co.phonebook", "Telifonbuech-Sortiirregle" },
            { "type.co.traditional", "Tradizionelli Sortiir-Regle" },
        };
        return data;
    }
}
