// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/beyondcorp/appconnectors/v1/app_connectors_service.proto

#include "google/cloud/beyondcorp/appconnectors/v1/internal/app_connectors_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/beyondcorp/appconnectors/v1/app_connectors_service.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace beyondcorp_appconnectors_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AppConnectorsServiceMetadata::AppConnectorsServiceMetadata(
    std::shared_ptr<AppConnectorsServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<
    google::cloud::beyondcorp::appconnectors::v1::ListAppConnectorsResponse>
AppConnectorsServiceMetadata::ListAppConnectors(
    grpc::ClientContext& context, Options const& options,
    google::cloud::beyondcorp::appconnectors::v1::
        ListAppConnectorsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListAppConnectors(context, options, request);
}

StatusOr<google::cloud::beyondcorp::appconnectors::v1::AppConnector>
AppConnectorsServiceMetadata::GetAppConnector(
    grpc::ClientContext& context, Options const& options,
    google::cloud::beyondcorp::appconnectors::v1::GetAppConnectorRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetAppConnector(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
AppConnectorsServiceMetadata::AsyncCreateAppConnector(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::beyondcorp::appconnectors::v1::
        CreateAppConnectorRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateAppConnector(cq, std::move(context),
                                         std::move(options), request);
}

StatusOr<google::longrunning::Operation>
AppConnectorsServiceMetadata::CreateAppConnector(
    grpc::ClientContext& context, Options options,
    google::cloud::beyondcorp::appconnectors::v1::
        CreateAppConnectorRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateAppConnector(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
AppConnectorsServiceMetadata::AsyncUpdateAppConnector(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::beyondcorp::appconnectors::v1::
        UpdateAppConnectorRequest const& request) {
  SetMetadata(
      *context, *options,
      absl::StrCat("app_connector.name=",
                   internal::UrlEncode(request.app_connector().name())));
  return child_->AsyncUpdateAppConnector(cq, std::move(context),
                                         std::move(options), request);
}

StatusOr<google::longrunning::Operation>
AppConnectorsServiceMetadata::UpdateAppConnector(
    grpc::ClientContext& context, Options options,
    google::cloud::beyondcorp::appconnectors::v1::
        UpdateAppConnectorRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("app_connector.name=",
                   internal::UrlEncode(request.app_connector().name())));
  return child_->UpdateAppConnector(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
AppConnectorsServiceMetadata::AsyncDeleteAppConnector(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::beyondcorp::appconnectors::v1::
        DeleteAppConnectorRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteAppConnector(cq, std::move(context),
                                         std::move(options), request);
}

StatusOr<google::longrunning::Operation>
AppConnectorsServiceMetadata::DeleteAppConnector(
    grpc::ClientContext& context, Options options,
    google::cloud::beyondcorp::appconnectors::v1::
        DeleteAppConnectorRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteAppConnector(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
AppConnectorsServiceMetadata::AsyncReportStatus(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::beyondcorp::appconnectors::v1::ReportStatusRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("app_connector=",
                           internal::UrlEncode(request.app_connector())));
  return child_->AsyncReportStatus(cq, std::move(context), std::move(options),
                                   request);
}

StatusOr<google::longrunning::Operation>
AppConnectorsServiceMetadata::ReportStatus(
    grpc::ClientContext& context, Options options,
    google::cloud::beyondcorp::appconnectors::v1::ReportStatusRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("app_connector=",
                           internal::UrlEncode(request.app_connector())));
  return child_->ReportStatus(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
AppConnectorsServiceMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> AppConnectorsServiceMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void AppConnectorsServiceMetadata::SetMetadata(
    grpc::ClientContext& context, Options const& options,
    std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void AppConnectorsServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                               Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace beyondcorp_appconnectors_v1_internal
}  // namespace cloud
}  // namespace google
