// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/table.proto

#include "google/cloud/bigquerycontrol/v2/internal/table_rest_stub.h"
#include "google/cloud/common_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/rest_stub_helpers.h"
#include "google/cloud/status_or.h"
#include <google/cloud/bigquery/v2/table.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DefaultTableServiceRestStub::DefaultTableServiceRestStub(Options options)
    : service_(rest_internal::MakePooledRestClient(
          options.get<EndpointOption>(), options)),
      options_(std::move(options)) {}

DefaultTableServiceRestStub::DefaultTableServiceRestStub(
    std::shared_ptr<rest_internal::RestClient> service, Options options)
    : service_(std::move(service)), options_(std::move(options)) {}

StatusOr<google::cloud::bigquery::v2::Table>
DefaultTableServiceRestStub::GetTable(
    google::cloud::rest_internal::RestContext& rest_context,
    Options const& options,
    google::cloud::bigquery::v2::GetTableRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  query_params.push_back({"selected_fields", request.selected_fields()});
  query_params.push_back({"view", std::to_string(request.view())});
  query_params =
      rest_internal::TrimEmptyQueryParameters(std::move(query_params));
  return rest_internal::Get<google::cloud::bigquery::v2::Table>(
      *service_, rest_context, request, false,
      absl::StrCat("/", "bigquery", "/",
                   rest_internal::DetermineApiVersion("v2", options), "/",
                   "projects", "/", request.project_id(), "/", "datasets", "/",
                   request.dataset_id(), "/", "tables", "/",
                   request.table_id()),
      std::move(query_params));
}

StatusOr<google::cloud::bigquery::v2::Table>
DefaultTableServiceRestStub::InsertTable(
    google::cloud::rest_internal::RestContext& rest_context,
    Options const& options,
    google::cloud::bigquery::v2::InsertTableRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  return rest_internal::Post<google::cloud::bigquery::v2::Table>(
      *service_, rest_context, request.table(), false,
      absl::StrCat("/", "bigquery", "/",
                   rest_internal::DetermineApiVersion("v2", options), "/",
                   "projects", "/", request.project_id(), "/", "datasets", "/",
                   request.dataset_id(), "/", "tables"),
      std::move(query_params));
}

StatusOr<google::cloud::bigquery::v2::Table>
DefaultTableServiceRestStub::PatchTable(
    google::cloud::rest_internal::RestContext& rest_context,
    Options const& options,
    google::cloud::bigquery::v2::UpdateOrPatchTableRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  query_params.push_back(
      {"autodetect_schema", (request.autodetect_schema() ? "1" : "0")});
  query_params =
      rest_internal::TrimEmptyQueryParameters(std::move(query_params));
  return rest_internal::Patch<google::cloud::bigquery::v2::Table>(
      *service_, rest_context, request.table(), false,
      absl::StrCat("/", "bigquery", "/",
                   rest_internal::DetermineApiVersion("v2", options), "/",
                   "projects", "/", request.project_id(), "/", "datasets", "/",
                   request.dataset_id(), "/", "tables", "/",
                   request.table_id()),
      std::move(query_params));
}

StatusOr<google::cloud::bigquery::v2::Table>
DefaultTableServiceRestStub::UpdateTable(
    google::cloud::rest_internal::RestContext& rest_context,
    Options const& options,
    google::cloud::bigquery::v2::UpdateOrPatchTableRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  query_params.push_back(
      {"autodetect_schema", (request.autodetect_schema() ? "1" : "0")});
  query_params =
      rest_internal::TrimEmptyQueryParameters(std::move(query_params));
  return rest_internal::Put<google::cloud::bigquery::v2::Table>(
      *service_, rest_context, request.table(), false,
      absl::StrCat("/", "bigquery", "/",
                   rest_internal::DetermineApiVersion("v2", options), "/",
                   "projects", "/", request.project_id(), "/", "datasets", "/",
                   request.dataset_id(), "/", "tables", "/",
                   request.table_id()),
      std::move(query_params));
}

Status DefaultTableServiceRestStub::DeleteTable(
    google::cloud::rest_internal::RestContext& rest_context,
    Options const& options,
    google::cloud::bigquery::v2::DeleteTableRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  return rest_internal::Delete<google::cloud::rest_internal::EmptyResponseType>(
      *service_, rest_context, request, false,
      absl::StrCat("/", "bigquery", "/",
                   rest_internal::DetermineApiVersion("v2", options), "/",
                   "projects", "/", request.project_id(), "/", "datasets", "/",
                   request.dataset_id(), "/", "tables", "/",
                   request.table_id()),
      std::move(query_params));
}

StatusOr<google::cloud::bigquery::v2::TableList>
DefaultTableServiceRestStub::ListTables(
    google::cloud::rest_internal::RestContext& rest_context,
    Options const& options,
    google::cloud::bigquery::v2::ListTablesRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  query_params.push_back(
      {"max_results", (request.has_max_results()
                           ? std::to_string(request.max_results().value())
                           : "")});
  query_params.push_back({"page_token", request.page_token()});
  query_params =
      rest_internal::TrimEmptyQueryParameters(std::move(query_params));
  return rest_internal::Get<google::cloud::bigquery::v2::TableList>(
      *service_, rest_context, request, false,
      absl::StrCat("/", "bigquery", "/",
                   rest_internal::DetermineApiVersion("v2", options), "/",
                   "projects", "/", request.project_id(), "/", "datasets", "/",
                   request.dataset_id(), "/", "tables"),
      std::move(query_params));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2_internal
}  // namespace cloud
}  // namespace google
