// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/generator.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_INTERNAL_GENERATORS_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_INTERNAL_GENERATORS_STUB_H

#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/dialogflow/cx/v3/generator.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class GeneratorsStub {
 public:
  virtual ~GeneratorsStub() = 0;

  virtual StatusOr<google::cloud::dialogflow::cx::v3::ListGeneratorsResponse>
  ListGenerators(grpc::ClientContext& context, Options const& options,
                 google::cloud::dialogflow::cx::v3::ListGeneratorsRequest const&
                     request) = 0;

  virtual StatusOr<google::cloud::dialogflow::cx::v3::Generator> GetGenerator(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::cx::v3::GetGeneratorRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::dialogflow::cx::v3::Generator>
  CreateGenerator(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::cx::v3::CreateGeneratorRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::dialogflow::cx::v3::Generator>
  UpdateGenerator(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::cx::v3::UpdateGeneratorRequest const&
          request) = 0;

  virtual Status DeleteGenerator(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::cx::v3::DeleteGeneratorRequest const&
          request) = 0;
};

class DefaultGeneratorsStub : public GeneratorsStub {
 public:
  explicit DefaultGeneratorsStub(
      std::unique_ptr<
          google::cloud::dialogflow::cx::v3::Generators::StubInterface>
          grpc_stub)
      : grpc_stub_(std::move(grpc_stub)) {}

  StatusOr<google::cloud::dialogflow::cx::v3::ListGeneratorsResponse>
  ListGenerators(grpc::ClientContext& context, Options const& options,
                 google::cloud::dialogflow::cx::v3::ListGeneratorsRequest const&
                     request) override;

  StatusOr<google::cloud::dialogflow::cx::v3::Generator> GetGenerator(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::cx::v3::GetGeneratorRequest const& request)
      override;

  StatusOr<google::cloud::dialogflow::cx::v3::Generator> CreateGenerator(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::cx::v3::CreateGeneratorRequest const& request)
      override;

  StatusOr<google::cloud::dialogflow::cx::v3::Generator> UpdateGenerator(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::cx::v3::UpdateGeneratorRequest const& request)
      override;

  Status DeleteGenerator(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::cx::v3::DeleteGeneratorRequest const& request)
      override;

 private:
  std::unique_ptr<google::cloud::dialogflow::cx::v3::Generators::StubInterface>
      grpc_stub_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_INTERNAL_GENERATORS_STUB_H
