// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/page.proto

#include "google/cloud/dialogflow_cx/internal/pages_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/dialogflow/cx/v3/page.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PagesMetadata::PagesMetadata(
    std::shared_ptr<PagesStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::dialogflow::cx::v3::ListPagesResponse>
PagesMetadata::ListPages(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::ListPagesRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListPages(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Page> PagesMetadata::GetPage(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::GetPageRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetPage(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Page> PagesMetadata::CreatePage(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::CreatePageRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreatePage(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Page> PagesMetadata::UpdatePage(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::UpdatePageRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("page.name=", internal::UrlEncode(request.page().name())));
  return child_->UpdatePage(context, options, request);
}

Status PagesMetadata::DeletePage(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::DeletePageRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeletePage(context, options, request);
}

void PagesMetadata::SetMetadata(grpc::ClientContext& context,
                                Options const& options,
                                std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void PagesMetadata::SetMetadata(grpc::ClientContext& context,
                                Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google
