// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/snooze_service.proto

#include "google/cloud/monitoring/v3/internal/snooze_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SnoozeServiceTracingStub::SnoozeServiceTracingStub(
    std::shared_ptr<SnoozeServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::monitoring::v3::Snooze> SnoozeServiceTracingStub::CreateSnooze(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::CreateSnoozeRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.monitoring.v3.SnoozeService",
                                     "CreateSnooze");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateSnooze(context, options, request));
}

StatusOr<google::monitoring::v3::ListSnoozesResponse>
SnoozeServiceTracingStub::ListSnoozes(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::ListSnoozesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.monitoring.v3.SnoozeService",
                                     "ListSnoozes");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListSnoozes(context, options, request));
}

StatusOr<google::monitoring::v3::Snooze> SnoozeServiceTracingStub::GetSnooze(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::GetSnoozeRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.monitoring.v3.SnoozeService", "GetSnooze");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetSnooze(context, options, request));
}

StatusOr<google::monitoring::v3::Snooze> SnoozeServiceTracingStub::UpdateSnooze(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::UpdateSnoozeRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.monitoring.v3.SnoozeService",
                                     "UpdateSnooze");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateSnooze(context, options, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<SnoozeServiceStub> MakeSnoozeServiceTracingStub(
    std::shared_ptr<SnoozeServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<SnoozeServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
