// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/tpu/v1/cloud_tpu.proto

#include "google/cloud/tpu/v1/internal/tpu_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace tpu_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

TpuTracingConnection::TpuTracingConnection(
    std::shared_ptr<tpu_v1::TpuConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::tpu::v1::Node> TpuTracingConnection::ListNodes(
    google::cloud::tpu::v1::ListNodesRequest request) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::ListNodes");
  internal::OTelScope scope(span);
  auto sr = child_->ListNodes(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::tpu::v1::Node>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::tpu::v1::Node> TpuTracingConnection::GetNode(
    google::cloud::tpu::v1::GetNodeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::GetNode");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetNode(request));
}

future<StatusOr<google::cloud::tpu::v1::Node>> TpuTracingConnection::CreateNode(
    google::cloud::tpu::v1::CreateNodeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::CreateNode");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateNode(request));
}

StatusOr<google::longrunning::Operation> TpuTracingConnection::CreateNode(
    NoAwaitTag, google::cloud::tpu::v1::CreateNodeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::CreateNode");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateNode(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::tpu::v1::Node>> TpuTracingConnection::CreateNode(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::CreateNode");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateNode(operation));
}

future<StatusOr<google::cloud::tpu::v1::Node>> TpuTracingConnection::DeleteNode(
    google::cloud::tpu::v1::DeleteNodeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::DeleteNode");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteNode(request));
}

StatusOr<google::longrunning::Operation> TpuTracingConnection::DeleteNode(
    NoAwaitTag, google::cloud::tpu::v1::DeleteNodeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::DeleteNode");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteNode(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::tpu::v1::Node>> TpuTracingConnection::DeleteNode(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::DeleteNode");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteNode(operation));
}

future<StatusOr<google::cloud::tpu::v1::Node>>
TpuTracingConnection::ReimageNode(
    google::cloud::tpu::v1::ReimageNodeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::ReimageNode");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ReimageNode(request));
}

StatusOr<google::longrunning::Operation> TpuTracingConnection::ReimageNode(
    NoAwaitTag, google::cloud::tpu::v1::ReimageNodeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::ReimageNode");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->ReimageNode(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::tpu::v1::Node>>
TpuTracingConnection::ReimageNode(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::ReimageNode");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ReimageNode(operation));
}

future<StatusOr<google::cloud::tpu::v1::Node>> TpuTracingConnection::StopNode(
    google::cloud::tpu::v1::StopNodeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::StopNode");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->StopNode(request));
}

StatusOr<google::longrunning::Operation> TpuTracingConnection::StopNode(
    NoAwaitTag, google::cloud::tpu::v1::StopNodeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::StopNode");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->StopNode(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::tpu::v1::Node>> TpuTracingConnection::StopNode(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::StopNode");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->StopNode(operation));
}

future<StatusOr<google::cloud::tpu::v1::Node>> TpuTracingConnection::StartNode(
    google::cloud::tpu::v1::StartNodeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::StartNode");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->StartNode(request));
}

StatusOr<google::longrunning::Operation> TpuTracingConnection::StartNode(
    NoAwaitTag, google::cloud::tpu::v1::StartNodeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::StartNode");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->StartNode(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::tpu::v1::Node>> TpuTracingConnection::StartNode(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::StartNode");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->StartNode(operation));
}

StreamRange<google::cloud::tpu::v1::TensorFlowVersion>
TpuTracingConnection::ListTensorFlowVersions(
    google::cloud::tpu::v1::ListTensorFlowVersionsRequest request) {
  auto span =
      internal::MakeSpan("tpu_v1::TpuConnection::ListTensorFlowVersions");
  internal::OTelScope scope(span);
  auto sr = child_->ListTensorFlowVersions(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::tpu::v1::TensorFlowVersion>(std::move(span),
                                                 std::move(sr));
}

StatusOr<google::cloud::tpu::v1::TensorFlowVersion>
TpuTracingConnection::GetTensorFlowVersion(
    google::cloud::tpu::v1::GetTensorFlowVersionRequest const& request) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::GetTensorFlowVersion");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTensorFlowVersion(request));
}

StreamRange<google::cloud::tpu::v1::AcceleratorType>
TpuTracingConnection::ListAcceleratorTypes(
    google::cloud::tpu::v1::ListAcceleratorTypesRequest request) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::ListAcceleratorTypes");
  internal::OTelScope scope(span);
  auto sr = child_->ListAcceleratorTypes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::tpu::v1::AcceleratorType>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::tpu::v1::AcceleratorType>
TpuTracingConnection::GetAcceleratorType(
    google::cloud::tpu::v1::GetAcceleratorTypeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v1::TpuConnection::GetAcceleratorType");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetAcceleratorType(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<tpu_v1::TpuConnection> MakeTpuTracingConnection(
    std::shared_ptr<tpu_v1::TpuConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<TpuTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace tpu_v1_internal
}  // namespace cloud
}  // namespace google
