/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.allocation.decider;

import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;

public class DedicatedFrozenNodeAllocationDecider
extends AllocationDecider {
    private static final String NAME = "dedicated_frozen_node";
    private static final Decision YES_NOT_DEDICATED_FROZEN_NODE = Decision.single((Decision.Type)Decision.Type.YES, (String)"dedicated_frozen_node", (String)("this node's data roles are not exactly [" + DiscoveryNodeRole.DATA_FROZEN_NODE_ROLE.roleName() + "] so it is not a dedicated frozen node"), (Object[])new Object[0]);
    private static final Decision YES_IS_PARTIAL_SEARCHABLE_SNAPSHOT = Decision.single((Decision.Type)Decision.Type.YES, (String)"dedicated_frozen_node", (String)"this index is a partially mounted index so it can be assigned to this dedicated frozen node", (Object[])new Object[0]);
    private static final Decision NO = Decision.single((Decision.Type)Decision.Type.NO, (String)"dedicated_frozen_node", (String)("this node's data roles are exactly [" + DiscoveryNodeRole.DATA_FROZEN_NODE_ROLE.roleName() + "] so it may only hold shards from partially mounted indices, but this index is not a partially mounted index"), (Object[])new Object[0]);

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return DedicatedFrozenNodeAllocationDecider.canAllocateToNode(allocation.metadata().getIndexSafe(shardRouting.index()), node.node());
    }

    public Decision canRemain(IndexMetadata indexMetadata, ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return DedicatedFrozenNodeAllocationDecider.canAllocateToNode(indexMetadata, node.node());
    }

    public Decision canAllocate(IndexMetadata indexMetadata, RoutingNode node, RoutingAllocation allocation) {
        return DedicatedFrozenNodeAllocationDecider.canAllocateToNode(indexMetadata, node.node());
    }

    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        return DedicatedFrozenNodeAllocationDecider.canAllocateToNode(indexMetadata, node);
    }

    private static Decision canAllocateToNode(IndexMetadata indexMetadata, DiscoveryNode discoveryNode) {
        boolean hasDataFrozenRole = false;
        boolean hasOtherDataRole = false;
        for (DiscoveryNodeRole role : discoveryNode.getRoles()) {
            if (DiscoveryNodeRole.DATA_FROZEN_NODE_ROLE.equals((Object)role)) {
                hasDataFrozenRole = true;
                continue;
            }
            if (!role.canContainData()) continue;
            hasOtherDataRole = true;
            break;
        }
        if (!hasDataFrozenRole || hasOtherDataRole) {
            return YES_NOT_DEDICATED_FROZEN_NODE;
        }
        if (indexMetadata.isPartialSearchableSnapshot()) {
            return YES_IS_PARTIAL_SEARCHABLE_SNAPSHOT;
        }
        return NO;
    }
}

