/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.sample;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.eql.execution.search.HitReference;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceKey;

class Sample
implements Accountable {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Sample.class);
    private final SequenceKey key;
    private final HitReference[] matches;

    Sample(SequenceKey key, List<SearchHit> searchHits) {
        this.key = key;
        this.matches = new HitReference[searchHits.size()];
        for (int i = 0; i < searchHits.size(); ++i) {
            this.matches[i] = new HitReference(searchHits.get(i));
        }
    }

    public SequenceKey key() {
        return this.key;
    }

    public List<HitReference> hits() {
        return Arrays.asList(this.matches);
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + RamUsageEstimator.sizeOf((Accountable)this.key) + RamUsageEstimator.sizeOf((Accountable[])this.matches);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Sample other = (Sample)obj;
        return Objects.equals(this.key, other.key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LoggerMessageFormat.format(null, (String)"[Samp<{}>]", (Object[])new Object[]{this.key}));
        for (int i = 0; i < this.matches.length; ++i) {
            sb.append(LoggerMessageFormat.format(null, (String)"\n [{}]={{}}", (Object[])new Object[]{i, this.matches[i]}));
        }
        return sb.toString();
    }
}

